/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.aesctr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import libKonogonka.aesctr.AesCtrBufferedInputStream;
import libKonogonka.aesctr.AesCtrDecryptClassic;
import libKonogonka.aesctr.IProducer;
import libKonogonka.aesctr.InFileStreamProducer;

public class InFileStreamClassicProducer
implements IProducer {
    private boolean encrypted;
    private Path filePath;
    private InFileStreamProducer parentProducer;
    private long offset;
    private long encryptedStartOffset;
    private long encryptedEndOffset;
    private AesCtrDecryptClassic decryptor;
    private final long fileSize;

    public InFileStreamClassicProducer(Path filePath, long offset, long encryptedStartOffset, long encryptedEndOffset, String key, byte[] iv) throws Exception {
        this.encrypted = true;
        this.filePath = filePath;
        this.offset = offset;
        this.encryptedStartOffset = encryptedStartOffset;
        this.encryptedEndOffset = encryptedEndOffset;
        this.decryptor = new AesCtrDecryptClassic(key, iv);
        this.fileSize = Files.size(filePath);
    }

    private InFileStreamClassicProducer(Path filePath, long offset, long encryptedStartOffset, long encryptedEndOffset, AesCtrDecryptClassic decryptor) throws Exception {
        this.encrypted = true;
        this.filePath = filePath;
        this.offset = offset;
        this.encryptedStartOffset = encryptedStartOffset;
        this.encryptedEndOffset = encryptedEndOffset;
        this.decryptor = decryptor;
        this.fileSize = Files.size(filePath);
    }

    public InFileStreamClassicProducer(Path filePath) throws Exception {
        this.filePath = filePath;
        this.fileSize = Files.size(filePath);
    }

    public InFileStreamClassicProducer(Path filePath, long offset) throws Exception {
        this.filePath = filePath;
        this.offset = offset;
        this.fileSize = Files.size(filePath);
    }

    public InFileStreamClassicProducer(InFileStreamProducer parentProducer, long offset, long encryptedStartOffset, long encryptedEndOffset, String key, byte[] iv, long fileSize) throws Exception {
        this.parentProducer = parentProducer;
        this.encrypted = true;
        this.offset = offset;
        this.encryptedStartOffset = encryptedStartOffset;
        this.encryptedEndOffset = encryptedEndOffset;
        this.decryptor = new AesCtrDecryptClassic(key, iv);
        this.fileSize = fileSize;
    }

    private InFileStreamClassicProducer(InFileStreamProducer parentProducer, long offset, long encryptedStartOffset, long encryptedEndOffset, AesCtrDecryptClassic decryptor, long fileSize) {
        this.parentProducer = parentProducer;
        this.encrypted = true;
        this.offset = offset;
        this.encryptedStartOffset = encryptedStartOffset;
        this.encryptedEndOffset = encryptedEndOffset;
        this.decryptor = decryptor;
        this.fileSize = fileSize;
    }

    @Override
    public BufferedInputStream produce() throws Exception {
        if (this.encrypted) {
            return this.produceAesCtr();
        }
        return this.produceNotEncrypted();
    }

    private BufferedInputStream produceAesCtr() throws Exception {
        this.decryptor.reset();
        InputStream is = this.filePath == null ? this.parentProducer.produce() : Files.newInputStream(this.filePath, new OpenOption[0]);
        AesCtrBufferedInputStream stream = new AesCtrBufferedInputStream(this.decryptor, this.encryptedStartOffset, this.encryptedEndOffset, is, this.fileSize);
        if (this.offset != stream.skip(this.offset)) {
            throw new Exception("Unable to skip offset: " + this.offset);
        }
        return stream;
    }

    private BufferedInputStream produceNotEncrypted() throws Exception {
        BufferedInputStream stream = this.filePath == null ? new BufferedInputStream(this.parentProducer.produce()) : new BufferedInputStream(Files.newInputStream(this.filePath, new OpenOption[0]));
        if (this.offset != stream.skip(this.offset)) {
            throw new Exception("Unable to skip offset: " + this.offset);
        }
        return stream;
    }

    @Override
    public InFileStreamClassicProducer getSuccessor(long offset) throws Exception {
        if (!this.encrypted) {
            return new InFileStreamClassicProducer(this.filePath, offset);
        }
        if (this.filePath == null) {
            return new InFileStreamClassicProducer(this.parentProducer, offset, this.encryptedStartOffset, this.encryptedEndOffset, this.decryptor, this.fileSize);
        }
        return new InFileStreamClassicProducer(this.filePath, offset, this.encryptedStartOffset, this.encryptedEndOffset, this.decryptor);
    }

    public InFileStreamClassicProducer getSuccessor(long offset, boolean incrementExisting) throws Exception {
        if (incrementExisting) {
            return this.getSuccessor(this.offset + offset);
        }
        return this.getSuccessor(offset);
    }

    @Override
    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Override
    public File getFile() {
        if (this.filePath == null) {
            return this.parentProducer.getFile();
        }
        return this.filePath.toFile();
    }

    public String toString() {
        if (this.filePath == null) {
            return this.parentProducer.getFile().getAbsolutePath();
        }
        return this.filePath.toString();
    }
}

