/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import libKonogonka.aesctr.AesCtrBufferedInputStream;
import libKonogonka.aesctr.AesCtrDecryptForMediaBlocks;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.exceptions.EmptySectionException;
import libKonogonka.fs.NCA.NCAHeaderTableEntry;
import libKonogonka.fs.NCA.NCASectionTableBlock.NcaFsHeader;
import libKonogonka.fs.PFS0.PFS0Provider;
import libKonogonka.fs.RomFs.RomFsProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCAContent {
    private static final Logger log = LogManager.getLogger(NCAContent.class);
    private final File file;
    private final long ncaOffsetPosition;
    private final NcaFsHeader ncaFsHeader;
    private final NCAHeaderTableEntry ncaHeaderTableEntry;
    private final byte[] decryptedKey;
    private PFS0Provider pfs0;
    private RomFsProvider romfs;

    public NCAContent(File file, long ncaOffsetPosition, NcaFsHeader ncaFsHeader, NCAHeaderTableEntry ncaHeaderTableEntry, byte[] decryptedKey) throws Exception {
        this.file = file;
        this.ncaOffsetPosition = ncaOffsetPosition;
        this.ncaFsHeader = ncaFsHeader;
        this.ncaHeaderTableEntry = ncaHeaderTableEntry;
        this.decryptedKey = decryptedKey;
        if (ncaHeaderTableEntry.getMediaEndOffset() == 0L) {
            throw new EmptySectionException("Empty section");
        }
        if (ncaFsHeader.getSuperBlockPFS0() != null) {
            this.proceedPFS0();
        } else if (ncaFsHeader.getSuperBlockIVFC() != null) {
            this.proceedRomFs();
        } else {
            throw new Exception("NCAContent(): Not supported. PFS0 or RomFS supported only.");
        }
    }

    private void proceedPFS0() throws Exception {
        switch (this.ncaFsHeader.getCryptoType()) {
            case 1: {
                this.proceedPFS0NotEncrypted();
                break;
            }
            case 3: {
                this.proceedPFS0Encrypted();
                break;
            }
            default: {
                throw new Exception("'Crypto type' not supported: " + this.ncaFsHeader.getCryptoType());
            }
        }
    }

    private void proceedPFS0NotEncrypted() throws Exception {
        InFileStreamProducer producer = new InFileStreamProducer(this.file);
        this.pfs0 = new PFS0Provider(producer, this.makeOffsetPositionInFile(), this.ncaFsHeader.getSuperBlockPFS0(), this.ncaHeaderTableEntry.getMediaStartOffset());
    }

    private void proceedPFS0Encrypted() throws Exception {
        this.pfs0 = new PFS0Provider(this.makeEncryptedProducer(), this.makeOffsetPositionInFile(), this.ncaFsHeader.getSuperBlockPFS0(), this.ncaHeaderTableEntry.getMediaStartOffset());
    }

    private void proceedRomFs() throws Exception {
        switch (this.ncaFsHeader.getCryptoType()) {
            case 1: {
                this.proceedRomFsNotEncrypted();
                break;
            }
            case 3: {
                this.proceedRomFsEncrypted();
                break;
            }
            default: {
                throw new Exception("Non-supported 'Crypto type' " + this.ncaFsHeader.getCryptoType());
            }
        }
    }

    private void proceedRomFsNotEncrypted() {
        log.error("proceedRomFs() -> proceedRomFsNotEncrypted() is not implemented :(");
    }

    private void proceedRomFsEncrypted() throws Exception {
        if (this.decryptedKey == null) {
            throw new Exception("CryptoSection03: unable to proceed. No decrypted key provided.");
        }
        this.romfs = new RomFsProvider(this.makeEncryptedProducer(), this.ncaFsHeader.getSuperBlockIVFC().getLvl6Offset(), this.makeOffsetPositionInFile(), this.ncaHeaderTableEntry.getMediaStartOffset());
    }

    public PFS0Provider getPfs0() {
        return this.pfs0;
    }

    public RomFsProvider getRomfs() {
        return this.romfs;
    }

    private InFileStreamProducer makeEncryptedProducer() throws Exception {
        AesCtrDecryptForMediaBlocks decryptor = new AesCtrDecryptForMediaBlocks(this.decryptedKey, this.ncaFsHeader.getSectionCTR(), this.ncaHeaderTableEntry.getMediaStartOffset() * 512L);
        return new InFileStreamProducer(this.file, this.ncaOffsetPosition, 0L, decryptor, this.ncaHeaderTableEntry.getMediaStartOffset(), this.ncaHeaderTableEntry.getMediaEndOffset());
    }

    private long makeOffsetPositionInFile() {
        return this.ncaOffsetPosition + this.ncaHeaderTableEntry.getMediaStartOffset() * 512L;
    }

    public boolean exportMediaBlock(String saveToLocation) {
        File location = new File(saveToLocation);
        location.mkdirs();
        long mediaStartOffset = this.ncaHeaderTableEntry.getMediaStartOffset();
        long mediaEndOffset = this.ncaHeaderTableEntry.getMediaEndOffset();
        long mediaBlocksCount = mediaEndOffset - mediaStartOffset;
        try (BufferedOutputStream extractedFileBOS = new BufferedOutputStream(Files.newOutputStream(Paths.get(saveToLocation + File.separator + this.file.getName() + "_MediaBlock.bin", new String[0]), new OpenOption[0]));){
            BufferedInputStream stream;
            if (this.ncaFsHeader.getCryptoType() == 1) {
                stream = new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
            } else if (this.ncaFsHeader.getCryptoType() == 3) {
                AesCtrDecryptForMediaBlocks decryptor = new AesCtrDecryptForMediaBlocks(this.decryptedKey, this.ncaFsHeader.getSectionCTR(), mediaStartOffset * 512L);
                stream = new AesCtrBufferedInputStream(decryptor, this.ncaOffsetPosition, mediaStartOffset, mediaEndOffset, Files.newInputStream(this.file.toPath(), new OpenOption[0]), Files.size(this.file.toPath()));
            } else {
                throw new Exception("Crypto type not supported");
            }
            int i = 0;
            while ((long)i < mediaBlocksCount) {
                byte[] block = new byte[512];
                if (512 != stream.read(block)) {
                    throw new Exception("Read failure");
                }
                extractedFileBOS.write(block);
                ++i;
            }
            stream.close();
        }
        catch (Exception e) {
            log.error("Failed to export MediaBlock", (Throwable)e);
            return false;
        }
        return true;
    }

    public long getRawDataContentSize() {
        return (this.ncaHeaderTableEntry.getMediaEndOffset() - this.ncaHeaderTableEntry.getMediaStartOffset()) * 512L;
    }

    public String getFileName() {
        return this.file.getName();
    }
}

