/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NPDM;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.NPDM.ACI0.ACI0Provider;
import libKonogonka.fs.NPDM.ACID.ACIDProvider;

public class NPDMProvider {
    private final String magicNum;
    private final byte[] reserved1;
    private final byte MMUFlags;
    private final byte reserved2;
    private final byte mainThreadPrio;
    private final byte mainThreadCoreNum;
    private final byte[] reserved3;
    private final int personalMmHeapSize;
    private final int version;
    private final long mainThreadStackSize;
    private final String titleName;
    private final byte[] productCode;
    private final byte[] reserved4;
    private final int aci0offset;
    private final int aci0size;
    private final int acidOffset;
    private final int acidSize;
    private ACI0Provider aci0;
    private ACIDProvider acid;

    public NPDMProvider(File file) throws Exception {
        this(file, 0L);
    }

    public NPDMProvider(File file, long offset) throws Exception {
        this(new InFileStreamProducer(file, offset));
    }

    public NPDMProvider(InFileStreamProducer producer) throws Exception {
        try (BufferedInputStream stream = producer.produce();){
            byte[] mainBuf = new byte[128];
            if (stream.read(mainBuf) != 128) {
                throw new Exception("NPDMProvider: Failed to read 'META'");
            }
            this.aci0offset = Converter.getLEint(mainBuf, 112);
            this.aci0size = Converter.getLEint(mainBuf, 116);
            this.acidOffset = Converter.getLEint(mainBuf, 120);
            this.acidSize = Converter.getLEint(mainBuf, 124);
            if (this.aci0offset < this.acidOffset) {
                this.calculateACI0(stream, this.aci0offset - 128);
                this.calculateACID(stream, this.acidOffset - this.aci0offset - this.aci0size);
            } else {
                this.calculateACID(stream, this.acidOffset - 128);
                this.calculateACI0(stream, this.aci0offset - this.acidOffset - this.acidSize);
            }
            this.magicNum = new String(mainBuf, 0, 4, StandardCharsets.UTF_8);
            this.reserved1 = Arrays.copyOfRange(mainBuf, 4, 12);
            this.MMUFlags = mainBuf[12];
            this.reserved2 = mainBuf[13];
            this.mainThreadPrio = mainBuf[14];
            this.mainThreadCoreNum = mainBuf[15];
            this.reserved3 = Arrays.copyOfRange(mainBuf, 16, 20);
            this.personalMmHeapSize = Converter.getLEint(mainBuf, 20);
            this.version = Converter.getLEint(mainBuf, 24);
            this.mainThreadStackSize = Converter.getLElongOfInt(mainBuf, 28);
            this.titleName = new String(mainBuf, 32, 16, StandardCharsets.UTF_8);
            this.productCode = Arrays.copyOfRange(mainBuf, 48, 64);
            this.reserved4 = Arrays.copyOfRange(mainBuf, 64, 112);
        }
    }

    private void calculateACID(BufferedInputStream stream, int toSkip) throws Exception {
        byte[] acidBuf = new byte[this.acidSize];
        if (stream.skip(toSkip) != (long)toSkip) {
            throw new Exception("NPDMProvider: Failed to skip bytes till 'ACID'");
        }
        if (this.acidSize != stream.read(acidBuf)) {
            throw new Exception("NPDMProvider: Failed to read 'ACID'");
        }
        this.acid = new ACIDProvider(acidBuf);
    }

    private void calculateACI0(BufferedInputStream stream, int toSkip) throws Exception {
        byte[] aci0Buf = new byte[this.aci0size];
        if (stream.skip(toSkip) != (long)toSkip) {
            throw new Exception("NPDMProvider: Failed to skip bytes till 'ACI0'");
        }
        if (this.aci0size != stream.read(aci0Buf)) {
            throw new Exception("NPDMProvider: Failed to read 'ACI0'");
        }
        this.aci0 = new ACI0Provider(aci0Buf);
    }

    public String getMagicNum() {
        return this.magicNum;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte getMMUFlags() {
        return this.MMUFlags;
    }

    public byte getReserved2() {
        return this.reserved2;
    }

    public byte getMainThreadPrio() {
        return this.mainThreadPrio;
    }

    public byte getMainThreadCoreNum() {
        return this.mainThreadCoreNum;
    }

    public byte[] getReserved3() {
        return this.reserved3;
    }

    public int getPersonalMmHeapSize() {
        return this.personalMmHeapSize;
    }

    public int getVersion() {
        return this.version;
    }

    public long getMainThreadStackSize() {
        return this.mainThreadStackSize;
    }

    public String getTitleName() {
        return this.titleName;
    }

    public byte[] getProductCode() {
        return this.productCode;
    }

    public byte[] getReserved4() {
        return this.reserved4;
    }

    public int getAci0offset() {
        return this.aci0offset;
    }

    public int getAci0size() {
        return this.aci0size;
    }

    public int getAcidOffset() {
        return this.acidOffset;
    }

    public int getAcidSize() {
        return this.acidSize;
    }

    public ACI0Provider getAci0() {
        return this.aci0;
    }

    public ACIDProvider getAcid() {
        return this.acid;
    }
}

