/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.PFS0;

import java.io.BufferedInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import libKonogonka.fs.PFS0.PFS0subFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PFS0Header {
    private static final Logger log = LogManager.getLogger(PFS0Header.class);
    private final String magic;
    private final int filesCount;
    private final int stringTableSize;
    private final byte[] padding;
    private final PFS0subFile[] pfs0subFiles;

    public PFS0Header(BufferedInputStream stream) throws Exception {
        int i;
        byte[] fileStartingBytes = new byte[16];
        if (16 != stream.read(fileStartingBytes)) {
            throw new Exception("Reading stream suddenly ended while trying to read starting 0x10 bytes");
        }
        this.magic = new String(fileStartingBytes, 0, 4, StandardCharsets.US_ASCII);
        if (!this.magic.equals("PFS0")) {
            throw new Exception("Bad magic");
        }
        this.filesCount = Converter.getLEint(fileStartingBytes, 4);
        if (this.filesCount <= 0) {
            throw new Exception("Files count is too small");
        }
        this.stringTableSize = Converter.getLEint(fileStartingBytes, 8);
        if (this.stringTableSize <= 0) {
            throw new Exception("String table is too small");
        }
        this.padding = Arrays.copyOfRange(fileStartingBytes, 12, 16);
        this.pfs0subFiles = new PFS0subFile[this.filesCount];
        long[] offsetsSubFiles = new long[this.filesCount];
        long[] sizesSubFiles = new long[this.filesCount];
        int[] strTableOffsets = new int[this.filesCount];
        byte[][] zeroBytes = new byte[this.filesCount][];
        byte[] fileEntryTable = new byte[24];
        for (int i2 = 0; i2 < this.filesCount; ++i2) {
            if (24 != stream.read(fileEntryTable)) {
                throw new Exception("Reading stream suddenly ended while trying to read File Entry Table #" + i2);
            }
            offsetsSubFiles[i2] = Converter.getLElong(fileEntryTable, 0);
            sizesSubFiles[i2] = Converter.getLElong(fileEntryTable, 8);
            strTableOffsets[i2] = Converter.getLEint(fileEntryTable, 16);
            zeroBytes[i2] = Arrays.copyOfRange(fileEntryTable, 20, 24);
        }
        String[] subFileNames = new String[this.filesCount];
        byte[] stringTbl = new byte[this.stringTableSize];
        if (stream.read(stringTbl) != this.stringTableSize) {
            throw new Exception("Read PFS0Provider String table failure. Can't read requested string table size (" + this.stringTableSize + ")");
        }
        for (i = 0; i < this.filesCount; ++i) {
            int j = 0;
            while (stringTbl[strTableOffsets[i] + j] != 0) {
                ++j;
            }
            subFileNames[i] = new String(stringTbl, strTableOffsets[i], j, StandardCharsets.UTF_8);
        }
        for (i = 0; i < this.filesCount; ++i) {
            this.pfs0subFiles[i] = new PFS0subFile(subFileNames[i], offsetsSubFiles[i], sizesSubFiles[i], zeroBytes[i]);
        }
    }

    public String getMagic() {
        return this.magic;
    }

    public int getFilesCount() {
        return this.filesCount;
    }

    public int getStringTableSize() {
        return this.stringTableSize;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public PFS0subFile[] getPfs0subFiles() {
        return this.pfs0subFiles;
    }

    public void printDebug() {
        log.debug(".:: PFS0Header ::.\nMagic                     " + this.magic + "\nFiles count               " + RainbowDump.formatDecHexString(this.filesCount) + "\nString Table Size         " + RainbowDump.formatDecHexString(this.stringTableSize) + "\nPadding                   " + Converter.byteArrToHexStringAsLE(this.padding) + "\n\n");
        for (PFS0subFile subFile : this.pfs0subFiles) {
            log.debug("\nName:                     " + subFile.getName() + "\nOffset                    " + RainbowDump.formatDecHexString(subFile.getOffset()) + "\nSize                      " + RainbowDump.formatDecHexString(subFile.getSize()) + "\nZeroes                    " + Converter.byteArrToHexStringAsLE(subFile.getZeroes()) + "\n----------------------------------------------------------------");
        }
    }
}

