/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import libKonogonka.Converter;
import libKonogonka.fs.other.System2.ini1.KIP1Provider;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.SimplyFind;
import nsusbloader.Utilities.patches.loader.LoaderPatch;

public class LoaderPatchMaker
extends CancellableRunnable {
    private final ILogPrinter logPrinter = Log.getPrinter(EModule.PATCHES);
    private final String atmosphereLocation;
    private final String saveTo;
    private String package3Location;
    private KIP1Provider loaderProvider;
    private boolean oneLinerStatus = false;

    public LoaderPatchMaker(String atmosphereLocation, String saveTo) {
        this.atmosphereLocation = atmosphereLocation;
        this.saveTo = saveTo;
    }

    @Override
    public void run() {
        try {
            this.logPrinter.print("..:: Make Loader Patches ::..", EMsgType.INFO);
            this.checkPackage3();
            this.createLoaderKip1Provider();
            this.makePatches();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.logPrinter.print(e.getMessage(), EMsgType.FAIL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.logPrinter.updateOneLinerStatus(this.oneLinerStatus);
            this.logPrinter.close();
        }
    }

    private void checkPackage3() throws Exception {
        this.logPrinter.print("Looking at Atmosphere", EMsgType.INFO);
        if (Files.notExists(Paths.get(this.atmosphereLocation, new String[0]), new LinkOption[0])) {
            throw new Exception("Atmosphere directory does not exist at " + this.atmosphereLocation);
        }
        this.package3Location = this.atmosphereLocation + File.separator + "package3";
        if (Files.exists(Paths.get(this.package3Location, new String[0]), new LinkOption[0])) {
            return;
        }
        this.package3Location = this.atmosphereLocation + File.separator + "fusee-secondary.bin";
        if (Files.notExists(Paths.get(this.package3Location, new String[0]), new LinkOption[0])) {
            throw new Exception("package3 / fusee-secondary.bin file not found at " + this.atmosphereLocation);
        }
    }

    private void createLoaderKip1Provider() throws Exception {
        Path package3Path = Paths.get(this.package3Location, new String[0]);
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(package3Path, new OpenOption[0]));){
            byte[] data = new byte[1024];
            if (1024 != stream.read(data)) {
                throw new Exception("Failed to read first 0x400 bytes of package3 / fusee-secondary file.");
            }
            SimplyFind simplyFind = new SimplyFind(".6f61646572", data);
            List<Integer> results = simplyFind.getResults();
            if (results.size() == 0) {
                throw new Exception("Failed to find 'Loader' offset at package3 / fusee-secondary file.");
            }
            int offset = results.get(0);
            int kip1Offset = Converter.getLEint(data, offset - 16);
            int kip1Size = Converter.getLEint(data, offset - 12);
            this.loaderProvider = new KIP1Provider(this.package3Location, kip1Offset);
            if ((long)kip1Size != this.loaderProvider.getSize()) {
                throw new Exception("Incorrect calculations for KIP1. PK31 value: " + kip1Size + "KIP1Provider value: " + this.loaderProvider.getSize());
            }
            this.logPrinter.print("Loader KIP1 found", EMsgType.PASS);
        }
    }

    private void makePatches() throws Exception {
        new LoaderPatch(this.loaderProvider, this.saveTo, this.logPrinter);
        this.oneLinerStatus = true;
    }
}

