/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nsusbloader.Utilities.splitmerge.SplitMergeTaskExecutor;
import nsusbloader.cli.IncorrectSetupException;

public class MergeCli {
    private final String[] arguments;
    private String saveTo;
    private String[] splitFiles;

    MergeCli(String[] arguments) throws InterruptedException, IncorrectSetupException {
        this.arguments = arguments;
        this.checkArguments();
        this.parseArguments();
        this.printFilesForMerge();
        this.runBackend();
    }

    private void checkArguments() throws IncorrectSetupException {
        if (this.arguments == null || this.arguments.length == 0) {
            throw new IncorrectSetupException("No arguments.\nTry 'ns-usbloader -m help' for more information.");
        }
        if (this.arguments.length == 1) {
            if (this.isHelpDirective(this.arguments[0])) {
                this.showHelp();
                return;
            }
            throw new IncorrectSetupException("Not enough arguments.\nTry 'ns-usbloader -m help' for more information.");
        }
        this.saveTo = this.arguments[0];
        File saveToFile = new File(this.saveTo);
        if (!saveToFile.exists() || saveToFile.isFile()) {
            throw new IncorrectSetupException("First argument must be existing directory.");
        }
    }

    private boolean isHelpDirective(String argument) {
        return argument.equals("help");
    }

    private void showHelp() throws IncorrectSetupException {
        throw new IncorrectSetupException("Usage:\n\tns-usbloader -m <SAVE_TO_DIR> <SPLIT_FILE>...\n\n\nOptions:\n\tSAVE_TO_DIR\tWhere results should be saved\n\tSPLIT_FILE\tOne or more split-files (folders) to merge");
    }

    private void parseArguments() throws IncorrectSetupException {
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 1; i < this.arguments.length; ++i) {
            File file = new File(this.arguments[i]);
            if (!file.isDirectory()) continue;
            files.add(file.getAbsolutePath());
        }
        if (files.isEmpty()) {
            throw new IncorrectSetupException("No files specified.\nTry 'ns-usbloader -m help' for more information.");
        }
        this.splitFiles = files.toArray(new String[0]);
    }

    private void printFilesForMerge() {
        System.out.println("Next files will be merged:");
        for (String f : this.splitFiles) {
            System.out.println("  " + f);
        }
    }

    private void runBackend() throws InterruptedException {
        SplitMergeTaskExecutor mergeTask = new SplitMergeTaskExecutor(false, this.getFilesFromStrings(), this.saveTo);
        Thread thread = new Thread(mergeTask);
        thread.setDaemon(true);
        thread.start();
        thread.join();
    }

    private List<File> getFilesFromStrings() {
        ArrayList<File> realFiles = new ArrayList<File>();
        for (String splitFileString : this.splitFiles) {
            realFiles.add(new File(splitFileString));
        }
        return realFiles;
    }
}

