/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.HostServices;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.Region;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.FontSettings;
import nsusbloader.MediatorControl;
import nsusbloader.ModelControllers.UpdatesChecker;
import nsusbloader.ServiceWindow;
import nsusbloader.UI.LocaleHolder;
import nsusbloader.UI.SettingsLanguagesSetup;
import nsusbloader.Utilities.WindowsDrivers.DriversInstall;

public class SettingsBlockGenericController
implements Initializable {
    @FXML
    private ChoiceBox<LocaleHolder> languagesChB;
    @FXML
    private Button fontSelectBtn;
    @FXML
    private Button submitLanguageBtn;
    @FXML
    private Button driversInstallBtn;
    @FXML
    private Button checkForUpdBtn;
    @FXML
    private CheckBox autoCheckForUpdatesCB;
    @FXML
    private CheckBox direcroriesChooserForRomsCB;
    @FXML
    private Hyperlink newVersionHyperlink;
    private ResourceBundle resourceBundle;
    private HostServices hostServices;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        AppPreferences preferences = AppPreferences.getInstance();
        this.autoCheckForUpdatesCB.setSelected(preferences.getAutoCheckUpdates());
        this.direcroriesChooserForRomsCB.setSelected(preferences.getDirectoriesChooserForRoms());
        this.direcroriesChooserForRomsCB.setOnAction(actionEvent -> MediatorControl.INSTANCE.getGamesController().setFilesSelectorButtonBehaviour(this.direcroriesChooserForRomsCB.isSelected()));
        Region btnSwitchImage = new Region();
        btnSwitchImage.getStyleClass().add("regionUpdatesCheck");
        this.checkForUpdBtn.setGraphic(btnSwitchImage);
        this.setDriversInstallFeature();
        SettingsLanguagesSetup settingsLanguagesSetup = new SettingsLanguagesSetup();
        this.languagesChB.setItems(settingsLanguagesSetup.getLanguages());
        this.languagesChB.getSelectionModel().select(settingsLanguagesSetup.getRecentLanguage());
        this.hostServices = MediatorControl.INSTANCE.getHostServices();
        this.newVersionHyperlink.setOnAction(e -> this.hostServices.showDocument(this.newVersionHyperlink.getText()));
        this.checkForUpdBtn.setOnAction(e -> this.checkForUpdatesAction());
        this.submitLanguageBtn.setOnAction(e -> this.languageButtonAction());
        this.fontSelectBtn.setOnAction(e -> this.openFontSettings());
    }

    private void openFontSettings() {
        try {
            new FontSettings(this.resourceBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setDriversInstallFeature() {
        if (this.isWindows()) {
            Region btnDrvImage = new Region();
            btnDrvImage.getStyleClass().add("regionWindows");
            this.driversInstallBtn.setGraphic(btnDrvImage);
            this.driversInstallBtn.setVisible(true);
            this.driversInstallBtn.setOnAction(actionEvent -> new DriversInstall(this.resourceBundle));
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().replace(" ", "").contains("windows");
    }

    private void checkForUpdatesAction() {
        UpdatesChecker updTask = new UpdatesChecker();
        updTask.setOnSucceeded(event -> {
            List result = (List)updTask.getValue();
            if (result == null) {
                ServiceWindow.getInfoNotification(this.resourceBundle.getString("windowTitleNewVersionUnknown"), this.resourceBundle.getString("windowBodyNewVersionUnknown"));
                return;
            }
            if (((String)result.get(0)).isEmpty()) {
                ServiceWindow.getInfoNotification(this.resourceBundle.getString("windowTitleNewVersionNOTAval"), this.resourceBundle.getString("windowBodyNewVersionNOTAval"));
                return;
            }
            this.setNewVersionLink((String)result.get(0));
            ServiceWindow.getInfoNotification(this.resourceBundle.getString("windowTitleNewVersionAval"), this.resourceBundle.getString("windowTitleNewVersionAval") + ": " + (String)result.get(0) + "\n\n" + (String)result.get(1));
        });
        Thread updates = new Thread(updTask);
        updates.setDaemon(true);
        updates.start();
    }

    private void languageButtonAction() {
        LocaleHolder localeHolder = (LocaleHolder)this.languagesChB.getSelectionModel().getSelectedItem();
        AppPreferences.getInstance().setLocale(localeHolder.getLocaleCode());
        Locale newLocale = localeHolder.getLocale();
        ServiceWindow.getInfoNotification("", ResourceBundle.getBundle("locale", newLocale).getString("windowBodyRestartToApplyLang"));
    }

    private boolean getAutoCheckForUpdates() {
        return this.autoCheckForUpdatesCB.isSelected();
    }

    public boolean isDirectoriesChooserForRoms() {
        return this.direcroriesChooserForRomsCB.isSelected();
    }

    void setNewVersionLink(String newVer) {
        this.newVersionHyperlink.setVisible(true);
        this.newVersionHyperlink.setText("https://github.com/developersu/ns-usbloader/releases/tag/" + newVer);
    }

    void updatePreferencesOnExit() {
        AppPreferences.getInstance().setAutoCheckUpdates(this.getAutoCheckForUpdates());
        AppPreferences.getInstance().setDirectoriesChooserForRoms(this.isDirectoriesChooserForRoms());
    }
}

