/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.fs.finders;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nsusbloader.Utilities.patches.AHeuristic;
import nsusbloader.Utilities.patches.fs.finders.HeuristicFs1;
import nsusbloader.Utilities.patches.fs.finders.HeuristicFs2;

public class HeuristicFsWizard {
    private final List<AHeuristic> all;
    private final List<AHeuristic> found;
    private final List<AHeuristic> wantLessEntropy;
    private final StringBuilder errorsAndNotes = new StringBuilder();
    private int offset1 = -1;
    private int offset2 = -1;

    public HeuristicFsWizard(byte[] where) throws Exception {
        this.all = Arrays.asList(new HeuristicFs1(where), new HeuristicFs2(where));
        this.found = this.all.stream().filter(AHeuristic::isFound).collect(Collectors.toList());
        if (this.found.isEmpty()) {
            throw new Exception("Nothing found!");
        }
        this.wantLessEntropy = this.all.stream().filter(AHeuristic::wantLessEntropy).collect(Collectors.toList());
        this.shareOffsetsWithEachOther();
        this.assignOffset1();
        this.assignOffset2();
    }

    private void shareOffsetsWithEachOther() {
        for (AHeuristic es : this.wantLessEntropy) {
            if (!this.shareWithNext(es)) continue;
            return;
        }
    }

    private boolean shareWithNext(AHeuristic es) {
        try {
            for (AHeuristic foundEs : this.found) {
                if (!es.setOffsetsNearby(foundEs.getOffset())) continue;
                this.found.add(es);
                this.wantLessEntropy.remove(es);
                this.shareOffsetsWithEachOther();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void assignOffset1() {
        try {
            this.offset1 = this.all.get(0).getOffset();
        }
        catch (Exception e) {
            this.errorsAndNotes.append(e.getLocalizedMessage()).append("\n");
        }
    }

    private void assignOffset2() {
        try {
            this.offset2 = this.all.get(1).getOffset();
        }
        catch (Exception e) {
            this.errorsAndNotes.append(e.getLocalizedMessage()).append("\n");
        }
    }

    public String getErrorsAndNotes() {
        return this.errorsAndNotes.toString();
    }

    public String getDebug() {
        StringBuilder builder = new StringBuilder();
        if (this.all.get(0).isFound()) {
            builder.append("\t\t-=== 1 ===-\n");
            builder.append(this.all.get(0).getDetails());
        }
        if (this.all.get(1).isFound()) {
            builder.append("\t\t-=== 2 ===-\n");
            builder.append(this.all.get(1).getDetails());
        }
        return builder.toString();
    }

    public int getOffset1() {
        return this.offset1;
    }

    public int getOffset2() {
        return this.offset2;
    }
}

