/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.FilesDropHandleTask;
import nsusbloader.Controllers.NSTableViewController;
import nsusbloader.MediatorControl;

public class FilesDropHandle {
    public FilesDropHandle(List<File> files, String filesRegex, String foldersRegex, NSTableViewController tableController) {
        FilesDropHandleTask filesDropHandleTask = new FilesDropHandleTask(files, filesRegex, foldersRegex);
        ResourceBundle resourceBundle = MediatorControl.INSTANCE.getResourceBundle();
        Button cancelButton = new Button(resourceBundle.getString("btn_Cancel"));
        ProgressIndicator progressIndicator = new ProgressIndicator();
        progressIndicator.setProgress(-1.0);
        Label statusLabel = new Label();
        statusLabel.setWrapText(true);
        statusLabel.setTextAlignment(TextAlignment.CENTER);
        statusLabel.textProperty().bind(filesDropHandleTask.messageProperty());
        Pane fillerPane1 = new Pane();
        Pane fillerPane2 = new Pane();
        VBox parentVBox = new VBox();
        parentVBox.setAlignment(Pos.TOP_CENTER);
        parentVBox.setFillWidth(true);
        parentVBox.setSpacing(5.0);
        parentVBox.setPadding(new Insets(5.0));
        parentVBox.setFillWidth(true);
        parentVBox.getChildren().addAll((Node[])new Node[]{statusLabel, fillerPane1, progressIndicator, fillerPane2, cancelButton});
        VBox.setVgrow(fillerPane1, Priority.ALWAYS);
        VBox.setVgrow(fillerPane2, Priority.ALWAYS);
        Stage stage = new Stage();
        stage.setTitle(resourceBundle.getString("windowTitleAddingFiles"));
        stage.getIcons().addAll((Image[])new Image[]{new Image("/res/info_ico32x32.png"), new Image("/res/info_ico48x48.png"), new Image("/res/info_ico64x64.png"), new Image("/res/info_ico128x128.png")});
        stage.setMinWidth(300.0);
        stage.setMinHeight(175.0);
        stage.setAlwaysOnTop(true);
        Scene mainScene = new Scene(parentVBox, 310.0, 185.0);
        mainScene.getStylesheets().add(AppPreferences.getInstance().getTheme());
        parentVBox.setStyle(AppPreferences.getInstance().getFontStyle());
        stage.setOnHidden(windowEvent -> filesDropHandleTask.cancel(true));
        stage.setScene(mainScene);
        stage.show();
        stage.toFront();
        filesDropHandleTask.setOnSucceeded(event -> {
            cancelButton.setText(resourceBundle.getString("btn_Close"));
            List allFiles = (List)filesDropHandleTask.getValue();
            if (!allFiles.isEmpty()) {
                tableController.setFiles(allFiles);
            }
            stage.close();
        });
        new Thread(filesDropHandleTask).start();
        cancelButton.setOnAction(actionEvent -> {
            filesDropHandleTask.cancel(true);
            stage.close();
        });
    }
}

