/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import nsusbloader.AppPreferences;

public class SettingsBlockGoldleafController
implements Initializable {
    @FXML
    private CheckBox nspFilesFilterForGLCB;
    @FXML
    private ChoiceBox<String> glVersionChoiceBox;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        AppPreferences preferences = AppPreferences.getInstance();
        this.nspFilesFilterForGLCB.setSelected(preferences.getNspFileFilterGL());
        this.glVersionChoiceBox.getItems().addAll((String[])AppPreferences.GOLDLEAF_SUPPORTED_VERSIONS);
        this.glVersionChoiceBox.getSelectionModel().select(preferences.getGlVersion());
    }

    public boolean getNSPFileFilterForGL() {
        return this.nspFilesFilterForGLCB.isSelected();
    }

    public String getGlVer() {
        return this.glVersionChoiceBox.getValue();
    }

    void updatePreferencesOnExit() {
        AppPreferences preferences = AppPreferences.getInstance();
        preferences.setNspFileFilterGL(this.getNSPFileFilterForGL());
        preferences.setGlVersion(this.glVersionChoiceBox.getSelectionModel().getSelectedIndex());
    }
}

