/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.util.Arrays;
import libKonogonka.Converter;

public class SuperBlockPFS0 {
    private final byte[] SHA256hash;
    private final int blockSize;
    private final int layerCount;
    private final long hashTableOffset;
    private final long hashTableSize;
    private final long pfs0offset;
    private final long pfs0size;
    private final byte[] zeroes;

    SuperBlockPFS0(byte[] sbBytes) {
        this.SHA256hash = Arrays.copyOfRange(sbBytes, 0, 32);
        this.blockSize = Converter.getLEint(sbBytes, 32);
        this.layerCount = Converter.getLEint(sbBytes, 36);
        this.hashTableOffset = Converter.getLElong(sbBytes, 40);
        this.hashTableSize = Converter.getLElong(sbBytes, 48);
        this.pfs0offset = Converter.getLElong(sbBytes, 56);
        this.pfs0size = Converter.getLElong(sbBytes, 64);
        this.zeroes = Arrays.copyOfRange(sbBytes, 72, 240);
    }

    public byte[] getSHA256hash() {
        return this.SHA256hash;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    public long getHashTableOffset() {
        return this.hashTableOffset;
    }

    public long getHashTableSize() {
        return this.hashTableSize;
    }

    public long getPfs0offset() {
        return this.pfs0offset;
    }

    public long getPfs0size() {
        return this.pfs0size;
    }

    public byte[] getZeroes() {
        return this.zeroes;
    }
}

