/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader;

import java.util.Locale;
import java.util.prefs.Preferences;
import javafx.scene.text.Font;
import nsusbloader.FilesHelper;

public class AppPreferences {
    private static final AppPreferences INSTANCE = new AppPreferences();
    private final Preferences preferences = Preferences.userRoot().node("NS-USBloader");
    private final Locale locale;
    public static final String[] GOLDLEAF_SUPPORTED_VERSIONS = new String[]{"v0.5", "v0.7.x", "v0.8-0.9", "v0.10+"};
    private static final Font DEFAULT_FONT = Font.getDefault();

    public static AppPreferences getInstance() {
        return INSTANCE;
    }

    private AppPreferences() {
        String localeCode = this.preferences.get("locale", Locale.getDefault().toString());
        this.locale = localeCode.length() < 5 ? new Locale("en", "EN") : new Locale(localeCode.substring(0, 2), localeCode.substring(3));
    }

    public String getTheme() {
        String theme = this.preferences.get("THEME", "/res/app_dark.css");
        if (!theme.matches("(^/res/app_dark.css$)|(^/res/app_light.css$)")) {
            theme = "/res/app_dark.css";
        }
        return theme;
    }

    public int getProtocol() {
        int protocolIndex = this.preferences.getInt("protocol_index", 0);
        if (protocolIndex < 0 || protocolIndex > 1) {
            protocolIndex = 0;
        }
        return protocolIndex;
    }

    public void setProtocol(int protocolIndex) {
        this.preferences.putInt("protocol_index", protocolIndex);
    }

    public String getNetUsb() {
        String netUsb = this.preferences.get("NETUSB", "USB");
        if (!netUsb.matches("(^USB$)|(^NET$)")) {
            netUsb = "USB";
        }
        return netUsb;
    }

    public void setTheme(String theme) {
        this.preferences.put("THEME", theme);
    }

    public void setNetUsb(String netUsb) {
        this.preferences.put("NETUSB", netUsb);
    }

    public void setNsIp(String ip) {
        this.preferences.put("NSIP", ip);
    }

    public String getNsIp() {
        return this.preferences.get("NSIP", "192.168.1.42");
    }

    public String getRecent() {
        return FilesHelper.getRealFolder(this.preferences.get("RECENT", System.getProperty("user.home")));
    }

    public void setRecent(String path) {
        this.preferences.put("RECENT", path);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(String langStr) {
        this.preferences.put("locale", langStr);
    }

    public boolean getNsIpValidationNeeded() {
        return this.preferences.getBoolean("NSIPVALIDATION", true);
    }

    public void setNsIpValidationNeeded(boolean need) {
        this.preferences.putBoolean("NSIPVALIDATION", need);
    }

    public boolean getExpertMode() {
        return this.preferences.getBoolean("EXPERTMODE", false);
    }

    public void setExpertMode(boolean mode) {
        this.preferences.putBoolean("EXPERTMODE", mode);
    }

    public boolean getAutoDetectIp() {
        return this.preferences.getBoolean("AUTOHOSTIP", true);
    }

    public void setAutoDetectIp(boolean mode) {
        this.preferences.putBoolean("AUTOHOSTIP", mode);
    }

    public boolean getRandPort() {
        return this.preferences.getBoolean("RANDHOSTPORT", true);
    }

    public void setRandPort(boolean mode) {
        this.preferences.putBoolean("RANDHOSTPORT", mode);
    }

    public boolean getNotServeRequests() {
        return this.preferences.getBoolean("DONTSERVEREQ", false);
    }

    public void setNotServeRequests(boolean mode) {
        this.preferences.putBoolean("DONTSERVEREQ", mode);
    }

    public String getHostIp() {
        return this.preferences.get("HOSTIP", "0.0.0.0").replaceAll("(\\s)|(\t)", "");
    }

    public void setHostIp(String ip) {
        this.preferences.put("HOSTIP", ip);
    }

    public String getHostPort() {
        String value = this.preferences.get("HOSTPORT", "6042");
        if (!value.matches("^[0-9]{1,5}$")) {
            return "6042";
        }
        if (Integer.parseInt(value) > 65535 || Integer.parseInt(value) < 1) {
            return "6042";
        }
        return value;
    }

    public void setHostPort(String port) {
        this.preferences.put("HOSTPORT", port);
    }

    public String getHostExtra() {
        return this.preferences.get("HOSTEXTRA", "").replaceAll("(\\s)|(\t)", "");
    }

    public void setHostExtra(String postfix) {
        this.preferences.put("HOSTEXTRA", postfix);
    }

    public boolean getAutoCheckUpdates() {
        return this.preferences.getBoolean("AUTOCHECK4UPDATES", false);
    }

    public void setAutoCheckUpdates(boolean prop) {
        this.preferences.putBoolean("AUTOCHECK4UPDATES", prop);
    }

    public boolean getDirectoriesChooserForRoms() {
        return this.preferences.getBoolean("dirchooser4roms", false);
    }

    public void setDirectoriesChooserForRoms(boolean prop) {
        this.preferences.putBoolean("dirchooser4roms", prop);
    }

    public boolean getTfXCI() {
        return this.preferences.getBoolean("TF_XCI", true);
    }

    public void setTfXCI(boolean prop) {
        this.preferences.putBoolean("TF_XCI", prop);
    }

    public boolean getNspFileFilterGL() {
        return this.preferences.getBoolean("GL_NSP_FILTER", false);
    }

    public void setNspFileFilterGL(boolean prop) {
        this.preferences.putBoolean("GL_NSP_FILTER", prop);
    }

    public int getGlVersion() {
        return this.preferences.getInt("gl_ver", GOLDLEAF_SUPPORTED_VERSIONS.length - 1);
    }

    public void setGlVersion(int version) {
        this.preferences.putInt("gl_ver", version);
    }

    public double getSceneWidth() {
        return this.preferences.getDouble("WIND_WIDTH", 850.0);
    }

    public void setSceneWidth(double value) {
        this.preferences.putDouble("WIND_WIDTH", value);
    }

    public double getSceneHeight() {
        return this.preferences.getDouble("WIND_HEIGHT", 525.0);
    }

    public void setSceneHeight(double value) {
        this.preferences.putDouble("WIND_HEIGHT", value);
    }

    public int getSplitMergeType() {
        return this.preferences.getInt("SM_TYPE", 0);
    }

    public void setSplitMergeType(int value) {
        this.preferences.putInt("SM_TYPE", value);
    }

    public String getSplitMergeRecent() {
        return FilesHelper.getRealFolder(this.preferences.get("SM_RECENT", System.getProperty("user.home")));
    }

    public void setSplitMergeRecent(String value) {
        this.preferences.put("SM_RECENT", value);
    }

    public String getRecentRcm(int num) {
        return this.preferences.get(String.format("RCM_%02d", num), "");
    }

    public void setRecentRcm(int num, String value) {
        this.preferences.put(String.format("RCM_%02d", num), value);
    }

    public String getNXDTSaveToLocation() {
        return FilesHelper.getRealFolder(this.preferences.get("nxdt_saveto", System.getProperty("user.home")));
    }

    public void setNXDTSaveToLocation(String value) {
        this.preferences.put("nxdt_saveto", value);
    }

    public String getLastOpenedTab() {
        return this.preferences.get("recent_tab", "");
    }

    public void setLastOpenedTab(String tabId) {
        this.preferences.put("recent_tab", tabId);
    }

    public String getKeysLocation() {
        return this.preferences.get("keys", "");
    }

    public void setKeysLocation(String path) {
        this.preferences.put("keys", path);
    }

    public String getPatchesSaveToLocation() {
        return FilesHelper.getRealFolder(this.preferences.get("patches_saveto", System.getProperty("user.home")));
    }

    public void setPatchesSaveToLocation(String value) {
        this.preferences.put("patches_saveto", value);
    }

    public boolean getPatchesTabInvisible() {
        return this.preferences.getBoolean("patches_tab_visible", true);
    }

    public void setPatchesTabInvisible(boolean value) {
        this.preferences.putBoolean("patches_tab_visible", value);
    }

    public String getPatchPattern(String type, int moduleNumber, int offsetId) {
        return this.preferences.get(String.format("%s_%02x_%02x", type, moduleNumber, offsetId), "");
    }

    public void setPatchPattern(String fullTypeSpecifier, String offset) {
        this.preferences.put(fullTypeSpecifier, offset);
    }

    public String getFontFamily() {
        return this.preferences.get("font_family", DEFAULT_FONT.getFamily());
    }

    public double getFontSize() {
        return this.preferences.getDouble("font_size", DEFAULT_FONT.getSize());
    }

    public String getFontStyle() {
        String fontFamily = this.preferences.get("font_family", DEFAULT_FONT.getFamily());
        double fontSize = this.preferences.getDouble("font_size", DEFAULT_FONT.getSize());
        return String.format("-fx-font-family: \"%s\"; -fx-font-size: %.0f;", fontFamily, fontSize);
    }

    public void setFontStyle(String fontFamily, double size) {
        this.preferences.put("font_family", fontFamily);
        this.preferences.putDouble("font_size", size);
    }
}

