/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.usb.PFS.PFSProvider;
import nsusbloader.com.usb.TransferModule;
import nsusbloader.com.usb.UsbErrorCodes;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

public class GoldLeaf_05
extends TransferModule {
    private static final byte[] CMD_GLUC = new byte[]{71, 76, 85, 67};
    private static final byte[] CMD_ConnectionRequest = new byte[]{0, 0, 0, 0};
    private static final byte[] CMD_NSPName = new byte[]{2, 0, 0, 0};
    private static final byte[] CMD_NSPData = new byte[]{4, 0, 0, 0};
    private static final byte[] CMD_ConnectionResponse = new byte[]{1, 0, 0, 0};
    private static final byte[] CMD_Start = new byte[]{3, 0, 0, 0};
    private static final byte[] CMD_NSPContent = new byte[]{5, 0, 0, 0};
    private static final byte[] CMD_NSPTicket = new byte[]{6, 0, 0, 0};
    private static final byte[] CMD_Finish = new byte[]{7, 0, 0, 0};
    private RandomAccessFile raf;
    private NSSplitReader nsr;

    GoldLeaf_05(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter) {
        super(handler, nspMap, task, logPrinter);
        PFSProvider pfsElement;
        this.task = task;
        this.status = EFileStatus.FAILED;
        this.print("============= GoldLeaf v0.5 =============\n        Only one file per time could be sent. In case you selected more the first one would be picked.", EMsgType.INFO);
        if (nspMap.isEmpty()) {
            this.print("For using this GoldLeaf version you have to add file to the table and select it for upload", EMsgType.INFO);
            return;
        }
        File nspFile = (File)nspMap.values().toArray()[0];
        this.print("File for upload: " + nspFile.getAbsolutePath(), EMsgType.INFO);
        if (!nspFile.getName().toLowerCase().endsWith(".nsp")) {
            this.print("GL This file doesn't look like NSP", EMsgType.FAIL);
            return;
        }
        try {
            pfsElement = new PFSProvider(nspFile, logPrinter);
        }
        catch (Exception e) {
            this.print("GL File provided has incorrect structure and won't be uploaded\n\t" + e.getMessage(), EMsgType.FAIL);
            this.status = EFileStatus.INCORRECT_FILE_FAILED;
            return;
        }
        this.print("GL File structure validated and it will be uploaded", EMsgType.PASS);
        try {
            if (nspFile.isDirectory()) {
                this.nsr = new NSSplitReader(nspFile, 0L);
            } else {
                this.raf = new RandomAccessFile(nspFile, "r");
            }
        }
        catch (IOException ioe) {
            this.print("GL File not found\n\t" + ioe.getMessage(), EMsgType.FAIL);
            return;
        }
        if (this.writeUsb(CMD_GLUC)) {
            this.print("GL Initiating GoldLeaf connection [1/2]", EMsgType.FAIL);
            return;
        }
        this.print("GL Initiating GoldLeaf connection: [1/2]", EMsgType.PASS);
        if (this.writeUsb(CMD_ConnectionRequest)) {
            this.print("GL Initiating GoldLeaf connection: [2/2]", EMsgType.FAIL);
            return;
        }
        this.print("GL Initiating GoldLeaf connection: [2/2]", EMsgType.PASS);
        while (true) {
            byte[] readByte;
            if ((readByte = this.readUsb()) == null) {
                return;
            }
            if (!Arrays.equals(readByte, CMD_GLUC)) continue;
            readByte = this.readUsb();
            if (readByte == null) {
                return;
            }
            if (Arrays.equals(readByte, CMD_ConnectionResponse)) {
                if (!this.handleConnectionResponse(pfsElement)) continue;
                return;
            }
            if (Arrays.equals(readByte, CMD_Start)) {
                if (!this.handleStart(pfsElement)) continue;
                return;
            }
            if (Arrays.equals(readByte, CMD_NSPContent)) {
                if (!this.handleNSPContent(pfsElement, true)) continue;
                return;
            }
            if (Arrays.equals(readByte, CMD_NSPTicket)) {
                if (!this.handleNSPContent(pfsElement, false)) continue;
                return;
            }
            if (Arrays.equals(readByte, CMD_Finish)) break;
        }
        this.print("GL Closing GoldLeaf connection: Transfer successful.", EMsgType.PASS);
        this.status = EFileStatus.UPLOADED;
        try {
            this.raf.close();
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        try {
            this.nsr.close();
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
    }

    private boolean handleConnectionResponse(PFSProvider pfsElement) {
        this.print("GL 'ConnectionResponse' command:", EMsgType.INFO);
        if (this.writeUsb(CMD_GLUC)) {
            this.print("  [1/4]", EMsgType.FAIL);
            return true;
        }
        this.print("  [1/4]", EMsgType.PASS);
        if (this.writeUsb(CMD_NSPName)) {
            this.print("  [2/4]", EMsgType.FAIL);
            return true;
        }
        this.print("  [2/4]", EMsgType.PASS);
        if (this.writeUsb(pfsElement.getBytesNspFileNameLength())) {
            this.print("  [3/4]", EMsgType.FAIL);
            return true;
        }
        this.print("  [3/4]", EMsgType.PASS);
        if (this.writeUsb(pfsElement.getBytesNspFileName())) {
            this.print("  [4/4]", EMsgType.FAIL);
            return true;
        }
        this.print("  [4/4]", EMsgType.PASS);
        return false;
    }

    private boolean handleStart(PFSProvider pfsElement) {
        this.print("GL Handle 'Start' command:", EMsgType.INFO);
        if (this.writeUsb(CMD_GLUC)) {
            this.print("  [Prefix]", EMsgType.FAIL);
            return true;
        }
        this.print("  [Prefix]", EMsgType.PASS);
        if (this.writeUsb(CMD_NSPData)) {
            this.print("  [Command]", EMsgType.FAIL);
            return true;
        }
        this.print("  [Command]", EMsgType.PASS);
        if (this.writeUsb(pfsElement.getBytesCountOfNca())) {
            this.print("  [Sub-files count]", EMsgType.FAIL);
            return true;
        }
        this.print("  [Sub-files count]", EMsgType.PASS);
        int ncaCount = pfsElement.getIntCountOfNca();
        this.print("  [Information for " + ncaCount + " sub-files]", EMsgType.INFO);
        for (int i = 0; i < ncaCount; ++i) {
            this.print("File #" + i, EMsgType.INFO);
            if (this.writeUsb(pfsElement.getNca(i).getNcaFileNameLength())) {
                this.print("  [1/4] Name length", EMsgType.FAIL);
                return true;
            }
            this.print("  [1/4] Name length", EMsgType.PASS);
            if (this.writeUsb(pfsElement.getNca(i).getNcaFileName())) {
                this.print("  [2/4] Name", EMsgType.FAIL);
                return true;
            }
            this.print("  [2/4] Name", EMsgType.PASS);
            if (this.writeUsb(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(pfsElement.getBodySize() + pfsElement.getNca(i).getNcaOffset()).array())) {
                this.print("  [3/4] Offset", EMsgType.FAIL);
                return true;
            }
            this.print("  [3/4] Offset", EMsgType.PASS);
            if (this.writeUsb(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(pfsElement.getNca(i).getNcaSize()).array())) {
                this.print("  [4/4] Size", EMsgType.FAIL);
                return true;
            }
            this.print("  [4/4] Size", EMsgType.PASS);
        }
        return false;
    }

    private boolean handleNSPContent(PFSProvider pfsElement, boolean isItRawRequest) {
        int requestedNcaID;
        if (isItRawRequest) {
            this.print("GL Handle 'Content' command", EMsgType.INFO);
            byte[] readByte = this.readUsb();
            if (readByte == null || readByte.length != 4) {
                this.print("  [Read requested ID]", EMsgType.FAIL);
                return true;
            }
            requestedNcaID = ByteBuffer.wrap(readByte).order(ByteOrder.LITTLE_ENDIAN).getInt();
            this.print("  [Read requested ID = " + requestedNcaID + " ]", EMsgType.PASS);
        } else {
            requestedNcaID = pfsElement.getNcaTicketID();
            this.print("GL Handle 'Ticket' command (ID = " + requestedNcaID + " )", EMsgType.INFO);
        }
        long realNcaOffset = pfsElement.getNca(requestedNcaID).getNcaOffset() + pfsElement.getBodySize();
        long realNcaSize = pfsElement.getNca(requestedNcaID).getNcaSize();
        int readPice = 0x800000;
        try {
            if (this.raf == null) {
                this.nsr.seek(realNcaOffset);
                for (readFrom = 0L; readFrom < realNcaSize; readFrom += (long)readPice) {
                    byte[] readBuf;
                    if (realNcaSize - readFrom < (long)readPice) {
                        readPice = Math.toIntExact(realNcaSize - readFrom);
                    }
                    if (this.nsr.read(readBuf = new byte[readPice]) != readPice) {
                        return true;
                    }
                    if (this.writeUsb(readBuf)) {
                        return true;
                    }
                    this.logPrinter.updateProgress((double)(readFrom + (long)readPice) / ((double)realNcaSize / 100.0) / 100.0);
                }
            } else {
                this.raf.seek(realNcaOffset);
                while (readFrom < realNcaSize) {
                    byte[] readBuf;
                    if (realNcaSize - readFrom < (long)readPice) {
                        readPice = Math.toIntExact(realNcaSize - readFrom);
                    }
                    if (this.raf.read(readBuf = new byte[readPice]) != readPice) {
                        return true;
                    }
                    if (this.writeUsb(readBuf)) {
                        return true;
                    }
                    this.logPrinter.updateProgress((double)(readFrom + (long)readPice) / ((double)realNcaSize / 100.0) / 100.0);
                    readFrom += (long)readPice;
                }
            }
            this.logPrinter.updateProgress(1.0);
        }
        catch (IOException | InterruptedException ioe) {
            this.print("GL Failed to read NCA ID " + requestedNcaID + ". Exception:\n  " + ioe.getMessage(), EMsgType.FAIL);
            ioe.printStackTrace();
            return true;
        }
        return false;
    }

    private boolean writeUsb(byte[] message) {
        ByteBuffer writeBuffer = ByteBuffer.allocateDirect(message.length);
        writeBuffer.put(message);
        IntBuffer writeBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, writeBuffer, writeBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    if (writeBufTransferred.get() == message.length) {
                        return false;
                    }
                    this.print("GL Data transfer issue [write]\n  Requested: " + message.length + "\n  Transferred: " + writeBufTransferred.get(), EMsgType.FAIL);
                    return true;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [write]\n  Returned: " + UsbErrorCodes.getErrCode(result), EMsgType.FAIL);
            this.print("GL Execution stopped", EMsgType.FAIL);
            return true;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return true;
    }

    private byte[] readUsb() {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(512);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    int trans = readBufTransferred.get();
                    byte[] receivedBytes = new byte[trans];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [read]\n  Returned: " + UsbErrorCodes.getErrCode(result), EMsgType.FAIL);
            this.print("GL Execution stopped", EMsgType.FAIL);
            return null;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return null;
    }
}

