/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.ISubscriber;
import nsusbloader.Controllers.Payload;
import nsusbloader.MediatorControl;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.ServiceWindow;
import nsusbloader.Utilities.Rcm;

public class RcmController
implements Initializable,
ISubscriber {
    @FXML
    private ToggleGroup rcmToggleGrp;
    @FXML
    private VBox rcmToolPane;
    @FXML
    private RadioButton pldrRadio1;
    @FXML
    private RadioButton pldrRadio2;
    @FXML
    private RadioButton pldrRadio3;
    @FXML
    private RadioButton pldrRadio4;
    @FXML
    private RadioButton pldrRadio5;
    @FXML
    private Button injectPldBtn;
    @FXML
    private Label payloadFNameLbl1;
    @FXML
    private Label payloadFPathLbl1;
    @FXML
    private Label payloadFNameLbl2;
    @FXML
    private Label payloadFPathLbl2;
    @FXML
    private Label payloadFNameLbl3;
    @FXML
    private Label payloadFPathLbl3;
    @FXML
    private Label payloadFNameLbl4;
    @FXML
    private Label payloadFPathLbl4;
    @FXML
    private Label payloadFNameLbl5;
    @FXML
    private Label payloadFPathLbl5;
    @FXML
    private Label statusLbl;
    private AppPreferences preferences;
    private ResourceBundle rb;
    private String myRegexp;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.rb = resourceBundle;
        this.preferences = AppPreferences.getInstance();
        this.rcmToggleGrp.selectToggle(this.pldrRadio1);
        this.pldrRadio1.setOnAction(e -> this.statusLbl.setText(""));
        this.pldrRadio2.setOnAction(e -> this.statusLbl.setText(""));
        this.pldrRadio3.setOnAction(e -> this.statusLbl.setText(""));
        this.pldrRadio4.setOnAction(e -> this.statusLbl.setText(""));
        this.pldrRadio5.setOnAction(e -> this.statusLbl.setText(""));
        String recentRcm1 = this.preferences.getRecentRcm(1);
        String recentRcm2 = this.preferences.getRecentRcm(2);
        String recentRcm3 = this.preferences.getRecentRcm(3);
        String recentRcm4 = this.preferences.getRecentRcm(4);
        String recentRcm5 = this.preferences.getRecentRcm(5);
        this.myRegexp = File.separator.equals("/") ? "^.+/" : "^.+\\\\";
        if (!recentRcm1.isEmpty()) {
            this.payloadFNameLbl1.setText(recentRcm1.replaceAll(this.myRegexp, ""));
            this.payloadFPathLbl1.setText(recentRcm1);
        }
        if (!recentRcm2.isEmpty()) {
            this.payloadFNameLbl2.setText(recentRcm2.replaceAll(this.myRegexp, ""));
            this.payloadFPathLbl2.setText(recentRcm2);
        }
        if (!recentRcm3.isEmpty()) {
            this.payloadFNameLbl3.setText(recentRcm3.replaceAll(this.myRegexp, ""));
            this.payloadFPathLbl3.setText(recentRcm3);
        }
        if (!recentRcm4.isEmpty()) {
            this.payloadFNameLbl4.setText(recentRcm4.replaceAll(this.myRegexp, ""));
            this.payloadFPathLbl4.setText(recentRcm4);
        }
        if (!recentRcm5.isEmpty()) {
            this.payloadFNameLbl5.setText(recentRcm5.replaceAll(this.myRegexp, ""));
            this.payloadFPathLbl5.setText(recentRcm5);
        }
        this.injectPldBtn.setOnAction(actionEvent -> this.smash());
    }

    @FXML
    private void handleDragOver(DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    @FXML
    private void handleDrop(DragEvent event) {
        Node sourceNode = (Node)event.getSource();
        File fileDrpd = event.getDragboard().getFiles().get(0);
        if (fileDrpd.isDirectory()) {
            event.setDropCompleted(true);
            event.consume();
            return;
        }
        String fileNameDrpd = fileDrpd.getAbsolutePath();
        switch (sourceNode.getId()) {
            case "plHbox1": {
                this.setPayloadFile(1, fileNameDrpd);
                break;
            }
            case "plHbox2": {
                this.setPayloadFile(2, fileNameDrpd);
                break;
            }
            case "plHbox3": {
                this.setPayloadFile(3, fileNameDrpd);
                break;
            }
            case "plHbox4": {
                this.setPayloadFile(4, fileNameDrpd);
                break;
            }
            case "plHbox5": {
                this.setPayloadFile(5, fileNameDrpd);
            }
        }
        event.setDropCompleted(true);
        event.consume();
    }

    private void setPayloadFile(int RcmBoxNo, String fileName) {
        String fileNameShort = fileName.replaceAll(this.myRegexp, "");
        switch (RcmBoxNo) {
            case 1: {
                this.payloadFNameLbl1.setText(fileNameShort);
                this.payloadFPathLbl1.setText(fileName);
                this.rcmToggleGrp.selectToggle(this.pldrRadio1);
                break;
            }
            case 2: {
                this.payloadFNameLbl2.setText(fileNameShort);
                this.payloadFPathLbl2.setText(fileName);
                this.rcmToggleGrp.selectToggle(this.pldrRadio2);
                break;
            }
            case 3: {
                this.payloadFNameLbl3.setText(fileNameShort);
                this.payloadFPathLbl3.setText(fileName);
                this.rcmToggleGrp.selectToggle(this.pldrRadio3);
                break;
            }
            case 4: {
                this.payloadFNameLbl4.setText(fileNameShort);
                this.payloadFPathLbl4.setText(fileName);
                this.rcmToggleGrp.selectToggle(this.pldrRadio4);
                break;
            }
            case 5: {
                this.payloadFNameLbl5.setText(fileNameShort);
                this.payloadFPathLbl5.setText(fileName);
                this.rcmToggleGrp.selectToggle(this.pldrRadio5);
            }
        }
    }

    private void smash() {
        Rcm rcmTask;
        if (MediatorControl.INSTANCE.getTransferActive()) {
            ServiceWindow.getErrorNotification(this.rb.getString("windowTitleError"), this.rb.getString("windowBodyPleaseStopOtherProcessFirst"));
            return;
        }
        RadioButton selectedRadio = (RadioButton)this.rcmToggleGrp.getSelectedToggle();
        switch (selectedRadio.getId()) {
            case "pldrRadio1": {
                rcmTask = new Rcm(this.payloadFPathLbl1.getText());
                break;
            }
            case "pldrRadio2": {
                rcmTask = new Rcm(this.payloadFPathLbl2.getText());
                break;
            }
            case "pldrRadio3": {
                rcmTask = new Rcm(this.payloadFPathLbl3.getText());
                break;
            }
            case "pldrRadio4": {
                rcmTask = new Rcm(this.payloadFPathLbl4.getText());
                break;
            }
            case "pldrRadio5": {
                rcmTask = new Rcm(this.payloadFPathLbl5.getText());
                break;
            }
            default: {
                return;
            }
        }
        Thread rcmThread = new Thread(rcmTask);
        rcmThread.setDaemon(true);
        rcmThread.start();
    }

    @FXML
    private void bntSelectPayloader(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.rb.getString("btn_Select"));
        File validator = new File(this.payloadFPathLbl1.getText()).getParentFile();
        if (validator != null && validator.exists()) {
            fileChooser.setInitialDirectory(validator);
        } else {
            fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("bin", "*.bin"), new FileChooser.ExtensionFilter("Any file", "*.*")});
        File payloadFile = fileChooser.showOpenDialog(this.payloadFPathLbl1.getScene().getWindow());
        if (payloadFile == null) {
            return;
        }
        String fullFileName = payloadFile.getAbsolutePath();
        Node btn = (Node)event.getSource();
        switch (btn.getId()) {
            case "selPldBtn1": {
                this.setPayloadFile(1, fullFileName);
                break;
            }
            case "selPldBtn2": {
                this.setPayloadFile(2, fullFileName);
                break;
            }
            case "selPldBtn3": {
                this.setPayloadFile(3, fullFileName);
                break;
            }
            case "selPldBtn4": {
                this.setPayloadFile(4, fullFileName);
                break;
            }
            case "selPldBtn5": {
                this.setPayloadFile(5, fullFileName);
            }
        }
    }

    @FXML
    private void bntResetPayloader(ActionEvent event) {
        Node btn = (Node)event.getSource();
        this.statusLbl.setText("");
        switch (btn.getId()) {
            case "resPldBtn1": {
                this.payloadFNameLbl1.setText("");
                this.payloadFPathLbl1.setText("");
                break;
            }
            case "resPldBtn2": {
                this.payloadFNameLbl2.setText("");
                this.payloadFPathLbl2.setText("");
                break;
            }
            case "resPldBtn3": {
                this.payloadFNameLbl3.setText("");
                this.payloadFPathLbl3.setText("");
                break;
            }
            case "resPldBtn4": {
                this.payloadFNameLbl4.setText("");
                this.payloadFPathLbl4.setText("");
                break;
            }
            case "resPldBtn5": {
                this.payloadFNameLbl5.setText("");
                this.payloadFPathLbl5.setText("");
            }
        }
    }

    @FXML
    public void selectPldrPane(MouseEvent mouseEvent) {
        Node selectedPane = (Node)mouseEvent.getSource();
        switch (selectedPane.getId()) {
            case "pldPane1": {
                this.pldrRadio1.fire();
                break;
            }
            case "pldPane2": {
                this.pldrRadio2.fire();
                break;
            }
            case "pldPane3": {
                this.pldrRadio3.fire();
                break;
            }
            case "pldPane4": {
                this.pldrRadio4.fire();
                break;
            }
            case "pldPane5": {
                this.pldrRadio5.fire();
            }
        }
    }

    @Override
    public void notify(EModule type, boolean isActive, Payload payload) {
        this.rcmToolPane.setDisable(isActive);
        if (type.equals((Object)EModule.RCM)) {
            this.statusLbl.setText(payload.getMessage());
        }
    }

    public void updatePreferencesOnExit() {
        this.preferences.setRecentRcm(1, this.payloadFPathLbl1.getText());
        this.preferences.setRecentRcm(2, this.payloadFPathLbl2.getText());
        this.preferences.setRecentRcm(3, this.payloadFPathLbl3.getText());
        this.preferences.setRecentRcm(4, this.payloadFPathLbl4.getText());
        this.preferences.setRecentRcm(5, this.payloadFPathLbl5.getText());
    }
}

