/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.es.finders;

import java.util.ArrayList;
import java.util.List;
import libKonogonka.Converter;
import nsusbloader.AppPreferences;
import nsusbloader.Utilities.patches.AHeuristic;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.SimplyFind;

class HeuristicEs2
extends AHeuristic {
    private static final String PATTERN = AppPreferences.getInstance().getPatchPattern("ES", 2, 0);
    private List<Integer> findings;
    private final byte[] where;

    HeuristicEs2(byte[] where) {
        this.where = where;
        this.find();
        this.findings.removeIf(this::dropStep1);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep2);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep3);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep4);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep5);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep6);
    }

    private void find() {
        SimplyFind simplyfind = new SimplyFind(PATTERN, this.where);
        this.findings = new ArrayList<Integer>();
        for (int offset : simplyfind.getResults()) {
            this.findings.add(offset + 4);
        }
    }

    private boolean dropStep1(int offsetOfPatternFound) {
        return offsetOfPatternFound < 65536 || offsetOfPatternFound > 1048572;
    }

    private boolean dropStep2(int offsetOfPatternFound) {
        return !this.isCBNZ(Converter.getLEint(this.where, offsetOfPatternFound));
    }

    private boolean dropStep3(int offsetOfPatternFound) {
        return !this.isMOV(Converter.getLEint(this.where, offsetOfPatternFound - 4));
    }

    private boolean dropStep4(int offsetOfPatternFound) {
        int nextExpression = Converter.getLEint(this.where, offsetOfPatternFound + 4);
        return !this.isLDRB_LDURB(nextExpression);
    }

    private boolean dropStep5(int offsetOfPatternFound) {
        int expression = Converter.getLEint(this.where, offsetOfPatternFound);
        int afterJumpPosition = (expression >> 5 & 0x7FFFF) * 4 + offsetOfPatternFound & 0xFFFFF;
        int secondAfterJumpExpression = Converter.getLEint(this.where, afterJumpPosition + 4);
        return !this.isBL(secondAfterJumpExpression);
    }

    private boolean dropStep6(int offsetOfPatternFound) {
        int expression = Converter.getLEint(this.where, offsetOfPatternFound);
        int afterJumpPosition = (expression >> 5 & 0x7FFFF) * 4 + offsetOfPatternFound & 0xFFFFF;
        int forthAfterJumpExpression = Converter.getLEint(this.where, afterJumpPosition + 12);
        return !this.isBL(forthAfterJumpExpression);
    }

    @Override
    public boolean isFound() {
        return this.findings.size() == 1;
    }

    @Override
    public boolean wantLessEntropy() {
        return this.findings.size() > 1;
    }

    @Override
    public int getOffset() throws Exception {
        if (this.findings.isEmpty()) {
            throw new Exception("Nothing found");
        }
        if (this.findings.size() > 1) {
            throw new Exception("Too many offsets");
        }
        return this.findings.get(0);
    }

    @Override
    public boolean setOffsetsNearby(int offsetNearby) {
        this.findings.removeIf(offset -> {
            if (offset > offsetNearby) {
                return offset >= offsetNearby - 65535;
            }
            return offset <= offsetNearby - 65535;
        });
        return this.isFound();
    }

    @Override
    public String getDetails() {
        int secondExpressionOffset = this.findings.get(0);
        int firstExpression = Converter.getLEint(this.where, secondExpressionOffset - 4);
        int secondExpression = Converter.getLEint(this.where, secondExpressionOffset);
        int conditionalJumpLocation = 0;
        if ((secondExpression >> 24 & 0x7F) == 53) {
            conditionalJumpLocation = (secondExpression >> 5 & 0x7FFFF) * 4 + secondExpressionOffset & 0xFFFFF;
        } else if ((firstExpression >> 24 & 0x7F) == 54) {
            conditionalJumpLocation = secondExpressionOffset - 4 + (firstExpression >> 5 & 0x3FFF) * 4 & 0xFFFFF;
        }
        int secondExpressionsPairElement1 = Converter.getLEint(this.where, conditionalJumpLocation);
        int secondExpressionsPairElement2 = Converter.getLEint(this.where, conditionalJumpLocation + 4);
        int secondExpressionsPairElement3 = Converter.getLEint(this.where, conditionalJumpLocation + 8);
        int secondExpressionsPairElement4 = Converter.getLEint(this.where, conditionalJumpLocation + 12);
        return BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, secondExpressionOffset - 4), secondExpressionOffset - 4) + BinToAsmPrinter.printSimplified(secondExpression, secondExpressionOffset) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, secondExpressionOffset + 4), secondExpressionOffset + 4) + "...\n" + BinToAsmPrinter.printSimplified(secondExpressionsPairElement1, conditionalJumpLocation) + BinToAsmPrinter.printSimplified(secondExpressionsPairElement2, conditionalJumpLocation + 4) + BinToAsmPrinter.printSimplified(secondExpressionsPairElement3, conditionalJumpLocation + 8) + BinToAsmPrinter.printSimplified(secondExpressionsPairElement4, conditionalJumpLocation + 12);
    }
}

