/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.PFS;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.usb.PFS.NCAFile;

public class PFSProvider {
    private static final byte[] PFS0 = new byte[]{80, 70, 83, 48};
    private final String nspFileName;
    private final NCAFile[] ncaFiles;
    private final long bodySize;
    private int ticketID = -1;

    public PFSProvider(File nspFile, ILogPrinter logPrinter) throws Exception {
        if (nspFile.isDirectory()) {
            this.nspFileName = nspFile.getName();
            nspFile = new File(nspFile.getAbsolutePath() + File.separator + "00");
        } else {
            this.nspFileName = nspFile.getName();
        }
        RandomAccessFile randAccessFile = new RandomAccessFile(nspFile, "r");
        logPrinter.print("PFS Start NSP file analyze for [" + this.nspFileName + "]", EMsgType.INFO);
        byte[] fileStartingBytes = new byte[12];
        if (randAccessFile.read(fileStartingBytes) != 12) {
            logPrinter.print("PFS Read file starting bytes.", EMsgType.FAIL);
            randAccessFile.close();
            throw new Exception("Unable to read file starting bytes");
        }
        logPrinter.print("PFS Read file starting bytes.", EMsgType.PASS);
        if (Arrays.equals(PFS0, Arrays.copyOfRange(fileStartingBytes, 0, 4))) {
            logPrinter.print("PFS Read 'PFS0'.", EMsgType.PASS);
        } else {
            logPrinter.print("PFS Read 'PFS0': this file looks wired.", EMsgType.WARNING);
        }
        int filesCount = ByteBuffer.wrap(Arrays.copyOfRange(fileStartingBytes, 4, 8)).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (filesCount <= 0) {
            logPrinter.print("PFS Read files count", EMsgType.FAIL);
            randAccessFile.close();
            throw new Exception("Unable to read file count");
        }
        logPrinter.print("PFS Read files count [" + filesCount + "]", EMsgType.PASS);
        int header = ByteBuffer.wrap(Arrays.copyOfRange(fileStartingBytes, 8, 12)).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (header <= 0) {
            logPrinter.print("PFS Read header ", EMsgType.FAIL);
            randAccessFile.close();
            throw new Exception("Unable to read header");
        }
        logPrinter.print("PFS Read header [" + header + "]", EMsgType.PASS);
        this.ncaFiles = new NCAFile[filesCount];
        byte[] ncaInfoArr = new byte[24];
        LinkedHashMap<Integer, Long> ncaNameOffsets = new LinkedHashMap<Integer, Long>();
        for (int i = 0; i < filesCount; ++i) {
            if (randAccessFile.read(ncaInfoArr) != 24) {
                logPrinter.print("PFS Read NCA inside NSP: " + i, EMsgType.FAIL);
                randAccessFile.close();
                throw new Exception("Unable to read NCA inside NSP");
            }
            logPrinter.print("PFS Read NCA inside NSP: " + i, EMsgType.PASS);
            int offset = ByteBuffer.wrap(Arrays.copyOfRange(ncaInfoArr, 0, 4)).order(ByteOrder.LITTLE_ENDIAN).getInt();
            long nca_offset = ByteBuffer.wrap(Arrays.copyOfRange(ncaInfoArr, 4, 12)).order(ByteOrder.LITTLE_ENDIAN).getLong();
            long nca_size = ByteBuffer.wrap(Arrays.copyOfRange(ncaInfoArr, 12, 20)).order(ByteOrder.LITTLE_ENDIAN).getLong();
            long nca_name_offset = ByteBuffer.wrap(Arrays.copyOfRange(ncaInfoArr, 20, 24)).order(ByteOrder.LITTLE_ENDIAN).getInt();
            logPrinter.print("  Padding check", offset == 0 ? EMsgType.PASS : EMsgType.WARNING);
            logPrinter.print("  NCA offset check: " + nca_offset, nca_offset >= 0L ? EMsgType.PASS : EMsgType.WARNING);
            logPrinter.print("  NCA size check: " + nca_size, nca_size >= 0L ? EMsgType.PASS : EMsgType.WARNING);
            logPrinter.print("  NCA name offset check: " + nca_name_offset, nca_name_offset >= 0L ? EMsgType.PASS : EMsgType.WARNING);
            NCAFile ncaFile = new NCAFile();
            ncaFile.setNcaOffset(nca_offset);
            ncaFile.setNcaSize(nca_size);
            this.ncaFiles[i] = ncaFile;
            ncaNameOffsets.put(i, nca_name_offset);
        }
        byte[] bufForInt = new byte[4];
        if (randAccessFile.read(bufForInt) == 4 && Arrays.equals(bufForInt, new byte[4])) {
            logPrinter.print("PFS Final padding check", EMsgType.PASS);
        } else {
            logPrinter.print("PFS Final padding check", EMsgType.WARNING);
        }
        this.bodySize = randAccessFile.getFilePointer() + (long)header;
        logPrinter.print("PFS Collecting file names", EMsgType.INFO);
        byte[] b = new byte[1];
        for (int i = 0; i < filesCount; ++i) {
            ArrayList<Byte> ncaFN = new ArrayList<Byte>();
            randAccessFile.seek((long)filesCount * 24L + 16L + (Long)((HashMap)ncaNameOffsets).get(i));
            while (randAccessFile.read(b) != -1 && b[0] != 0) {
                ncaFN.add(b[0]);
            }
            byte[] exchangeTempArray = new byte[ncaFN.size()];
            for (int j = 0; j < ncaFN.size(); ++j) {
                exchangeTempArray[j] = (Byte)ncaFN.get(j);
            }
            if (new String(exchangeTempArray, StandardCharsets.UTF_8).toLowerCase().endsWith(".tik")) {
                this.ticketID = i;
            }
            this.ncaFiles[i].setNcaFileName(Arrays.copyOf(exchangeTempArray, exchangeTempArray.length));
        }
        randAccessFile.close();
        logPrinter.print("PFS Finished NSP file analyze for [" + this.nspFileName + "]", EMsgType.PASS);
    }

    public byte[] getBytesNspFileName() {
        return this.nspFileName.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getBytesNspFileNameLength() {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.getBytesNspFileName().length).array();
    }

    public byte[] getBytesCountOfNca() {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.ncaFiles.length).array();
    }

    public int getIntCountOfNca() {
        return this.ncaFiles.length;
    }

    public NCAFile getNca(int ncaNumber) {
        return this.ncaFiles[ncaNumber];
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public int getNcaTicketID() {
        return this.ticketID;
    }
}

