/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka;

import java.nio.charset.StandardCharsets;
import libKonogonka.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RainbowDump {
    private static final Logger log = LogManager.getLogger(Converter.class);
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_BLUE = "\u001b[34m";
    private static StringBuilder stringBuilder;

    public static void hexDumpUTF8(byte[] byteArray) {
        stringBuilder = new StringBuilder(" -- RainbowDump --\n");
        if (byteArray == null || byteArray.length == 0) {
            return;
        }
        int k = 0;
        stringBuilder.append(String.format("%s%08x  %s", ANSI_BLUE, 0, ANSI_RESET));
        for (int i = 0; i < byteArray.length; ++i) {
            if (k == 8) {
                stringBuilder.append("  ");
            }
            if (k == 16) {
                stringBuilder.append("\u001b[32m| \u001b[0m");
                RainbowDump.printChars(byteArray, i);
                stringBuilder.append("\n").append(String.format("%s%08x  %s", ANSI_BLUE, i, ANSI_RESET));
                k = 0;
            }
            stringBuilder.append(String.format("%02x ", byteArray[i]));
            ++k;
        }
        int paddingSize = 16 - byteArray.length % 16;
        if (paddingSize != 16) {
            for (int i = 0; i < paddingSize; ++i) {
                stringBuilder.append("   ");
            }
            if (paddingSize > 7) {
                stringBuilder.append("  ");
            }
        }
        stringBuilder.append("\u001b[32m| \u001b[0m");
        RainbowDump.printChars(byteArray, byteArray.length);
        stringBuilder.append("\n").append(ANSI_RESET).append(new String(byteArray, StandardCharsets.UTF_8)).append("\n");
        log.debug(stringBuilder.toString());
    }

    private static void printChars(byte[] byteArray, int pointer) {
        for (int j = pointer < 16 ? 0 : pointer - 16; j < pointer; ++j) {
            if (byteArray[j] > 21 && byteArray[j] < 126) {
                stringBuilder.append((char)byteArray[j]);
                continue;
            }
            if (byteArray[j] == 10) {
                stringBuilder.append("\u21b2");
                continue;
            }
            if (byteArray[j] == 13) {
                stringBuilder.append("\u2190");
                continue;
            }
            stringBuilder.append(".");
        }
    }

    public static void hexDumpUTF8Legacy(byte[] byteArray) {
        StringBuilder stringBuilderLegacy = new StringBuilder("HexDumpUTF8Legacy");
        stringBuilderLegacy.append(ANSI_BLUE);
        if (byteArray == null || byteArray.length == 0) {
            return;
        }
        for (int i = 0; i < byteArray.length; ++i) {
            stringBuilderLegacy.append(String.format("%02d-", i % 100));
        }
        stringBuilderLegacy.append(">\u001b[31m").append(byteArray.length).append(ANSI_RESET).append("\n");
        for (byte b : byteArray) {
            stringBuilderLegacy.append(String.format("%02x ", b));
        }
        stringBuilderLegacy.append("\n").append(new String(byteArray, StandardCharsets.UTF_8)).append("\n");
        log.debug(stringBuilderLegacy.toString());
    }

    public static void binDumpInt(int value) {
        log.debug(Converter.intToBinaryString(value));
    }

    public static void binDumpLong(long value) {
        log.debug(String.format("%64s", Long.toBinaryString(value)).replace(' ', '0') + " | " + value);
    }

    public static String formatDecHexString(long value) {
        return String.format("%-20d 0x%x", value, value);
    }

    public static String formatDecHexString(int value) {
        return String.format("%-20d 0x%x", value, value);
    }
}

