/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader;

import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import nsusbloader.AppPreferences;

public class ServiceWindow {
    public static void getErrorNotification(String title, String body) {
        ServiceWindow.getNotification(title, body, Alert.AlertType.ERROR);
    }

    public static void getInfoNotification(String title, String body) {
        ServiceWindow.getNotification(title, body, Alert.AlertType.INFORMATION);
    }

    private static void getNotification(String title, String body, Alert.AlertType type) {
        Alert alertBox = new Alert(type);
        alertBox.setTitle(title);
        alertBox.setHeaderText(null);
        alertBox.setContentText(body);
        alertBox.getDialogPane().setMinWidth(Double.NEGATIVE_INFINITY);
        alertBox.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alertBox.setResizable(true);
        Stage dialogStage = (Stage)alertBox.getDialogPane().getScene().getWindow();
        dialogStage.setAlwaysOnTop(true);
        dialogStage.getIcons().addAll((Image[])new Image[]{new Image("/res/warn_ico32x32.png"), new Image("/res/warn_ico48x48.png"), new Image("/res/warn_ico64x64.png"), new Image("/res/warn_ico128x128.png")});
        alertBox.getDialogPane().getStylesheets().add(AppPreferences.getInstance().getTheme());
        dialogStage.getScene().getRoot().setStyle(AppPreferences.getInstance().getFontStyle());
        alertBox.show();
        dialogStage.toFront();
    }

    public static boolean getConfirmationWindow(String title, String body) {
        Alert alertBox = new Alert(Alert.AlertType.CONFIRMATION);
        alertBox.setTitle(title);
        alertBox.setHeaderText(null);
        alertBox.setContentText(body);
        alertBox.getDialogPane().setMinWidth(Double.NEGATIVE_INFINITY);
        alertBox.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alertBox.setResizable(true);
        Stage dialogStage = (Stage)alertBox.getDialogPane().getScene().getWindow();
        dialogStage.setAlwaysOnTop(true);
        dialogStage.getIcons().addAll((Image[])new Image[]{new Image("/res/ask_ico32x32.png"), new Image("/res/ask_ico48x48.png"), new Image("/res/ask_ico64x64.png"), new Image("/res/ask_ico128x128.png")});
        alertBox.getDialogPane().getStylesheets().add(AppPreferences.getInstance().getTheme());
        dialogStage.getScene().getRoot().setStyle(AppPreferences.getInstance().getFontStyle());
        dialogStage.toFront();
        Optional result = alertBox.showAndWait();
        return result.isPresent() && result.get() == ButtonType.OK;
    }
}

