/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.es.finders;

import java.util.List;
import libKonogonka.Converter;
import nsusbloader.AppPreferences;
import nsusbloader.Utilities.patches.AHeuristic;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.SimplyFind;

class HeuristicEs1
extends AHeuristic {
    private static final String PATTERN = AppPreferences.getInstance().getPatchPattern("ES", 1, 0);
    private final List<Integer> findings;
    private final byte[] where;

    HeuristicEs1(byte[] where) {
        this.where = where;
        SimplyFind simplyfind = new SimplyFind(PATTERN, where);
        this.findings = simplyfind.getResults();
        this.findings.removeIf(this::dropStep1);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep2);
    }

    private boolean dropStep1(int offsetOfPatternFound) {
        return offsetOfPatternFound < 65536 || offsetOfPatternFound > 1048572;
    }

    private boolean dropStep2(int offsetOfPatternFound) {
        return (this.where[offsetOfPatternFound - 1] & 0x7F) != 52;
    }

    @Override
    public boolean isFound() {
        return this.findings.size() == 1;
    }

    @Override
    public boolean wantLessEntropy() {
        return this.findings.size() > 1;
    }

    @Override
    public int getOffset() throws Exception {
        if (this.findings.isEmpty()) {
            throw new Exception("Nothing found");
        }
        if (this.findings.size() > 1) {
            throw new Exception("Too many offsets");
        }
        return this.findings.get(0);
    }

    @Override
    public boolean setOffsetsNearby(int offsetNearby) {
        this.findings.removeIf(offset -> {
            if (offset > offsetNearby) {
                return offset >= offsetNearby - 65535;
            }
            return offset <= offsetNearby - 65535;
        });
        return this.isFound();
    }

    @Override
    public String getDetails() {
        int cbzOffsetInternal = this.findings.get(0) - 4;
        int instructionExpression = Converter.getLEint(this.where, cbzOffsetInternal);
        int conditionalJumpLocation = (instructionExpression >> 5 & 0x7FFFF) * 4 + cbzOffsetInternal & 0xFFFFF;
        int secondExpressionsPairElement1 = Converter.getLEint(this.where, conditionalJumpLocation);
        int secondExpressionsPairElement2 = Converter.getLEint(this.where, conditionalJumpLocation + 4);
        return BinToAsmPrinter.printSimplified(instructionExpression, cbzOffsetInternal) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, cbzOffsetInternal + 4), cbzOffsetInternal + 4) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, cbzOffsetInternal + 8), cbzOffsetInternal + 8) + "...\n" + BinToAsmPrinter.printSimplified(secondExpressionsPairElement1, conditionalJumpLocation) + BinToAsmPrinter.printSimplified(secondExpressionsPairElement2, conditionalJumpLocation + 4);
    }
}

