/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.common;

import java.util.ArrayList;
import java.util.List;
import nsusbloader.com.usb.common.NsUsbEndpointDescriptor;
import nsusbloader.com.usb.common.NsUsbInterface;
import nsusbloader.com.usb.common.NsUsbInterfaceDescriptor;
import org.usb4java.ConfigDescriptor;
import org.usb4java.Device;
import org.usb4java.DeviceHandle;
import org.usb4java.Interface;
import org.usb4java.LibUsb;

public class DeviceInformation {
    private static final byte DEFAULT_IN_EP_ADDRESS = -127;
    private static final byte DEFAULT_OUT_EP_ADDRESS = 1;
    private Device device;
    private ConfigDescriptor configDescriptor;
    private List<NsUsbInterface> interfacesInformation = new ArrayList<NsUsbInterface>();

    private DeviceInformation() {
    }

    public static DeviceInformation build(DeviceHandle handler) throws Exception {
        Device device = LibUsb.getDevice(handler);
        return DeviceInformation.build(device);
    }

    public static DeviceInformation build(Device device) throws Exception {
        DeviceInformation deviceInformation = new DeviceInformation();
        deviceInformation.device = device;
        deviceInformation.claimConfigurationDescriptor();
        deviceInformation.collectInterfaces();
        deviceInformation.freeConfigurationDescriptor();
        return deviceInformation;
    }

    private void claimConfigurationDescriptor() throws Exception {
        this.configDescriptor = new ConfigDescriptor();
        int returningValue = LibUsb.getActiveConfigDescriptor(this.device, this.configDescriptor);
        if (returningValue != 0) {
            throw new Exception("Get Active config descriptor failed: " + LibUsb.errorName(returningValue));
        }
    }

    private void collectInterfaces() {
        for (Interface intrface : this.configDescriptor.iface()) {
            this.interfacesInformation.add(new NsUsbInterface(intrface));
        }
    }

    private void freeConfigurationDescriptor() {
        LibUsb.freeConfigDescriptor(this.configDescriptor);
    }

    public NsUsbEndpointDescriptor getSimplifiedDefaultEndpointDescriptorIn() throws Exception {
        return this.getSimplifiedDefaultEndpointDescriptor(true);
    }

    public NsUsbEndpointDescriptor getSimplifiedDefaultEndpointDescriptorOut() throws Exception {
        return this.getSimplifiedDefaultEndpointDescriptor(false);
    }

    private NsUsbEndpointDescriptor getSimplifiedDefaultEndpointDescriptor(boolean isDescriptorIN) throws Exception {
        NsUsbEndpointDescriptor[] endpointDescriptors;
        byte endpointAddress = isDescriptorIN ? (byte)-127 : 1;
        NsUsbInterface nsUsbInterface = this.interfacesInformation.get(0);
        NsUsbInterfaceDescriptor firstInterfaceDescriptor = nsUsbInterface.getInterfaceDescriptors()[0];
        for (NsUsbEndpointDescriptor epDescriptor : endpointDescriptors = firstInterfaceDescriptor.getEndpointDescriptors()) {
            if (epDescriptor.getbEndpointAddress() != endpointAddress) continue;
            return epDescriptor;
        }
        throw new Exception("No " + (isDescriptorIN ? "IN" : "OUT") + " endpoint descriptors found on default interface");
    }
}

