/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.xtsaes;

import java.util.Objects;
import java.util.function.LongFunction;
import libKonogonka.xtsaes.XTSCore;
import libKonogonka.xtsaes.XTSTweak;
import net.jcip.annotations.NotThreadSafe;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

@NotThreadSafe
public class XTSAESCipher {
    private final XTSCore core;
    private final int blockSize;

    XTSAESCipher(XTSCore core) {
        this.core = Objects.requireNonNull(core, "core");
        this.blockSize = core.getBlockSize();
    }

    public XTSAESCipher(LongFunction<byte[]> tweakFunction) {
        this(new XTSCore(new XTSTweak(tweakFunction)));
    }

    public XTSAESCipher(boolean isDefault) {
        this(new XTSCore(isDefault));
    }

    String getAlgorithmName() {
        return this.core.getAlgorithmName();
    }

    int getBlockSize() {
        return this.blockSize;
    }

    public XTSAESCipher init(boolean forEncryption, KeyParameter key) throws IllegalArgumentException {
        this.core.init(forEncryption, key);
        return this;
    }

    public XTSAESCipher init(boolean forEncryption, KeyParameter key1, KeyParameter key2) throws IllegalArgumentException {
        this.core.init(forEncryption, key1, key2);
        return this;
    }

    public int processDataUnit(byte[] in, int inOff, int length, byte[] out, int outOff, long sequenceNumber) throws DataLengthException, IllegalStateException {
        this.core.reset(sequenceNumber);
        return this.process(in, inOff, length, out, outOff);
    }

    int process(byte[] in, int inOff, int length, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int i;
        if (length < this.blockSize) {
            throw new DataLengthException("data unit size too small: " + length);
        }
        if (inOff + length > in.length) {
            throw new DataLengthException("input buffer too small for data unit size: " + length);
        }
        if (outOff + length > out.length) {
            throw new DataLengthException("output buffer too small for data unit size: " + length);
        }
        int to = length % this.blockSize == 0 ? length : length - this.blockSize * 2;
        for (i = 0; i < to; i += this.blockSize) {
            this.core.processBlock(in, inOff + i, out, outOff + i);
        }
        if (length > i) {
            this.core.processPartial(in, inOff + i, out, outOff + i, length - i);
        }
        return length;
    }
}

