/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import libKonogonka.KeyChainHolder;
import libKonogonka.fs.NCA.NCAProvider;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.fs.FsNcaSearchTask;
import nsusbloader.Utilities.patches.fs.FsPatch;

public class FsPatchMaker
extends CancellableRunnable {
    private int THREADS_POOL_SIZE;
    private final ILogPrinter logPrinter = Log.getPrinter(EModule.PATCHES);
    private final String pathToFirmware;
    private final String pathToKeysFile;
    private final String saveTo;
    private File firmware;
    private KeyChainHolder keyChainHolder;
    private ExecutorService executorService;
    private List<String> ncaFilesList;
    private boolean oneLinerStatus = false;

    public FsPatchMaker(String pathToFirmware, String pathToKeysFile, String saveTo) {
        this.pathToFirmware = pathToFirmware;
        this.pathToKeysFile = pathToKeysFile;
        this.saveTo = saveTo;
    }

    @Override
    public void run() {
        try {
            this.logPrinter.print("..:: Make FS Patches ::..", EMsgType.INFO);
            this.receiveFirmware();
            this.buildKeyChainHolder();
            this.receiveNcaFileNamesList();
            this.specifyThreadsPoolSize();
            this.createPool();
            this.executePool();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.logPrinter.print(e.getMessage(), EMsgType.FAIL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.logPrinter.updateOneLinerStatus(this.oneLinerStatus);
            this.logPrinter.close();
        }
    }

    private void receiveFirmware() throws Exception {
        this.logPrinter.print("Looking at firmware", EMsgType.INFO);
        this.firmware = new File(this.pathToFirmware);
        if (!this.firmware.exists()) {
            throw new Exception("Firmware directory does not exist " + this.pathToFirmware);
        }
    }

    private void buildKeyChainHolder() throws Exception {
        this.logPrinter.print("Reading keys", EMsgType.INFO);
        this.keyChainHolder = new KeyChainHolder(this.pathToKeysFile, null);
    }

    private void receiveNcaFileNamesList() throws Exception {
        this.logPrinter.print("Collecting NCA files", EMsgType.INFO);
        String[] fileNamesArray = this.firmware.list((directory, file) -> !file.endsWith(".cnmt.nca") && file.endsWith(".nca"));
        this.ncaFilesList = Arrays.asList(Objects.requireNonNull(fileNamesArray));
        if (this.ncaFilesList.size() == 0) {
            throw new Exception("No NCA files found in firmware folder");
        }
    }

    private void specifyThreadsPoolSize() {
        this.THREADS_POOL_SIZE = Math.max(Runtime.getRuntime().availableProcessors() + 1, 4);
        this.THREADS_POOL_SIZE = Math.min(this.THREADS_POOL_SIZE, this.ncaFilesList.size());
    }

    private void createPool() throws Exception {
        this.logPrinter.print("Creating sub-tasks pool", EMsgType.INFO);
        this.executorService = Executors.newFixedThreadPool(this.THREADS_POOL_SIZE, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
    }

    private void executePool() throws Exception {
        try {
            this.logPrinter.print("Executing sub-tasks pool", EMsgType.INFO);
            List<Future<List<NCAProvider>>> futuresResults = this.executorService.invokeAll(this.getSubTasksCollection());
            int counter = 0;
            block5: for (Future<List<NCAProvider>> future : futuresResults) {
                List<NCAProvider> ncaProviders = future.get();
                for (NCAProvider ncaProvider : ncaProviders) {
                    this.makePatches(ncaProvider);
                    if (++counter <= 1) continue;
                    continue block5;
                }
            }
            this.executorService.shutdown();
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            boolean interruptedSuccessfully = false;
            try {
                interruptedSuccessfully = this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException awaitInterrupt) {
                this.logPrinter.print("Force interrupting task...", EMsgType.WARNING);
            }
            this.logPrinter.print("Task interrupted " + (interruptedSuccessfully ? "successfully" : "with some issues"), EMsgType.WARNING);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logPrinter.print("Task failed: " + e.getMessage(), EMsgType.FAIL);
        }
    }

    private void makePatches(NCAProvider ncaProvider) throws Exception {
        File foundFile = ncaProvider.getFile();
        this.logPrinter.print(String.format("File found: .." + File.separator + "%s" + File.separator + "%s", foundFile.getParentFile().getName(), foundFile.getName()), EMsgType.INFO);
        new FsPatch(ncaProvider, this.saveTo, this.keyChainHolder, this.logPrinter);
        this.oneLinerStatus = true;
    }

    private List<Callable<List<NCAProvider>>> getSubTasksCollection() throws Exception {
        FsNcaSearchTask task;
        this.logPrinter.print("Forming sub-tasks collection", EMsgType.INFO);
        ArrayList<Callable<List<NCAProvider>>> subTasks = new ArrayList<Callable<List<NCAProvider>>>();
        int ncaPerThreadAmount = this.ncaFilesList.size() / this.THREADS_POOL_SIZE;
        ListIterator<String> iterator = this.ncaFilesList.listIterator();
        for (int i = 1; i < this.THREADS_POOL_SIZE; ++i) {
            task = new FsNcaSearchTask(this.getNextSet(iterator, ncaPerThreadAmount));
            subTasks.add(task);
        }
        int leftovers = this.ncaFilesList.size() % this.THREADS_POOL_SIZE;
        task = new FsNcaSearchTask(this.getNextSet(iterator, ncaPerThreadAmount + leftovers));
        subTasks.add(task);
        return subTasks;
    }

    private List<NCAProvider> getNextSet(Iterator<String> iterator, int amount) throws Exception {
        ArrayList<NCAProvider> ncas = new ArrayList<NCAProvider>();
        for (int j = 0; j < amount; ++j) {
            String ncaFileName = iterator.next();
            File nca = new File(this.firmware.getAbsolutePath() + File.separator + ncaFileName);
            NCAProvider provider = new NCAProvider(nca, this.keyChainHolder.getRawKeySet());
            ncas.add(provider);
        }
        return ncas;
    }
}

