/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.aesctr;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import libKonogonka.Converter;
import libKonogonka.aesctr.AesCtrDecrypt;

public class AesCtrDecryptClassic
extends AesCtrDecrypt {
    private final SecretKeySpec key;
    private final byte[] ivArray;
    private Cipher cipher;

    public AesCtrDecryptClassic(String keyString, byte[] ivArray) throws Exception {
        this.key = new SecretKeySpec(Converter.hexStringToByteArray(keyString), "AES");
        this.ivArray = ivArray;
        this.reset();
    }

    @Override
    public byte[] decryptNext(byte[] encryptedData) {
        return this.cipher.update(encryptedData);
    }

    @Override
    public void resetAndSkip(long blockCount) throws Exception {
        this.reset(this.calculateCtr(blockCount * 512L));
    }

    private byte[] calculateCtr(long offset) {
        BigInteger ctr = new BigInteger(this.ivArray);
        BigInteger updateTo = BigInteger.valueOf(offset / 16L);
        byte[] ctrCalculated = ctr.add(updateTo).toByteArray();
        if (ctrCalculated.length != 16) {
            ByteBuffer ctrByteBuffer = ByteBuffer.allocate(16);
            ctrByteBuffer.position(16 - ctrCalculated.length);
            ctrByteBuffer.put(ctrCalculated);
            return ctrByteBuffer.array();
        }
        return ctrCalculated;
    }

    @Override
    public void reset() throws Exception {
        this.reset((byte[])this.ivArray.clone());
    }

    private void reset(byte[] updatedIvArray) throws Exception {
        this.cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        IvParameterSpec iv = new IvParameterSpec(updatedIvArray);
        this.cipher.init(2, (Key)this.key, iv);
    }
}

