/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.es.finders;

import java.util.List;
import libKonogonka.Converter;
import nsusbloader.AppPreferences;
import nsusbloader.Utilities.patches.AHeuristic;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.SimplyFind;

class HeuristicEs3
extends AHeuristic {
    private static final String PATTERN0 = AppPreferences.getInstance().getPatchPattern("ES", 3, 0);
    private static final String PATTERN1 = AppPreferences.getInstance().getPatchPattern("ES", 3, 1);
    private final List<Integer> findings;
    private final byte[] where;

    HeuristicEs3(long fwVersion, byte[] where) {
        this.where = where;
        String pattern = this.getPattern(fwVersion);
        SimplyFind simplyfind = new SimplyFind(pattern, where);
        this.findings = simplyfind.getResults();
        this.findings.removeIf(this::dropStep1);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep2);
        if (this.findings.size() < 2) {
            return;
        }
        this.findings.removeIf(this::dropStep3);
    }

    private String getPattern(long fwVersion) {
        if (fwVersion < 10400L) {
            return PATTERN0;
        }
        return PATTERN1;
    }

    private boolean dropStep1(int offsetOfPatternFound) {
        return (this.where[offsetOfPatternFound - 1] & 0x7F) != 52;
    }

    private boolean dropStep2(int offsetOfPatternFound) {
        int conditionalJumpLocation = this.getCBZConditionalJumpLocation(offsetOfPatternFound - 4);
        int afterJumpSecondExpressions = Converter.getLEint(this.where, conditionalJumpLocation);
        int afterJumpThirdExpressions = Converter.getLEint(this.where, conditionalJumpLocation + 4);
        return !this.isMOV_REG(afterJumpSecondExpressions) || !this.isB(afterJumpThirdExpressions);
    }

    private boolean dropStep3(int offsetOfPatternFound) {
        int conditionalJumpLocation = this.getCBZConditionalJumpLocation(offsetOfPatternFound - 4);
        int afterJumpSecondExpressions = Converter.getLEint(this.where, conditionalJumpLocation + 4);
        int secondPairConditionalJumpLocation = (afterJumpSecondExpressions & 0x3FFFFFF) * 4 + (conditionalJumpLocation + 4) & 0xFFFFF;
        int thirdExpressionsPairElement1 = Converter.getLEint(this.where, secondPairConditionalJumpLocation);
        int thirdExpressionsPairElement2 = Converter.getLEint(this.where, secondPairConditionalJumpLocation + 4);
        return !this.isADD(thirdExpressionsPairElement1) || !this.isBL(thirdExpressionsPairElement2);
    }

    private int getCBZConditionalJumpLocation(int cbzOffsetInternal) {
        int cbzExpression = Converter.getLEint(this.where, cbzOffsetInternal);
        return (cbzExpression >> 5 & 0x7FFFF) * 4 + cbzOffsetInternal & 0xFFFFF;
    }

    @Override
    public boolean isFound() {
        return this.findings.size() == 1;
    }

    @Override
    public boolean wantLessEntropy() {
        return this.findings.size() > 1;
    }

    @Override
    public int getOffset() throws Exception {
        if (this.findings.isEmpty()) {
            throw new Exception("Nothing found");
        }
        if (this.findings.size() > 1) {
            throw new Exception("Too many offsets");
        }
        return this.findings.get(0);
    }

    @Override
    public boolean setOffsetsNearby(int offsetNearby) {
        this.findings.removeIf(offset -> {
            if (offset > offsetNearby) {
                return offset >= offsetNearby - 65535;
            }
            return offset <= offsetNearby - 65535;
        });
        return this.isFound();
    }

    @Override
    public String getDetails() {
        int cbzOffsetInternal = this.findings.get(0) - 4;
        int cbzExpression = Converter.getLEint(this.where, cbzOffsetInternal);
        int conditionalJumpLocation = (cbzExpression >> 5 & 0x7FFFF) * 4 + cbzOffsetInternal & 0xFFFFF;
        int secondExpressionsPairElement1 = Converter.getLEint(this.where, conditionalJumpLocation);
        int secondExpressionsPairElement2 = Converter.getLEint(this.where, conditionalJumpLocation + 4);
        StringBuilder builder = new StringBuilder();
        builder.append(BinToAsmPrinter.printSimplified(cbzExpression, cbzOffsetInternal));
        builder.append(BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, cbzOffsetInternal + 4), cbzOffsetInternal + 4));
        builder.append(BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, cbzOffsetInternal + 8), cbzOffsetInternal + 8));
        builder.append("...\n");
        builder.append(BinToAsmPrinter.printSimplified(secondExpressionsPairElement1, conditionalJumpLocation));
        builder.append(BinToAsmPrinter.printSimplified(secondExpressionsPairElement2, conditionalJumpLocation + 4));
        if ((secondExpressionsPairElement2 >> 26 & 0x3F) == 5) {
            builder.append("...\n");
            int conditionalJumpLocation2 = (secondExpressionsPairElement2 & 0x3FFFFFF) * 4 + (conditionalJumpLocation + 4) & 0xFFFFF;
            builder.append(BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, conditionalJumpLocation2), conditionalJumpLocation2));
            builder.append(BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, conditionalJumpLocation2 + 4), conditionalJumpLocation2 + 4));
        } else {
            builder.append("NO CONDITIONAL JUMP ON 2nd iteration (HeuristicEs3)");
        }
        return builder.toString();
    }
}

