/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.PFS;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.DataConvertUtils;
import nsusbloader.com.usb.PFS.NCAFile;

public class PFSProvider {
    private final String nspFileName;
    private final NCAFile[] ncaFiles;
    private final long bodySize;
    private int ticketID = -1;

    public PFSProvider(File nspFile, ILogPrinter log) throws Exception {
        this.nspFileName = nspFile.getName();
        if (nspFile.isDirectory()) {
            nspFile = new File(nspFile.getAbsolutePath() + File.separator + "00");
        }
        RandomAccessFile randAccessFile = new RandomAccessFile(nspFile, "r");
        log.print("PFS Start NSP file analyze for [" + this.nspFileName + "]", EMsgType.INFO);
        byte[] fileStartingBytes = new byte[12];
        if (randAccessFile.read(fileStartingBytes) != 12) {
            log.print("PFS Read file starting bytes.", EMsgType.FAIL);
            randAccessFile.close();
            throw new Exception("Unable to read file starting bytes");
        }
        log.print("PFS Read file starting bytes.", EMsgType.PASS);
        if ("PFS0".equals(new String(fileStartingBytes, 0, 4, StandardCharsets.US_ASCII))) {
            log.print("PFS Read 'PFS0'.", EMsgType.PASS);
        } else {
            log.print("PFS Read 'PFS0': this file looks wired.", EMsgType.WARNING);
        }
        int filesCount = DataConvertUtils.arrToIntLE(fileStartingBytes, 4);
        if (filesCount <= 0) {
            log.print("PFS Read files count", EMsgType.FAIL);
            randAccessFile.close();
            throw new Exception("Unable to read file count");
        }
        log.print("PFS Read files count [" + filesCount + "]", EMsgType.PASS);
        int header = DataConvertUtils.arrToIntLE(fileStartingBytes, 8);
        if (header <= 0) {
            log.print("PFS Read header ", EMsgType.FAIL);
            randAccessFile.close();
            throw new Exception("Unable to read header");
        }
        log.print("PFS Read header [" + header + "]", EMsgType.PASS);
        this.ncaFiles = new NCAFile[filesCount];
        byte[] ncaInfoArr = new byte[24];
        LinkedHashMap<Integer, Long> ncaNameOffsets = new LinkedHashMap<Integer, Long>();
        for (int i = 0; i < filesCount; ++i) {
            if (randAccessFile.read(ncaInfoArr) != 24) {
                log.print("PFS Read NCA inside NSP: " + i, EMsgType.FAIL);
                randAccessFile.close();
                throw new Exception("Unable to read NCA inside NSP");
            }
            log.print("PFS Read NCA inside NSP: " + i, EMsgType.PASS);
            int offset = DataConvertUtils.arrToIntLE(ncaInfoArr, 0);
            long nca_offset = DataConvertUtils.arrToLongLE(ncaInfoArr, 4);
            long nca_size = DataConvertUtils.arrToLongLE(ncaInfoArr, 12);
            long nca_name_offset = DataConvertUtils.arrToIntLE(ncaInfoArr, 20);
            log.print("  Padding check", offset == 0 ? EMsgType.PASS : EMsgType.WARNING);
            log.print("  NCA offset check: " + nca_offset, nca_offset >= 0L ? EMsgType.PASS : EMsgType.WARNING);
            log.print("  NCA size check: " + nca_size, nca_size >= 0L ? EMsgType.PASS : EMsgType.WARNING);
            log.print("  NCA name offset check: " + nca_name_offset, nca_name_offset >= 0L ? EMsgType.PASS : EMsgType.WARNING);
            NCAFile ncaFile = new NCAFile();
            ncaFile.setNcaOffset(nca_offset);
            ncaFile.setNcaSize(nca_size);
            this.ncaFiles[i] = ncaFile;
            ncaNameOffsets.put(i, nca_name_offset);
        }
        byte[] bufForInt = new byte[4];
        log.print("PFS Final padding check", randAccessFile.read(bufForInt) == 4 && Arrays.equals(bufForInt, new byte[4]) ? EMsgType.PASS : EMsgType.WARNING);
        this.bodySize = randAccessFile.getFilePointer() + (long)header;
        log.print("PFS Collecting file names", EMsgType.INFO);
        long seekIncrement = (long)filesCount * 24L + 16L;
        byte[] b = new byte[1];
        for (int i = 0; i < filesCount; ++i) {
            ArrayList<Byte> ncaFN = new ArrayList<Byte>();
            randAccessFile.seek(seekIncrement + (Long)ncaNameOffsets.get(i));
            while (randAccessFile.read(b) != -1 && b[0] != 0) {
                ncaFN.add(b[0]);
            }
            byte[] exchangeTempArray = new byte[ncaFN.size()];
            for (int j = 0; j < ncaFN.size(); ++j) {
                exchangeTempArray[j] = (Byte)ncaFN.get(j);
            }
            if (new String(exchangeTempArray, StandardCharsets.UTF_8).toLowerCase().endsWith(".tik")) {
                this.ticketID = i;
            }
            this.ncaFiles[i].setNcaFileName(Arrays.copyOf(exchangeTempArray, exchangeTempArray.length));
        }
        randAccessFile.close();
        log.print("PFS Finished NSP file analyze for [" + this.nspFileName + "]", EMsgType.PASS);
    }

    public byte[] getBytesNspFileName() {
        return this.nspFileName.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getBytesNspFileNameLength() {
        return DataConvertUtils.intToArrLE(this.getBytesNspFileName().length);
    }

    public byte[] getBytesCountOfNca() {
        return DataConvertUtils.intToArrLE(this.ncaFiles.length);
    }

    public int getIntCountOfNca() {
        return this.ncaFiles.length;
    }

    public NCAFile getNca(int ncaNumber) {
        return this.ncaFiles[ncaNumber];
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public int getNcaTicketID() {
        return this.ticketID;
    }
}

