/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.XCI;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import libKonogonka.Converter;

public class XCIGamecardInfo {
    private long fwVersion;
    private byte[] accessCtrlFlags;
    private int readWaitTime1;
    private int readWaitTime2;
    private int writeWaitTime1;
    private int writeWaitTime2;
    private byte[] fwMode;
    private byte[] cupVersion;
    private byte[] emptyPadding1;
    private byte[] updPartHash;
    private byte[] cupID;
    private byte[] emptyPadding2;

    XCIGamecardInfo(byte[] infoBytes, byte[] IV, String XCI_HEADER_KEY) throws Exception {
        if (XCI_HEADER_KEY.trim().isEmpty()) {
            return;
        }
        if (infoBytes.length != 112) {
            throw new Exception("XCIGamecardInfo Incorrect array size. Expected 112 bytes while received " + infoBytes.length);
        }
        IvParameterSpec gciIV = new IvParameterSpec(IV);
        SecretKeySpec skSpec = new SecretKeySpec(this.hexStrToByteArray(XCI_HEADER_KEY), "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)skSpec, gciIV);
            byte[] decrypted = cipher.doFinal(infoBytes);
            this.fwVersion = Converter.getLElong(decrypted, 0);
            this.accessCtrlFlags = Arrays.copyOfRange(decrypted, 8, 12);
            this.readWaitTime1 = Converter.getLEint(decrypted, 12);
            this.readWaitTime2 = Converter.getLEint(decrypted, 16);
            this.writeWaitTime1 = Converter.getLEint(decrypted, 20);
            this.writeWaitTime2 = Converter.getLEint(decrypted, 24);
            this.fwMode = Arrays.copyOfRange(decrypted, 28, 32);
            this.cupVersion = Arrays.copyOfRange(decrypted, 32, 36);
            this.emptyPadding1 = Arrays.copyOfRange(decrypted, 36, 40);
            this.updPartHash = Arrays.copyOfRange(decrypted, 40, 48);
            this.cupID = Arrays.copyOfRange(decrypted, 48, 56);
            this.emptyPadding2 = Arrays.copyOfRange(decrypted, 56, 112);
        }
        catch (Exception e) {
            throw new Exception("XCIGamecardInfo Decryption failed: \n  " + e.getMessage());
        }
    }

    private byte[] hexStrToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public long getFwVersion() {
        return this.fwVersion;
    }

    public byte[] getAccessCtrlFlags() {
        return this.accessCtrlFlags;
    }

    public int getReadWaitTime1() {
        return this.readWaitTime1;
    }

    public int getReadWaitTime2() {
        return this.readWaitTime2;
    }

    public int getWriteWaitTime1() {
        return this.writeWaitTime1;
    }

    public int getWriteWaitTime2() {
        return this.writeWaitTime2;
    }

    public byte[] getFwMode() {
        return this.fwMode;
    }

    public byte[] getCupVersion() {
        return this.cupVersion;
    }

    public boolean isEmptyPadding1() {
        return Arrays.equals(this.emptyPadding1, new byte[4]);
    }

    public byte[] getEmptyPadding1() {
        return this.emptyPadding1;
    }

    public byte[] getUpdPartHash() {
        return this.updPartHash;
    }

    public byte[] getCupID() {
        return this.cupID;
    }

    public boolean isEmptyPadding2() {
        return Arrays.equals(this.emptyPadding2, new byte[56]);
    }

    public byte[] getEmptyPadding2() {
        return this.emptyPadding2;
    }
}

