/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.es;

import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.fs.NCA.NCAProvider;
import libKonogonka.fs.NSO.NSO0Header;
import libKonogonka.fs.NSO.NSO0Provider;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.es.finders.HeuristicEsWizard;

public class EsPatch {
    private static final byte[] HEADER = "PATCH".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FOOTER = "EOF".getBytes(StandardCharsets.US_ASCII);
    private final NCAProvider ncaProvider;
    private final String saveToLocation;
    private final ILogPrinter logPrinter;
    private Long fwVersion;
    private String buildId;
    private byte[] _textSection;
    private HeuristicEsWizard wizard;

    EsPatch(NCAProvider ncaProvider, String saveToLocation, ILogPrinter logPrinter) throws Exception {
        this.ncaProvider = ncaProvider;
        this.saveToLocation = saveToLocation + File.separator + "atmosphere" + File.separator + "exefs_patches" + File.separator + "es_patches";
        this.logPrinter = logPrinter;
        this.getPlainFirmwareVersion();
        NSO0Provider nso0Provider = new NSO0Provider(ncaProvider.getNCAContentProvider(0).getPfs0().getStreamProducer(0));
        this.getBuildId(nso0Provider);
        this.getTextSection(nso0Provider);
        this.findAllOffsets();
        this.mkDirs();
        this.writeFile();
        logPrinter.print("                  == Debug information ==\n" + this.wizard.getDebug(), EMsgType.NULL);
    }

    private void getPlainFirmwareVersion() throws Exception {
        byte[] byteSdkVersion = this.ncaProvider.getSdkVersion();
        this.fwVersion = Long.parseLong("" + byteSdkVersion[3] + byteSdkVersion[2] + byteSdkVersion[1] + byteSdkVersion[0]);
        this.logPrinter.print("Internal firmware version: " + byteSdkVersion[3] + "." + byteSdkVersion[2] + "." + byteSdkVersion[1] + "." + byteSdkVersion[0], EMsgType.INFO);
        if (byteSdkVersion[3] < 9 || this.fwVersion < 9300L) {
            this.logPrinter.print("WARNING! FIRMWARES VERSIONS BEFORE 9.0.0 ARE NOT SUPPORTED! USING PRODUCED ES PATCHES (IF ANY) COULD BREAK SOMETHING! IT'S NEVER BEEN TESTED!", EMsgType.WARNING);
        }
    }

    private void getBuildId(NSO0Provider nso0Provider) throws Exception {
        NSO0Header nso0DecompressedHeader = nso0Provider.getAsDecompressedNSO0().getHeader();
        byte[] buildIdBytes = nso0DecompressedHeader.getModuleId();
        this.buildId = Converter.byteArrToHexStringAsLE(buildIdBytes).substring(0, 40).toUpperCase();
        this.logPrinter.print("Build ID: " + this.buildId, EMsgType.INFO);
    }

    private void getTextSection(NSO0Provider nso0Provider) throws Exception {
        this._textSection = nso0Provider.getAsDecompressedNSO0().getTextRaw();
    }

    private void findAllOffsets() throws Exception {
        this.wizard = new HeuristicEsWizard(this.fwVersion, this._textSection);
        String errorsAndNotes = this.wizard.getErrorsAndNotes();
        if (errorsAndNotes.length() > 0) {
            this.logPrinter.print(errorsAndNotes, EMsgType.WARNING);
        }
    }

    private void mkDirs() {
        File parentFolder = new File(this.saveToLocation);
        parentFolder.mkdirs();
    }

    private void writeFile() throws Exception {
        String patchFileLocation = this.saveToLocation + File.separator + this.buildId + ".ips";
        int offset1 = this.wizard.getOffset1();
        int offset2 = this.wizard.getOffset2();
        int offset3 = this.wizard.getOffset3();
        ByteBuffer handyEsPatch = ByteBuffer.allocate(35).order(ByteOrder.LITTLE_ENDIAN);
        handyEsPatch.put(HEADER);
        if (offset1 > 0) {
            this.logPrinter.print("Patch component 1 will be used", EMsgType.PASS);
            handyEsPatch.put(this.getPatch1(offset1));
        }
        if (offset2 > 0) {
            this.logPrinter.print("Patch component 2 will be used", EMsgType.PASS);
            handyEsPatch.put(this.getPatch2(offset2));
        }
        if (offset3 > 0) {
            this.logPrinter.print("Patch component 3 will be used", EMsgType.PASS);
            handyEsPatch.put(this.getPatch3(offset3));
        }
        handyEsPatch.put(FOOTER);
        byte[] esPatch = new byte[handyEsPatch.position()];
        ((Buffer)handyEsPatch).rewind();
        handyEsPatch.get(esPatch);
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(Paths.get(patchFileLocation, new String[0]), new OpenOption[0]));){
            stream.write(esPatch);
        }
        this.logPrinter.print("Patch created at " + patchFileLocation, EMsgType.PASS);
    }

    private byte[] getPatch1(int offset) throws Exception {
        int requiredInstructionOffsetInternal = offset - 4;
        int requiredInstructionOffsetReal = requiredInstructionOffsetInternal + 256;
        int instructionExpression = Converter.getLEint(this._textSection, requiredInstructionOffsetInternal);
        int patch = 0x14000000 | instructionExpression >> 5 & 0x7FFFF;
        this.logPrinter.print(BinToAsmPrinter.printSimplified(patch, requiredInstructionOffsetInternal), EMsgType.NULL);
        ByteBuffer prePatch = ByteBuffer.allocate(10).order(ByteOrder.BIG_ENDIAN).putInt(requiredInstructionOffsetReal).putShort((short)4).putInt(Integer.reverseBytes(patch));
        return Arrays.copyOfRange(prePatch.array(), 1, 10);
    }

    private byte[] getPatch2(int offset) throws Exception {
        int NopInstruction = 522191829;
        int offsetReal = offset - 4 + 256;
        this.logPrinter.print(BinToAsmPrinter.printSimplified(Integer.reverseBytes(522191829), offset - 4), EMsgType.NULL);
        ByteBuffer prePatch = ByteBuffer.allocate(10).order(ByteOrder.BIG_ENDIAN).putInt(offsetReal).putShort((short)4).putInt(522191829);
        return Arrays.copyOfRange(prePatch.array(), 1, 10);
    }

    private byte[] getPatch3(int offset) throws Exception {
        int requiredInstructionOffsetInternal = offset - 4;
        int requiredInstructionOffsetReal = requiredInstructionOffsetInternal + 256;
        int instructionExpression = Converter.getLEint(this._textSection, requiredInstructionOffsetInternal);
        int patch = 0x14000000 | instructionExpression >> 5 & 0x7FFFF;
        this.logPrinter.print(BinToAsmPrinter.printSimplified(patch, requiredInstructionOffsetInternal), EMsgType.NULL);
        ByteBuffer prePatch = ByteBuffer.allocate(10).order(ByteOrder.BIG_ENDIAN).putInt(requiredInstructionOffsetReal).putShort((short)4).putInt(Integer.reverseBytes(patch));
        return Arrays.copyOfRange(prePatch.array(), 1, 10);
    }
}

