/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.splitmerge;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.splitmerge.MultithreadingPrintAdapter;

public class MergeSubTask
implements Callable<Boolean> {
    private final int id;
    private final String saveToPath;
    private final MultithreadingPrintAdapter printAdapter;
    private final File splitFile;
    private File[] chunkFiles;
    private long chunksTotalSize;
    private File resultFile;

    public MergeSubTask(int id, File splitFile, String saveToPath, MultithreadingPrintAdapter printAdapter) {
        this.id = id;
        this.splitFile = splitFile;
        this.saveToPath = saveToPath;
        this.printAdapter = printAdapter;
    }

    @Override
    public Boolean call() {
        try {
            this.collectChunks();
            this.validateChunks();
            this.sortChunks();
            this.calculateChunksSizeSum();
            this.createFile();
            this.mergeChunksToFile();
            this.validateFile();
            return true;
        }
        catch (InterruptedException ie) {
            this.cleanup();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.printAdapter.print("[" + this.id + "] " + e.getMessage(), EMsgType.FAIL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    private void collectChunks() {
        this.chunkFiles = this.splitFile.listFiles((file, s) -> s.matches("^[0-9][0-9]$"));
    }

    private void validateChunks() throws Exception {
        if (this.chunkFiles == null || this.chunkFiles.length == 0) {
            throw new Exception("Selected folder doesn't have any chunks. Nothing to do here.");
        }
    }

    private void sortChunks() {
        Arrays.sort(this.chunkFiles);
    }

    private void calculateChunksSizeSum() throws InterruptedException {
        StringBuilder builder = new StringBuilder("[" + this.id + "] Next files will be merged in following order: ");
        for (File cnk : this.chunkFiles) {
            builder.append(cnk.getName());
            builder.append(" ");
            this.chunksTotalSize += cnk.length();
        }
        this.printAdapter.print(builder.toString(), EMsgType.INFO);
    }

    private void createFile() throws Exception {
        String splitFileName = this.splitFile.getName();
        this.resultFile = new File(this.saveToPath + File.separator + "!_" + splitFileName);
        for (int i = 0; i < 50; ++i) {
            if (this.interrupted()) {
                throw new InterruptedException();
            }
            if (!this.resultFile.exists()) {
                this.printAdapter.print("[" + this.id + "] Save results to: " + this.resultFile.getAbsolutePath(), EMsgType.INFO);
                return;
            }
            this.printAdapter.print("[" + this.id + "] Trying to create a good new file...", EMsgType.WARNING);
            this.resultFile = new File(this.saveToPath + File.separator + "!_" + i + "_" + splitFileName);
        }
        throw new Exception("Can't create new file.");
    }

    private void mergeChunksToFile() throws Exception {
        if (this.interrupted()) {
            throw new InterruptedException();
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.resultFile));){
            this.printAdapter.reportFileSize(this.chunksTotalSize);
            for (File chunkFile : this.chunkFiles) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(chunkFile));
                while (true) {
                    byte[] chunk;
                    int readBytesCnt;
                    if ((readBytesCnt = bis.read(chunk = new byte[4194240])) < 4194240) {
                        if (readBytesCnt <= 0) break;
                        bos.write(chunk, 0, readBytesCnt);
                        break;
                    }
                    if (this.interrupted()) {
                        throw new InterruptedException();
                    }
                    bos.write(chunk);
                    this.printAdapter.updateProgressBySize(readBytesCnt);
                }
                bis.close();
            }
        }
    }

    private void validateFile() throws Exception {
        if (this.interrupted()) {
            throw new Exception("Merge task interrupted!");
        }
        long resultFileSize = this.resultFile.length();
        this.printAdapter.print("[" + this.id + "] Total chunks size: " + this.chunksTotalSize + "\n         Merged file size:  " + resultFileSize, EMsgType.INFO);
        if (this.chunksTotalSize != resultFileSize) {
            throw new Exception("Sizes are different! Do NOT use this file for installations!");
        }
        this.printAdapter.print("[" + this.id + "] Sizes are the same! Resulting file should be good!", EMsgType.PASS);
    }

    private void cleanup() {
        boolean isDeleted = this.resultFile.delete();
        try {
            this.printAdapter.print("[" + this.id + "] Merge task interrupted and file " + (isDeleted ? "deleted." : "is NOT deleted."), EMsgType.FAIL);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean interrupted() {
        return Thread.interrupted();
    }
}

