/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.IDisconnectable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.SkinBase;

public class ListenerHelper
implements IDisconnectable {
    private WeakReference<Object> ownerRef;
    private final ArrayList<IDisconnectable> items = new ArrayList(4);
    private static Function<SkinBase<?>, ListenerHelper> accessor;

    public ListenerHelper(Object object) {
        this.ownerRef = new WeakReference<Object>(object);
    }

    public ListenerHelper() {
    }

    public static void setAccessor(Function<SkinBase<?>, ListenerHelper> function) {
        accessor = function;
    }

    public static ListenerHelper get(SkinBase<?> skinBase) {
        return accessor.apply(skinBase);
    }

    public IDisconnectable addDisconnectable(final Runnable runnable) {
        IDisconnectable iDisconnectable = new IDisconnectable(){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                this.this$0.items.remove(this);
                runnable.run();
            }
        };
        this.items.add(iDisconnectable);
        return iDisconnectable;
    }

    @Override
    public void disconnect() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            IDisconnectable iDisconnectable = this.items.remove(i);
            iDisconnectable.disconnect();
        }
    }

    private boolean isAliveOrDisconnect() {
        if (this.ownerRef != null && this.ownerRef.get() == null) {
            this.disconnect();
            return false;
        }
        return true;
    }

    public IDisconnectable addChangeListener(Runnable runnable, ObservableValue<?> ... observableValueArray) {
        return this.addChangeListener(runnable, false, observableValueArray);
    }

    public IDisconnectable addChangeListener(final Runnable runnable, boolean bl, final ObservableValue<?> ... observableValueArray) {
        if (runnable == null) {
            throw new NullPointerException("onChange must not be null.");
        }
        ChLi chLi = new ChLi(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                for (ObservableValue observableValue : observableValueArray) {
                    observableValue.removeListener(this);
                }
                this.this$0.items.remove(this);
            }

            @Override
            public void changed(ObservableValue observableValue, Object object, Object object2) {
                if (this.this$0.isAliveOrDisconnect()) {
                    runnable.run();
                }
            }
        };
        this.items.add(chLi);
        for (ObservableValue<?> observableValue : observableValueArray) {
            observableValue.addListener(chLi);
        }
        if (bl) {
            runnable.run();
        }
        return chLi;
    }

    public <T> IDisconnectable addChangeListener(ObservableValue<T> observableValue, ChangeListener<T> changeListener) {
        return this.addChangeListener(observableValue, false, changeListener);
    }

    public <T> IDisconnectable addChangeListener(final ObservableValue<T> observableValue, boolean bl, final ChangeListener<T> changeListener) {
        if (changeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        ChLi chLi = new ChLi<T>(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                observableValue.removeListener(this);
                this.this$0.items.remove(this);
            }

            @Override
            public void changed(ObservableValue<? extends T> observableValue2, T t, T t2) {
                if (this.this$0.isAliveOrDisconnect()) {
                    changeListener.changed(observableValue2, t, t2);
                }
            }
        };
        this.items.add(chLi);
        observableValue.addListener(chLi);
        if (bl) {
            T t = observableValue.getValue();
            changeListener.changed(observableValue, null, t);
        }
        return chLi;
    }

    public <T> IDisconnectable addChangeListener(ObservableValue<T> observableValue, Consumer<T> consumer) {
        return this.addChangeListener(observableValue, false, consumer);
    }

    public <T> IDisconnectable addChangeListener(final ObservableValue<T> observableValue, boolean bl, final Consumer<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("Callback must be specified.");
        }
        ChLi chLi = new ChLi<T>(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                observableValue.removeListener(this);
                this.this$0.items.remove(this);
            }

            @Override
            public void changed(ObservableValue<? extends T> observableValue2, T t, T t2) {
                if (this.this$0.isAliveOrDisconnect()) {
                    consumer.accept(t2);
                }
            }
        };
        this.items.add(chLi);
        observableValue.addListener(chLi);
        if (bl) {
            T t = observableValue.getValue();
            consumer.accept(t);
        }
        return chLi;
    }

    public IDisconnectable addInvalidationListener(Runnable runnable, ObservableValue<?> ... observableValueArray) {
        return this.addInvalidationListener(runnable, false, observableValueArray);
    }

    public IDisconnectable addInvalidationListener(final Runnable runnable, boolean bl, final ObservableValue<?> ... observableValueArray) {
        if (runnable == null) {
            throw new NullPointerException("Callback must be specified.");
        }
        InLi inLi = new InLi(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                for (ObservableValue observableValue : observableValueArray) {
                    observableValue.removeListener(this);
                }
                this.this$0.items.remove(this);
            }

            @Override
            public void invalidated(Observable observable) {
                if (this.this$0.isAliveOrDisconnect()) {
                    runnable.run();
                }
            }
        };
        this.items.add(inLi);
        for (ObservableValue<?> observableValue : observableValueArray) {
            observableValue.addListener(inLi);
        }
        if (bl) {
            runnable.run();
        }
        return inLi;
    }

    public <T> IDisconnectable addInvalidationListener(ObservableValue<T> observableValue, InvalidationListener invalidationListener) {
        return this.addInvalidationListener(observableValue, false, invalidationListener);
    }

    public <T> IDisconnectable addInvalidationListener(final ObservableValue<T> observableValue, boolean bl, final InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        InLi inLi = new InLi(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                observableValue.removeListener(this);
                this.this$0.items.remove(this);
            }

            @Override
            public void invalidated(Observable observable) {
                if (this.this$0.isAliveOrDisconnect()) {
                    invalidationListener.invalidated(observable);
                }
            }
        };
        this.items.add(inLi);
        observableValue.addListener(inLi);
        if (bl) {
            invalidationListener.invalidated(observableValue);
        }
        return inLi;
    }

    public <T> IDisconnectable addListChangeListener(final ObservableList<T> observableList, final ListChangeListener<T> listChangeListener) {
        if (listChangeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        LiChLi liChLi = new LiChLi<T>(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                observableList.removeListener(this);
                this.this$0.items.remove(this);
            }

            @Override
            public void onChanged(ListChangeListener.Change<? extends T> change) {
                if (this.this$0.isAliveOrDisconnect()) {
                    listChangeListener.onChanged(change);
                }
            }
        };
        this.items.add(liChLi);
        observableList.addListener(liChLi);
        return liChLi;
    }

    public <K, V> IDisconnectable addMapChangeListener(final ObservableMap<K, V> observableMap, final MapChangeListener<K, V> mapChangeListener) {
        if (mapChangeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        MaChLi maChLi = new MaChLi<K, V>(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                observableMap.removeListener(this);
                this.this$0.items.remove(this);
            }

            @Override
            public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
                if (this.this$0.isAliveOrDisconnect()) {
                    mapChangeListener.onChanged(change);
                }
            }
        };
        this.items.add(maChLi);
        observableMap.addListener(maChLi);
        return maChLi;
    }

    public <T> IDisconnectable addSetChangeListener(final ObservableSet<T> observableSet, final SetChangeListener<T> setChangeListener) {
        if (setChangeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        SeChLi seChLi = new SeChLi<T>(this){
            final /* synthetic */ ListenerHelper this$0;
            {
                this.this$0 = listenerHelper;
            }

            @Override
            public void disconnect() {
                observableSet.removeListener(this);
                this.this$0.items.remove(this);
            }

            @Override
            public void onChanged(SetChangeListener.Change<? extends T> change) {
                if (this.this$0.isAliveOrDisconnect()) {
                    setChangeListener.onChanged(change);
                }
            }
        };
        this.items.add(seChLi);
        observableSet.addListener(seChLi);
        return seChLi;
    }

    public <T extends Event> IDisconnectable addEventHandler(final EventTarget eventTarget, final EventType<T> eventType, EventHandler<T> eventHandler) {
        EvHa evHa = new EvHa<T>(this, eventHandler){

            @Override
            public void disconnect() {
                eventTarget.removeEventHandler(eventType, this);
            }
        };
        this.items.add(evHa);
        eventTarget.addEventHandler(eventType, evHa);
        return evHa;
    }

    public <T extends Event> IDisconnectable addEventFilter(final EventTarget eventTarget, final EventType<T> eventType, EventHandler<T> eventHandler) {
        EvHa evHa = new EvHa<T>(this, eventHandler){

            @Override
            public void disconnect() {
                eventTarget.removeEventFilter(eventType, this);
            }
        };
        this.items.add(evHa);
        eventTarget.addEventFilter(eventType, evHa);
        return evHa;
    }

    private abstract class EvHa<T extends Event>
    implements IDisconnectable,
    EventHandler<T> {
        private final EventHandler<T> handler;

        public EvHa(EventHandler<T> eventHandler) {
            this.handler = eventHandler;
        }

        @Override
        public void handle(T t) {
            if (ListenerHelper.this.isAliveOrDisconnect()) {
                this.handler.handle(t);
            }
        }
    }

    private static abstract class SeChLi<T>
    implements IDisconnectable,
    SetChangeListener<T> {
        private SeChLi() {
        }
    }

    private static abstract class MaChLi<K, V>
    implements IDisconnectable,
    MapChangeListener<K, V> {
        private MaChLi() {
        }
    }

    private static abstract class LiChLi<T>
    implements IDisconnectable,
    ListChangeListener<T> {
        private LiChLi() {
        }
    }

    private static abstract class InLi
    implements IDisconnectable,
    InvalidationListener {
        private InLi() {
        }
    }

    private static abstract class ChLi<T>
    implements IDisconnectable,
    ChangeListener<T> {
        private ChLi() {
        }
    }
}

