/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.ModelControllers;

import java.io.File;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.MessagesConsumer;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;

public class LogPrinterGui
implements ILogPrinter {
    private final MessagesConsumer msgConsumer;
    private final BlockingQueue<String> msgQueue = new LinkedBlockingQueue<String>();
    private final BlockingQueue<Double> progressQueue = new LinkedBlockingQueue<Double>();
    private final HashMap<String, EFileStatus> statusMap = new HashMap();
    private final AtomicBoolean oneLinerStatus = new AtomicBoolean();

    LogPrinterGui(EModule whoIsAsking) {
        this.msgConsumer = new MessagesConsumer(whoIsAsking, this.msgQueue, this.progressQueue, this.statusMap, this.oneLinerStatus);
        this.msgConsumer.start();
    }

    @Override
    public void print(String message, EMsgType type) throws InterruptedException {
        switch (type) {
            case PASS: {
                this.msgQueue.put("[ PASS ] " + message + "\n");
                break;
            }
            case FAIL: {
                this.msgQueue.put("[ FAIL ] " + message + "\n");
                break;
            }
            case INFO: {
                this.msgQueue.put("[ INFO ] " + message + "\n");
                break;
            }
            case WARNING: {
                this.msgQueue.put("[ WARN ] " + message + "\n");
                break;
            }
            default: {
                this.msgQueue.put(message);
            }
        }
    }

    @Override
    public void updateProgress(Double value) throws InterruptedException {
        this.progressQueue.put(value);
    }

    @Override
    public void update(HashMap<String, File> nspMap, EFileStatus status) {
        for (File file : nspMap.values()) {
            this.statusMap.putIfAbsent(file.getName(), status);
        }
    }

    @Override
    public void update(File file, EFileStatus status) {
        this.statusMap.putIfAbsent(file.getName(), status);
    }

    @Override
    public void updateOneLinerStatus(boolean status) {
        this.oneLinerStatus.set(status);
    }

    @Override
    public void close() {
        this.msgConsumer.interrupt();
    }
}

