/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.UI;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.jar.JarFile;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import nsusbloader.AppPreferences;
import nsusbloader.UI.LocaleHolder;

public class SettingsLanguagesSetup {
    private final ObservableList<LocaleHolder> languages = FXCollections.observableArrayList();
    private File thisApplicationFile;
    private LocaleHolder recentlyUsedLanguageHolder;

    public SettingsLanguagesSetup() {
        this.parseFiles();
        this.sortLanguages();
        this.defineRecentlyUsedLanguageHolder();
    }

    private void parseFiles() {
        if (this.isApplicationIsJar()) {
            this.parseFilesInsideJar();
        } else {
            this.parseFilesInFilesystem();
        }
    }

    private boolean isApplicationIsJar() {
        String encodedJarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("+", "%2B");
        this.thisApplicationFile = new File(URLDecoder.decode(encodedJarLocation, StandardCharsets.UTF_8));
        return this.thisApplicationFile.isFile();
    }

    private void parseFilesInsideJar() {
        try (JarFile jar = new JarFile(this.thisApplicationFile);){
            jar.stream().filter(entry -> entry.getName().startsWith("locale_")).map(entry -> new LocaleHolder(entry.getName())).forEach(this.languages::add);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseFilesInFilesystem() {
        String pathToResource = Objects.requireNonNull(this.getClass().getResource("/")).getPath();
        try (DirectoryStream<Path> streamDirs = Files.newDirectoryStream(Path.of(pathToResource, new String[0]));){
            streamDirs.forEach(jarFileName -> {
                String fileName = String.valueOf(jarFileName.getFileName());
                if (fileName.startsWith("locale_")) {
                    this.languages.add(new LocaleHolder(fileName));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sortLanguages() {
        this.languages.sort(Comparator.comparing(LocaleHolder::toString));
    }

    private void defineRecentlyUsedLanguageHolder() {
        this.recentlyUsedLanguageHolder = this.languages.stream().filter(localeHolder -> localeHolder.getLocale().equals(AppPreferences.getInstance().getLocale())).findFirst().orElse(null);
        if (this.recentlyUsedLanguageHolder == null) {
            this.recentlyUsedLanguageHolder = this.languages.stream().filter(localeHolder -> localeHolder.getLocaleCode().equals("en_US")).findFirst().orElseThrow(() -> new RuntimeException("Unable to get default locale (en_US)"));
        }
    }

    public ObservableList<LocaleHolder> getLanguages() {
        return this.languages;
    }

    public LocaleHolder getRecentLanguage() {
        return this.recentlyUsedLanguageHolder;
    }
}

