/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.fs.finders;

import java.util.ArrayList;
import java.util.List;
import libKonogonka.Converter;
import nsusbloader.AppPreferences;
import nsusbloader.Utilities.patches.AHeuristic;
import nsusbloader.Utilities.patches.BinToAsmPrinter;
import nsusbloader.Utilities.patches.SimplyFind;

class HeuristicFs1
extends AHeuristic {
    private static final String PATTERN = AppPreferences.getInstance().getPatchPattern("FS", 1, 0);
    private final byte[] where;
    private final List<Integer> findings;

    HeuristicFs1(byte[] where) {
        this.where = where;
        this.findings = new ArrayList<Integer>();
        SimplyFind simplyfind = new SimplyFind(PATTERN, where);
        simplyfind.getResults().forEach(var -> this.findings.add(var + 4));
    }

    @Override
    public boolean isFound() {
        return this.findings.size() == 1;
    }

    @Override
    public boolean wantLessEntropy() {
        return this.findings.size() > 1;
    }

    @Override
    public int getOffset() throws Exception {
        if (this.findings.isEmpty()) {
            throw new Exception("Nothing found");
        }
        if (this.findings.size() > 1) {
            throw new Exception("Too many offsets");
        }
        return this.findings.get(0);
    }

    @Override
    public boolean setOffsetsNearby(int offsetNearby) {
        this.findings.removeIf(offset -> {
            if (offset > offsetNearby) {
                return offset >= offsetNearby - 65535;
            }
            return offset <= offsetNearby - 65535;
        });
        return this.isFound();
    }

    @Override
    public String getDetails() {
        int offsetInternal = this.findings.get(0) - 4;
        int firstExpression = Converter.getLEint(this.where, offsetInternal);
        int conditionalJumpLocation = offsetInternal + (firstExpression >> 5 & 0x3FFF) * 4;
        int secondExpressionsPairElement1 = Converter.getLEint(this.where, conditionalJumpLocation);
        int secondExpressionsPairElement2 = Converter.getLEint(this.where, conditionalJumpLocation + 4);
        return BinToAsmPrinter.printSimplified(firstExpression, offsetInternal) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, offsetInternal + 4), offsetInternal + 4) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, offsetInternal + 8), offsetInternal + 8) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, offsetInternal + 12), offsetInternal + 12) + BinToAsmPrinter.printSimplified(Converter.getLEint(this.where, offsetInternal + 16), offsetInternal + 16) + "...\n" + BinToAsmPrinter.printSimplified(secondExpressionsPairElement1, conditionalJumpLocation) + BinToAsmPrinter.printSimplified(secondExpressionsPairElement2, conditionalJumpLocation + 4);
    }
}

