/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.splitmerge;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.splitmerge.MultithreadingPrintAdapter;

public class SplitSubTask
implements Callable<Boolean> {
    private final int id;
    private final String saveToPath;
    private final File file;
    private File splitFile;
    private long originalFileLen;
    private final MultithreadingPrintAdapter printAdapter;

    SplitSubTask(int id, File file, String saveToPath, MultithreadingPrintAdapter printAdapter) {
        this.id = id;
        this.file = file;
        this.saveToPath = saveToPath;
        this.printAdapter = printAdapter;
    }

    @Override
    public Boolean call() {
        try {
            this.createSplitFile();
            this.splitFileToChunks();
            this.validateSplitFile();
            return true;
        }
        catch (InterruptedException | ExecutionException ie) {
            ie.printStackTrace();
            this.cleanup();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.printAdapter.print("[" + this.id + "] " + e.getMessage(), EMsgType.FAIL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    private void createSplitFile() throws Exception {
        if (this.interrupted()) {
            throw new Exception("Split task interrupted!");
        }
        this.splitFile = new File(this.saveToPath + File.separator + "!_" + this.file.getName());
        for (int i = 0; i < 50; ++i) {
            if (this.splitFile.mkdirs()) {
                this.printAdapter.print("[" + this.id + "] Save results to: " + this.splitFile.getAbsolutePath(), EMsgType.INFO);
                return;
            }
            if (!this.splitFile.exists()) {
                throw new Exception("Folder " + this.splitFile.getAbsolutePath() + " could not be created. Not enough rights or something like that?");
            }
            this.printAdapter.print("[" + this.id + "] Trying to create a good new folder...", EMsgType.WARNING);
            this.splitFile = new File(this.saveToPath + File.separator + "!_" + i + "_" + this.file.getName());
        }
        throw new Exception("Can't create new file.");
    }

    private void splitFileToChunks() throws Exception {
        block10: {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file));){
                this.originalFileLen = this.file.length();
                this.printAdapter.reportFileSize(this.originalFileLen);
                int i = 0;
                while (true) {
                    String pathname = this.splitFile.getAbsolutePath() + File.separator + String.format("%02d", i);
                    BufferedOutputStream fragmentBos = new BufferedOutputStream(new FileOutputStream(pathname));
                    for (long counter = 0L; counter < 1024L; ++counter) {
                        byte[] chunk = new byte[4194240];
                        int readBytesCnt = bis.read(chunk);
                        if (readBytesCnt < 4194240) {
                            if (readBytesCnt > 0) {
                                fragmentBos.write(chunk, 0, readBytesCnt);
                            }
                            fragmentBos.close();
                            this.printAdapter.updateProgressBySize(readBytesCnt);
                            break block10;
                        }
                        if (this.interrupted()) {
                            throw new InterruptedException();
                        }
                        fragmentBos.write(chunk);
                        this.printAdapter.updateProgressBySize(readBytesCnt);
                    }
                    fragmentBos.close();
                    ++i;
                }
            }
        }
    }

    private void validateSplitFile() throws Exception {
        if (this.interrupted()) {
            throw new Exception("Split task interrupted!");
        }
        this.printAdapter.print("[" + this.id + "] Original file: " + this.splitFile.getAbsolutePath() + " (size: " + this.originalFileLen + ")", EMsgType.INFO);
        long totalChunksSize = 0L;
        Object[] chunkFileArr = this.splitFile.listFiles();
        if (chunkFileArr == null) {
            throw new Exception("Unable to check results. It means that something went wrong.");
        }
        Arrays.sort(chunkFileArr);
        StringBuilder stringBuilder = new StringBuilder("[" + this.id + "] Chunks");
        for (Object chunkFile : chunkFileArr) {
            stringBuilder.append("\n");
            stringBuilder.append("         ");
            stringBuilder.append(((File)chunkFile).getName());
            stringBuilder.append(" size: ");
            stringBuilder.append(((File)chunkFile).length());
            totalChunksSize += ((File)chunkFile).length();
        }
        stringBuilder.append("\n");
        stringBuilder.append("Total chunks size: ");
        stringBuilder.append(totalChunksSize);
        this.printAdapter.print(stringBuilder.toString(), EMsgType.INFO);
        if (this.originalFileLen != totalChunksSize) {
            throw new Exception("Sizes are different! Do NOT use this file for installations!");
        }
        this.printAdapter.print("[" + this.id + "] Sizes are the same! Split file should be good!", EMsgType.PASS);
    }

    private void cleanup() {
        boolean isDeleted = this.splitFile.delete();
        File[] chunksToDelete = this.splitFile.listFiles();
        if (!isDeleted && chunksToDelete != null) {
            isDeleted = true;
            for (File chunkFile : chunksToDelete) {
                isDeleted &= chunkFile.delete();
            }
            isDeleted &= this.splitFile.delete();
        }
        try {
            this.printAdapter.print("[" + this.id + "] Split task interrupted and folder " + (isDeleted ? "deleted." : "is NOT deleted."), EMsgType.FAIL);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean interrupted() {
        return Thread.interrupted();
    }
}

