/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.helpers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NSSplitReader
extends InputStream {
    private final String splitFileDir;
    private final long referenceSplitChunkSize;
    private byte subFileNum;
    private long curPosition;
    private BufferedInputStream inStream;

    public NSSplitReader(File file, long seekToPosition) throws IOException, NullPointerException {
        this.splitFileDir = file.getAbsolutePath() + File.separator;
        File subFile = new File(file.getAbsolutePath() + File.separator + "00");
        if (!file.exists()) {
            throw new FileNotFoundException("File not found on " + file.getAbsolutePath() + File.separator + "00");
        }
        this.referenceSplitChunkSize = subFile.length();
        this.subFileNum = (byte)(seekToPosition / this.referenceSplitChunkSize);
        this.inStream = new BufferedInputStream(new FileInputStream(this.splitFileDir + String.format("%02d", this.subFileNum)));
        this.curPosition = seekToPosition;
        if ((seekToPosition -= this.referenceSplitChunkSize * (long)this.subFileNum) != this.inStream.skip(seekToPosition)) {
            throw new IOException("Unable to seek to requested position of " + seekToPosition + " for file " + this.splitFileDir + String.format("%02d", this.subFileNum));
        }
    }

    public long seek(long position) throws IOException {
        byte subFileRequested = (byte)(position / this.referenceSplitChunkSize);
        if (subFileRequested != this.subFileNum || this.curPosition > position) {
            this.inStream.close();
            this.inStream = new BufferedInputStream(new FileInputStream(this.splitFileDir + String.format("%02d", subFileRequested)));
            this.subFileNum = subFileRequested;
            this.curPosition = this.referenceSplitChunkSize * (long)subFileRequested;
        }
        long retVal = this.inStream.skip(position - this.curPosition);
        this.curPosition = position;
        return retVal + this.curPosition;
    }

    @Override
    public int read(byte[] readBuffer) throws IOException, NullPointerException {
        int requested = readBuffer.length;
        if (this.curPosition + (long)requested <= this.referenceSplitChunkSize * (long)(this.subFileNum + 1)) {
            int readPrtOne = this.inStream.read(readBuffer);
            if (readPrtOne < 0) {
                return readPrtOne;
            }
            this.curPosition += (long)readPrtOne;
            return readPrtOne;
        }
        int partOne = (int)(this.referenceSplitChunkSize * (long)(this.subFileNum + 1) - this.curPosition);
        int partTwo = requested - partOne;
        int readPrtOne = this.inStream.read(readBuffer, 0, partOne);
        if (readPrtOne < 0) {
            return readPrtOne;
        }
        this.curPosition += (long)readPrtOne;
        if (readPrtOne != partOne) {
            return readPrtOne;
        }
        this.inStream.close();
        this.subFileNum = (byte)(this.subFileNum + 1);
        this.inStream = new BufferedInputStream(new FileInputStream(this.splitFileDir + String.format("%02d", this.subFileNum)));
        int readPrtTwo = this.inStream.read(readBuffer, partOne, partTwo);
        if (readPrtTwo < 0) {
            return readPrtTwo;
        }
        this.curPosition += (long)readPrtTwo;
        return readPrtOne + readPrtTwo;
    }

    @Override
    public void close() throws IOException {
        if (this.inStream != null) {
            this.inStream.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Not supported, try using seek(...) instead");
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public int available() throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        throw new IOException("Not supported");
    }
}

