/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.scene.SceneHelper;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;

public class InputMethodStateManager {
    private final WeakReference<Scene> rootScene;
    private Scene currentEventScene;
    private final LinkedList<Scene> scenes = new LinkedList();
    private final ChangeListener<InputMethodRequests> inputMethodRequestsChangedListener = (observableValue, inputMethodRequests, inputMethodRequests2) -> this.updateInputMethodEventEnableState();
    private final ChangeListener<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedListener = (observableValue, eventHandler, eventHandler2) -> this.updateInputMethodEventEnableState();
    private final WeakChangeListener<InputMethodRequests> weakInputMethodRequestsChangedListener = new WeakChangeListener<InputMethodRequests>(this.inputMethodRequestsChangedListener);
    private final WeakChangeListener<EventHandler<? super InputMethodEvent>> weakOnInputMethodTextChangedListener = new WeakChangeListener<EventHandler<? super InputMethodEvent>>(this.onInputMethodTextChangedListener);

    public InputMethodStateManager(Scene scene) {
        this.rootScene = new WeakReference<Scene>(scene);
        this.scenes.add(scene);
        this.currentEventScene = scene;
    }

    public void addScene(Scene scene) {
        this.scenes.addFirst(scene);
        this.updateInputMethodEventEnableState();
    }

    public void removeScene(Scene scene) {
        SceneHelper.finishInputMethodComposition((Scene)this.rootScene.get());
        Node node = scene.getFocusOwner();
        if (node != null) {
            node.inputMethodRequestsProperty().removeListener(this.weakInputMethodRequestsChangedListener);
            node.onInputMethodTextChangedProperty().removeListener(this.weakOnInputMethodTextChangedListener);
        }
        this.scenes.remove(scene);
        this.updateInputMethodEventEnableState();
    }

    public void focusOwnerWillChangeForScene(Scene scene) {
        Scene scene2;
        if ((scene == this.currentEventScene || this.currentEventScene == null) && (scene2 = (Scene)this.rootScene.get()) != null) {
            SceneHelper.finishInputMethodComposition(scene2);
        }
    }

    public void focusOwnerChanged(Node node, Node node2) {
        if (node != null) {
            node.inputMethodRequestsProperty().removeListener(this.weakInputMethodRequestsChangedListener);
            node.onInputMethodTextChangedProperty().removeListener(this.weakOnInputMethodTextChangedListener);
        }
        if (node2 != null) {
            node2.inputMethodRequestsProperty().addListener(this.weakInputMethodRequestsChangedListener);
            node2.onInputMethodTextChangedProperty().addListener(this.weakOnInputMethodTextChangedListener);
        }
        this.updateInputMethodEventEnableState();
    }

    public Scene getRootScene() {
        return (Scene)this.rootScene.get();
    }

    private void updateInputMethodEventEnableState() {
        this.currentEventScene = null;
        Object object = this.scenes.iterator();
        while (object.hasNext()) {
            Scene scene = (Scene)object.next();
            Node node = scene.getFocusOwner();
            if (node == null || node.getInputMethodRequests() == null || node.getOnInputMethodTextChanged() == null) continue;
            this.currentEventScene = scene;
            break;
        }
        if ((object = (Scene)this.rootScene.get()) != null) {
            SceneHelper.enableInputMethodEvents((Scene)object, this.currentEventScene != null);
        }
    }

    public InputMethodRequests getInputMethodRequests() {
        Node node;
        if (this.currentEventScene != null && (node = this.currentEventScene.getFocusOwner()) != null) {
            return node.getInputMethodRequests();
        }
        return null;
    }
}

