/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Converter {
    private static final Logger log = LogManager.getLogger(Converter.class);

    public static int getLEint(byte[] bytes, int fromOffset) {
        if (fromOffset < 0 || fromOffset >= bytes.length) {
            log.debug("\tLen =" + bytes.length + "\tFrom =" + fromOffset);
        }
        return ByteBuffer.wrap(bytes, fromOffset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long getLElong(byte[] bytes, int fromOffset) {
        return ByteBuffer.wrap(bytes, fromOffset, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static long getLElongOfInt(byte[] bytes, int fromOffset) {
        byte[] holder = new byte[8];
        System.arraycopy(bytes, fromOffset, holder, 0, 4);
        return ByteBuffer.wrap(holder).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String byteArrToHexStringAsLE(byte[] array) {
        return Converter.byteArrToHexStringAsLE(array, false);
    }

    public static String byteArrToHexStringAsLE(byte[] array, boolean upperCase) {
        if (upperCase) {
            return Converter.byteArrToHexStringAsLE(array, "%02X");
        }
        return Converter.byteArrToHexStringAsLE(array, "%02x");
    }

    private static String byteArrToHexStringAsLE(byte[] array, String format) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : array) {
            sb.append(String.format(format, b));
        }
        return sb.toString();
    }

    public static String intToBinaryString(int value) {
        return String.format("%32s", Integer.toBinaryString(value)).replace(' ', '0');
    }

    public static String byteToBinaryString(byte value) {
        String str = String.format("%8s", Integer.toBinaryString(value)).replace(' ', '0');
        int decrease = 0;
        if (str.length() > 8) {
            decrease = str.length() - 8;
        }
        return str.substring(decrease);
    }

    public static String shortToBinaryString(short value) {
        String str = String.format("%16s", Integer.toBinaryString(value)).replace(' ', '0');
        int decrease = 0;
        if (str.length() > 16) {
            decrease = str.length() - 16;
        }
        return str.substring(decrease);
    }

    public static String longToOctString(long value) {
        return String.format("%64s", Long.toBinaryString(value)).replace(' ', '0');
    }

    public static byte[] hexStringToByteArray(String string) {
        int len = string.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] flip(byte[] bytes) {
        int size = bytes.length;
        byte[] ret = new byte[size];
        for (int i = 0; i < size; ++i) {
            ret[size - i - 1] = bytes[i];
        }
        return ret;
    }
}

