/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.gl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import nsusbloader.MediatorControl;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.DataConvertUtils;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.usb.TransferModule;
import nsusbloader.com.usb.gl.GlString;
import nsusbloader.com.usb.gl.GlString010;
import nsusbloader.com.usb.gl.GoldleafCmd;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class GoldLeaf_010
extends TransferModule {
    private static final int PACKET_SIZE = 4096;
    public static final byte[] EXCEPTION_CAUGHT = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, -15, -70}, 4096);
    public static final byte[] INVALID_INDEX = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, -14, -70}, 4096);
    public static final byte[] SELECTION_CANCELLED = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, -12, -70}, 4096);
    private static final byte[] CMD_GLCO_SUCCESS_FLAG = new byte[]{71, 76, 67, 79, 0, 0, 0, 0};
    private static final byte[] CMD_GLCO_SUCCESS = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, 0, 0}, 4096);
    private final byte[] GL_OBJECT_TYPE_FILE = new byte[]{1, 0, 0, 0};
    private final byte[] GL_OBJECT_TYPE_DIR = new byte[]{2, 0, 0, 0};
    private final boolean nspFilter;
    private String recentPath;
    private String[] recentDirs;
    private String[] recentFiles;
    private final String[] nspMapKeySetIndexes;
    protected String openReadFileNameAndPath;
    protected RandomAccessFile randAccessFile;
    protected NSSplitReader splitReader;
    private final HashMap<String, BufferedOutputStream> writeFilesMap = new HashMap();
    protected long virtDriveSize;
    private final HashMap<String, Long> splitFileSize = new HashMap();
    private final boolean isWindows = System.getProperty("os.name").contains("Windows");
    protected final String homePath = System.getProperty("user.home");
    protected File selectedFile;

    public GoldLeaf_010(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter, boolean nspFilter) {
        super(handler, nspMap, task, logPrinter);
        this.nspFilter = nspFilter;
        this.printWelcomeMessage();
        this.nspMapKeySetIndexes = nspMap.keySet().toArray(new String[0]);
        nspMap.values().forEach(nspFile -> {
            if (nspFile.isDirectory()) {
                File[] subFiles = nspFile.listFiles((file, name) -> name.matches("[0-9]{2}"));
                assert (subFiles != null);
                long size = 0L;
                for (File subFile : subFiles) {
                    size += subFile.length();
                }
                this.virtDriveSize += size;
                this.splitFileSize.put(nspFile.getName(), size);
            } else {
                this.virtDriveSize += nspFile.length();
            }
        });
        if (this.workLoop()) {
            return;
        }
        this.writeFilesMap.values().forEach(stream -> {
            try {
                stream.close();
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
        });
        this.closeOpenedReadFilesGl();
    }

    protected void printWelcomeMessage() {
        this.print("=========== GoldLeaf v0.10+ ===========\n\tVIRT:/ equals files added into the application\n\tHOME:/ equals " + this.homePath, EMsgType.INFO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean workLoop() {
        try {
            block21: while (true) {
                byte[] readByte;
                if (this.notGLCI(readByte = this.readUsb())) {
                    continue;
                }
                switch (GoldleafCmd.get(readByte[4])) {
                    case GetDriveCount: {
                        this.getDriveCount();
                        continue block21;
                    }
                    case GetDriveInfo: {
                        this.getDriveInfo(DataConvertUtils.arrToIntLE(readByte, 8));
                        continue block21;
                    }
                    case GetSpecialPathCount: {
                        this.getSpecialPathCount();
                        continue block21;
                    }
                    case GetSpecialPath: {
                        this.getSpecialPath(DataConvertUtils.arrToIntLE(readByte, 8));
                        continue block21;
                    }
                    case GetDirectoryCount: {
                        this.getDirectoryOrFileCount(this.readString(readByte, 8).toString(), true);
                        continue block21;
                    }
                    case GetFileCount: {
                        this.getDirectoryOrFileCount(this.readString(readByte, 8).toString(), false);
                        continue block21;
                    }
                    case GetDirectory: {
                        GlString glString1 = this.readString(readByte, 8);
                        this.getDirectory(glString1.toString(), DataConvertUtils.arrToIntLE(readByte, glString1.length() + 12));
                        continue block21;
                    }
                    case GetFile: {
                        GlString glString1 = this.readString(readByte, 8);
                        this.getFile(glString1.toString(), DataConvertUtils.arrToIntLE(readByte, glString1.length() + 12));
                        continue block21;
                    }
                    case StatPath: {
                        this.statPath(this.readString(readByte, 8).toString());
                        continue block21;
                    }
                    case Rename: {
                        GlString glString1 = this.readString(readByte, 8);
                        GlString glString2 = this.readString(readByte, 12 + glString1.length());
                        this.rename(glString1.toString(), glString2.toString());
                        continue block21;
                    }
                    case Delete: {
                        this.delete(this.readString(readByte, 8).toString());
                        continue block21;
                    }
                    case Create: {
                        this.create(this.readString(readByte, 8).toString(), readByte[8]);
                        continue block21;
                    }
                    case ReadFile: {
                        GlString glString1 = this.readString(readByte, 8);
                        this.readFile(glString1.toString(), DataConvertUtils.arrToLongLE(readByte, 12 + glString1.length()), DataConvertUtils.arrToLongLE(readByte, 12 + glString1.length() + 8));
                        continue block21;
                    }
                    case WriteFile: {
                        this.writeFile(this.readString(readByte, 8).toString());
                        continue block21;
                    }
                    case SelectFile: {
                        this.selectFile();
                        continue block21;
                    }
                    case StartFile: 
                    case EndFile: {
                        this.startOrEndFile();
                        continue block21;
                    }
                }
                this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Unknown command: " + readByte[4] + " [it's a very bad sign]");
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return true;
        }
        catch (Exception e) {
            this.print(e.getMessage(), EMsgType.FAIL);
            e.printStackTrace();
            return false;
        }
    }

    protected GlString readString(byte[] readByte, int startPosition) {
        return new GlString010(readByte, startPosition);
    }

    protected boolean notGLCI(byte[] inputBytes) {
        return !"GLCI".equals(new String(inputBytes, 0, 4, StandardCharsets.US_ASCII));
    }

    protected void startOrEndFile() throws Exception {
        this.writeGL_PASS("GL Handle 'StartFile' command");
    }

    protected void getDriveCount() throws Exception {
        this.writeGL_PASS(DataConvertUtils.intToArrLE(2), "GL Handle 'ListDrives' command");
    }

    protected void getDriveInfo(int driveNo) throws Exception {
        long totalSizeLong;
        byte[] totalFreeSpace;
        byte[] driveLetterLen;
        byte[] driveLetter;
        byte[] driveLabelLen;
        byte[] driveLabel;
        if (driveNo < 0 || driveNo > 1) {
            this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDriveInfo' command [no such drive]");
            return;
        }
        if (driveNo == 0) {
            driveLabel = "Virtual".getBytes(StandardCharsets.UTF_8);
            driveLabelLen = DataConvertUtils.intToArrLE(driveLabel.length);
            driveLetter = "VIRT".getBytes(StandardCharsets.UTF_8);
            driveLetterLen = DataConvertUtils.intToArrLE(driveLetter.length);
            totalFreeSpace = new byte[4];
            totalSizeLong = this.virtDriveSize;
        } else {
            driveLabel = "Home".getBytes(StandardCharsets.UTF_8);
            driveLabelLen = DataConvertUtils.intToArrLE(driveLabel.length);
            driveLetter = "HOME".getBytes(StandardCharsets.UTF_8);
            driveLetterLen = DataConvertUtils.intToArrLE(driveLetter.length);
            File userHomeDir = new File(System.getProperty("user.home"));
            totalFreeSpace = Arrays.copyOfRange(DataConvertUtils.longToArrLE(userHomeDir.getFreeSpace()), 0, 4);
            totalSizeLong = userHomeDir.getTotalSpace();
        }
        byte[] totalSize = Arrays.copyOfRange(DataConvertUtils.longToArrLE(totalSizeLong), 0, 4);
        List<byte[]> command = Arrays.asList(driveLabelLen, driveLabel, driveLetterLen, driveLetter, totalFreeSpace, totalSize);
        this.writeGL_PASS(command, "GL Handle 'GetDriveInfo' command");
    }

    protected void getSpecialPathCount() throws Exception {
        this.writeGL_PASS(DataConvertUtils.intToArrLE(0), "GL Handle 'SpecialPathCount' command");
    }

    protected void getSpecialPath(int specialPathNo) throws Exception {
        this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'SpecialPath' command [not supported]");
    }

    protected void getDirectoryOrFileCount(String glFileName, boolean isGetDirectoryCount) throws Exception {
        if (glFileName.equals("VIRT:/")) {
            if (isGetDirectoryCount) {
                this.writeGL_PASS("GL Handle 'GetDirectoryCount' command");
            } else {
                this.writeGL_PASS(DataConvertUtils.intToArrLE(this.nspMap.size()), "GL Handle 'GetFileCount' command Count = " + this.nspMap.size());
            }
            return;
        }
        if (glFileName.startsWith("HOME:/")) {
            String[] filesOrDirs;
            String path = this.decodeGlPath(glFileName);
            File pathDir = new File(path);
            if (this.notExistsOrDirectory(pathDir)) {
                this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'GetDirectoryOrFileCount' command [doesn't exist or not a folder] " + String.valueOf(pathDir));
                return;
            }
            this.recentPath = path;
            String[] stringArray = filesOrDirs = isGetDirectoryCount ? pathDir.list(this::isDirectoryAndNotHidden) : pathDir.list(this::isFileAndNotHidden);
            if (filesOrDirs == null) {
                this.writeGL_PASS("GL Handle 'GetDirectoryOrFileCount' command");
                return;
            }
            Arrays.sort(filesOrDirs, String.CASE_INSENSITIVE_ORDER);
            if (isGetDirectoryCount) {
                this.recentDirs = filesOrDirs;
            } else {
                this.recentFiles = filesOrDirs;
            }
            this.writeGL_PASS(DataConvertUtils.intToArrLE(filesOrDirs.length), "GL Handle 'GetDirectoryOrFileCount' command");
            return;
        }
        if (glFileName.startsWith("SPEC:/")) {
            if (isGetDirectoryCount) {
                this.writeGL_PASS("GL Handle 'GetDirectoryCount' command");
                return;
            }
            if (this.selectedFile != null) {
                this.writeGL_PASS(DataConvertUtils.intToArrLE(1), "GL Handle 'GetFileCount' command Count = 1");
                return;
            }
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'GetDirectoryOrFileCount' command [unknown drive request] (file) - " + glFileName);
            return;
        }
        this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'GetDirectoryOrFileCount' command [unknown drive request] " + (isGetDirectoryCount ? "(dir) - " : "(file) - ") + glFileName);
    }

    protected void getDirectory(String dirName, int subDirNo) throws Exception {
        if (dirName.startsWith("HOME:/")) {
            dirName = this.decodeGlPath(dirName);
            ArrayList<byte[]> command = new ArrayList<byte[]>();
            if (dirName.equals(this.recentPath) && this.recentDirs != null && this.recentDirs.length != 0) {
                byte[] dirNameBytes = this.recentDirs[subDirNo].getBytes(StandardCharsets.UTF_8);
                command.add(DataConvertUtils.intToArrLE(dirNameBytes.length));
                command.add(dirNameBytes);
            } else {
                File pathDir = new File(dirName);
                if (this.notExistsOrDirectory(pathDir)) {
                    this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDirectory' command [doesn't exist or not a folder]");
                    return;
                }
                this.recentPath = dirName;
                this.recentDirs = pathDir.list(this::isDirectoryAndNotHidden);
                if (this.recentDirs != null && this.recentDirs.length > subDirNo) {
                    Arrays.sort(this.recentFiles, String.CASE_INSENSITIVE_ORDER);
                    byte[] dirBytesName = this.recentDirs[subDirNo].getBytes(StandardCharsets.UTF_8);
                    command.add(DataConvertUtils.intToArrLE(dirBytesName.length));
                    command.add(dirBytesName);
                } else {
                    this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDirectory' command [doesn't exist or not a folder]");
                    return;
                }
            }
            this.writeGL_PASS(command, "GL Handle 'GetDirectory' command.");
            return;
        }
        this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDirectory' command for virtual drive [no folders support]");
    }

    protected void getFile(String glDirName, int subDirNo) throws Exception {
        LinkedList<byte[]> command = new LinkedList<byte[]>();
        if (glDirName.startsWith("HOME:/")) {
            String dirName = this.decodeGlPath(glDirName);
            if (dirName.equals(this.recentPath) && this.recentFiles != null && this.recentFiles.length != 0) {
                byte[] fileNameBytes = this.recentFiles[subDirNo].getBytes(StandardCharsets.UTF_8);
                command.add(DataConvertUtils.intToArrLE(fileNameBytes.length));
                command.add(fileNameBytes);
            } else {
                File pathDir = new File(dirName);
                if (this.notExistsOrDirectory(pathDir)) {
                    this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetFile' command [doesn't exist or not a folder]");
                    return;
                }
                this.recentPath = dirName;
                this.recentFiles = pathDir.list(this::isFileAndNotHidden);
                if (this.recentFiles != null && this.recentFiles.length > subDirNo) {
                    Arrays.sort(this.recentFiles, String.CASE_INSENSITIVE_ORDER);
                    byte[] fileNameBytes = this.recentFiles[subDirNo].getBytes(StandardCharsets.UTF_8);
                    command.add(DataConvertUtils.intToArrLE(fileNameBytes.length));
                    command.add(fileNameBytes);
                } else {
                    this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetFile' command [doesn't exist or not a folder]");
                    return;
                }
            }
            this.writeGL_PASS(command, "GL Handle 'GetFile' command.");
            return;
        }
        if (glDirName.equals("VIRT:/") && !this.nspMap.isEmpty()) {
            byte[] fileNameBytes = this.nspMapKeySetIndexes[subDirNo].getBytes(StandardCharsets.UTF_8);
            command.add(DataConvertUtils.intToArrLE(fileNameBytes.length));
            command.add(fileNameBytes);
            this.writeGL_PASS(command, "GL Handle 'GetFile' command.");
            return;
        }
        if (glDirName.equals("SPEC:/") && this.selectedFile != null) {
            byte[] fileNameBytes = this.selectedFile.getName().getBytes(StandardCharsets.UTF_8);
            command.add(DataConvertUtils.intToArrLE(fileNameBytes.length));
            command.add(fileNameBytes);
            this.writeGL_PASS(command, "GL Handle 'GetFile' command.");
            return;
        }
        this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetFile' command for virtual drive [no folders support?]");
    }

    protected void statPath(String glFileName) throws Exception {
        ArrayList<byte[]> command = new ArrayList<byte[]>();
        if (glFileName.startsWith("HOME:/")) {
            File fileDirElement = new File(this.decodeGlPath(glFileName));
            if (fileDirElement.exists()) {
                if (fileDirElement.isDirectory()) {
                    command.add(this.GL_OBJECT_TYPE_DIR);
                } else {
                    command.add(this.GL_OBJECT_TYPE_FILE);
                    command.add(DataConvertUtils.longToArrLE(fileDirElement.length()));
                }
                this.writeGL_PASS(command, "GL Handle 'StatPath' command for " + glFileName);
                return;
            }
        } else if (glFileName.startsWith("VIRT:/")) {
            String fileName = glFileName.replaceFirst("^.*?:/", "");
            if (this.nspMap.containsKey(fileName)) {
                command.add(this.GL_OBJECT_TYPE_FILE);
                if (((File)this.nspMap.get(fileName)).isDirectory()) {
                    command.add(DataConvertUtils.longToArrLE(this.splitFileSize.get(fileName)));
                } else {
                    command.add(DataConvertUtils.longToArrLE(((File)this.nspMap.get(fileName)).length()));
                }
                this.writeGL_PASS(command, "GL Handle 'StatPath' command for " + glFileName);
                return;
            }
        } else if (glFileName.startsWith("SPEC:/")) {
            String fileName = glFileName.replaceFirst("^.*?:/", "");
            if (this.selectedFile.getName().equals(fileName)) {
                command.add(this.GL_OBJECT_TYPE_FILE);
                command.add(DataConvertUtils.longToArrLE(this.selectedFile.length()));
                this.writeGL_PASS(command, "GL Handle 'StatPath' command for " + glFileName);
                return;
            }
        }
        this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'StatPath' command [no such path]: " + glFileName);
    }

    protected void rename(String glFileName, String glNewFileName) throws Exception {
        if (glFileName.startsWith("HOME:/")) {
            this.recentPath = null;
            this.recentFiles = null;
            this.recentDirs = null;
            String fileName = this.decodeGlPath(glFileName);
            File newFile = new File(this.decodeGlPath(glNewFileName));
            try {
                if (new File(fileName).renameTo(newFile)) {
                    this.writeGL_PASS("GL Handle 'Rename' command.");
                    return;
                }
            }
            catch (SecurityException se) {
                this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Rename' command failed:\n\t" + se.getMessage());
                return;
            }
        }
        this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Rename' command is not supported for virtual drive, selected files, if file with such name already exists in folder, read-only directories");
    }

    protected void delete(String glFileName) throws Exception {
        if (!glFileName.startsWith("HOME:/")) {
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Delete' command [not supported for virtual drive/wrong drive/read-only directory] " + glFileName);
            return;
        }
        File file = new File(this.decodeGlPath(glFileName));
        try {
            if (file.delete()) {
                this.writeGL_PASS("GL Handle 'Rename' command.");
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Create' command [unknown drive/read-only directory]");
    }

    protected void create(String glFileName, byte type) throws Exception {
        if (!glFileName.startsWith("HOME:/")) {
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Create' command [not supported for virtual drive/wrong drive/read-only directory]" + glFileName);
            return;
        }
        File file = new File(this.decodeGlPath(glFileName));
        try {
            boolean result;
            switch (type) {
                case 1: {
                    boolean bl = file.createNewFile();
                    break;
                }
                case 2: {
                    boolean bl = file.mkdir();
                    break;
                }
                default: {
                    boolean bl = result = false;
                }
            }
            if (result) {
                this.writeGL_PASS("GL Handle 'Create' command.");
                return;
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Create' command [unknown drive/read-only directory]");
    }

    protected void readFile(String glFileName, long offset, long size) throws Exception {
        String fileName = glFileName.replaceFirst("^.*?:/", "");
        if (glFileName.startsWith("VIRT:/")) {
            String fNamePath = ((File)this.nspMap.get(fileName)).getAbsolutePath();
            if (this.openReadFileNameAndPath == null || !this.openReadFileNameAndPath.equals(fNamePath)) {
                if (this.openReadFileNameAndPath != null) {
                    this.closeRAFandSplitReader();
                }
                try {
                    File tempFile = (File)this.nspMap.get(fileName);
                    if (tempFile.isDirectory()) {
                        this.randAccessFile = null;
                        this.splitReader = new NSSplitReader(tempFile, 0L);
                    } else {
                        this.splitReader = null;
                        this.randAccessFile = new RandomAccessFile(tempFile, "r");
                    }
                    this.openReadFileNameAndPath = fNamePath;
                }
                catch (IOException | NullPointerException ioe) {
                    this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
                    return;
                }
            }
        } else {
            String filePath;
            if (glFileName.startsWith("SPEC:/")) {
                if (!fileName.equals(this.selectedFile.getName())) {
                    this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command\n\trequested != selected:\n\t" + glFileName + "\n\t" + String.valueOf(this.selectedFile));
                    return;
                }
                filePath = this.selectedFile.getAbsolutePath();
            } else {
                filePath = this.decodeGlPath(glFileName);
            }
            if (this.openReadFileNameAndPath == null || !this.openReadFileNameAndPath.equals(filePath)) {
                if (this.openReadFileNameAndPath != null) {
                    this.closeRAF();
                }
                try {
                    this.randAccessFile = new RandomAccessFile(filePath, "r");
                    this.openReadFileNameAndPath = filePath;
                }
                catch (IOException | NullPointerException ioe) {
                    this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
                    return;
                }
            }
        }
        try {
            int bytesRead;
            byte[] chunk = new byte[(int)size];
            if (this.randAccessFile == null) {
                this.splitReader.seek(offset);
                bytesRead = this.splitReader.read(chunk);
            } else {
                this.randAccessFile.seek(offset);
                bytesRead = this.randAccessFile.read(chunk);
            }
            if (bytesRead != (int)size) {
                this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command [CMD]\n         At offset: " + offset + "\n         Requested: " + size + "\n         Received:  " + bytesRead);
                return;
            }
            this.writeGL_PASS(DataConvertUtils.longToArrLE(size), "GL Handle 'ReadFile' command [CMD]");
            this.writeUsb(chunk, "GL Handle 'ReadFile' command");
        }
        catch (Exception ioe) {
            this.closeOpenedReadFilesGl();
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' transfer chain\n\t" + ioe.getMessage());
        }
    }

    void writeFile(String glFileName) throws Exception {
        byte[] transferredData;
        if (glFileName.startsWith("VIRT:/")) {
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'WriteFile' command [not supported for virtual drive]");
            return;
        }
        if (!this.writeFilesMap.containsKey(glFileName = this.decodeGlPath(glFileName))) {
            try {
                this.writeFilesMap.put(glFileName, new BufferedOutputStream(new FileOutputStream(glFileName, true)));
            }
            catch (IOException ioe) {
                this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'WriteFile' command [IOException]\n\t" + ioe.getMessage());
                return;
            }
        }
        if ((transferredData = this.readGL_file()) == null) {
            this.print("GL Handle 'WriteFile' command [1/1]", EMsgType.FAIL);
            return;
        }
        try {
            this.writeFilesMap.get(glFileName).write(transferredData, 0, transferredData.length);
        }
        catch (IOException ioe) {
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'WriteFile' command [1/1]\n\t" + ioe.getMessage());
            return;
        }
        this.writeGL_PASS("GL Handle 'WriteFile' command");
    }

    protected void selectFile() throws Exception {
        File selectedFile = CompletableFuture.supplyAsync(() -> {
            FileChooser fChooser = new FileChooser();
            fChooser.setTitle(MediatorControl.INSTANCE.getResourceBundle().getString("btn_OpenFile"));
            fChooser.setInitialDirectory(new File(System.getProperty("user.home")));
            fChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("*", "*"));
            return fChooser.showOpenDialog(null);
        }, Platform::runLater).join();
        if (selectedFile == null) {
            this.selectedFile = null;
            this.writeGL_FAIL(SELECTION_CANCELLED, "GL Handle 'SelectFile' command: Nothing selected");
            return;
        }
        byte[] selectedFileNameBytes = ("SPEC:/" + selectedFile.getName()).getBytes(StandardCharsets.UTF_8);
        List<byte[]> command = Arrays.asList(DataConvertUtils.intToArrLE(selectedFileNameBytes.length), selectedFileNameBytes);
        this.selectedFile = null;
        this.writeGL_PASS(command, "GL Handle 'SelectFile' command");
        this.selectedFile = selectedFile;
    }

    protected String decodeGlPath(String glPath) {
        if (this.isWindows) {
            glPath = glPath.replace('/', '\\');
        }
        return this.homePath + glPath.substring(5);
    }

    private boolean isFileAndNotHidden(File parent, String child) {
        File entry = new File(parent, child);
        return !entry.isDirectory() && (this.nspFilter ? child.toLowerCase().endsWith(".nsp") : !entry.isHidden());
    }

    private boolean isDirectoryAndNotHidden(File parent, String child) {
        File dir = new File(parent, child);
        return dir.isDirectory() && !dir.isHidden();
    }

    private boolean notExistsOrDirectory(File pathDir) {
        return !pathDir.exists() || !pathDir.isDirectory();
    }

    protected void closeOpenedReadFilesGl() {
        if (this.openReadFileNameAndPath != null) {
            this.closeRAFandSplitReader();
            this.openReadFileNameAndPath = null;
            this.randAccessFile = null;
            this.splitReader = null;
        }
    }

    protected void closeRAFandSplitReader() {
        this.closeRAF();
        try {
            if (this.splitReader != null) {
                this.splitReader.close();
            }
        }
        catch (Exception e) {
            this.print("Unable to close: " + this.openReadFileNameAndPath + "\n\t" + e.getMessage(), EMsgType.WARNING);
        }
    }

    protected void closeRAF() {
        try {
            if (this.randAccessFile != null) {
                this.randAccessFile.close();
            }
        }
        catch (Exception e) {
            this.print("Unable to close: " + this.openReadFileNameAndPath + "\n\t" + e.getMessage(), EMsgType.WARNING);
        }
    }

    protected byte[] readUsb() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(4096);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[readBufTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    this.closeOpenedReadFilesGl();
                    continue block4;
                }
            }
            throw new Exception("Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)");
        }
        throw new InterruptedException("Execution interrupted");
    }

    private byte[] readGL_file() {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(0x800000);
        IntBuffer rBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, rBufferTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[rBufferTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            return null;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return null;
    }

    protected void writeGL_PASS(String onFailureText) throws Exception {
        this.writeUsb(CMD_GLCO_SUCCESS, onFailureText);
    }

    protected void writeGL_PASS(byte[] message, String onFailureText) throws Exception {
        this.writeUsb(ByteBuffer.allocate(4096).put(CMD_GLCO_SUCCESS_FLAG).put(message).array(), onFailureText);
    }

    protected void writeGL_PASS(List<byte[]> messages, String onFailureText) throws Exception {
        ByteBuffer writeBuffer = ByteBuffer.allocate(4096).put(CMD_GLCO_SUCCESS_FLAG);
        messages.forEach(writeBuffer::put);
        this.writeUsb(writeBuffer.array(), onFailureText);
    }

    protected void writeGL_FAIL(byte[] failurePacket, String failureMessage) throws Exception {
        this.writeUsb(failurePacket, failureMessage);
        this.print(failureMessage, EMsgType.WARNING);
    }

    private void writeUsb(byte[] message, String operation) throws Exception {
        IntBuffer wBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, ByteBuffer.allocateDirect(message.length).put(message), wBufferTransferred, 1000L);
            switch (result) {
                case 0: {
                    if (wBufferTransferred.get() == message.length) {
                        return;
                    }
                    this.print(operation + "\n         Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + wBufferTransferred.get(), EMsgType.FAIL);
                    throw new LibUsbException("Transferred amount of data mismatch", 0);
                }
                case -7: {
                    continue block4;
                }
            }
            this.print(operation + "\n         Data transfer issue [write]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            throw new LibUsbException(result);
        }
        throw new InterruptedException("Execution interrupted");
    }
}

