/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.XCI;

import java.util.Arrays;
import libKonogonka.Converter;

public class XCIGamecardHeader {
    private final byte[] rsa2048PKCS1sig;
    private final boolean magicHead;
    private final byte[] SecureAreaStartAddr;
    private final boolean bkupAreaStartAddr;
    private final byte titleKEKIndexBoth;
    private final byte titleKEKIndex;
    private final byte KEKIndex;
    private final byte gcSize;
    private final byte gcVersion;
    private final byte gcFlags;
    private final byte[] pkgID;
    private final long valDataEndAddr;
    private final byte[] gcInfoIV;
    private final long hfs0partOffset;
    private final long hfs0headerSize;
    private final byte[] hfs0headerSHA256;
    private final byte[] hfs0initDataSHA256;
    private final int secureModeFlag;
    private final int titleKeyFlag;
    private final int keyFlag;
    private final byte[] normAreaEndAddress;

    XCIGamecardHeader(byte[] headerBytes) throws Exception {
        if (headerBytes.length != 400) {
            throw new Exception("XCIGamecardHeader Incorrect array size. Expected 400 bytes while received " + headerBytes.length);
        }
        this.rsa2048PKCS1sig = Arrays.copyOfRange(headerBytes, 0, 256);
        this.magicHead = Arrays.equals(Arrays.copyOfRange(headerBytes, 256, 260), new byte[]{72, 69, 65, 68});
        this.SecureAreaStartAddr = Arrays.copyOfRange(headerBytes, 260, 264);
        this.bkupAreaStartAddr = Arrays.equals(Arrays.copyOfRange(headerBytes, 264, 268), new byte[]{-1, -1, -1, -1});
        this.titleKEKIndexBoth = headerBytes[268];
        this.titleKEKIndex = (byte)(this.titleKEKIndexBoth >> 4 & 0xF);
        this.KEKIndex = (byte)(this.titleKEKIndexBoth & 0xF);
        this.gcSize = headerBytes[269];
        this.gcVersion = headerBytes[270];
        this.gcFlags = headerBytes[271];
        this.pkgID = Arrays.copyOfRange(headerBytes, 272, 280);
        this.valDataEndAddr = Converter.getLElong(headerBytes, 280);
        this.gcInfoIV = Converter.flip(Arrays.copyOfRange(headerBytes, 288, 304));
        this.hfs0partOffset = Converter.getLElong(headerBytes, 304);
        this.hfs0headerSize = Converter.getLElong(headerBytes, 312);
        this.hfs0headerSHA256 = Arrays.copyOfRange(headerBytes, 320, 352);
        this.hfs0initDataSHA256 = Arrays.copyOfRange(headerBytes, 352, 384);
        this.secureModeFlag = Converter.getLEint(headerBytes, 384);
        this.titleKeyFlag = Converter.getLEint(headerBytes, 388);
        this.keyFlag = Converter.getLEint(headerBytes, 392);
        this.normAreaEndAddress = Arrays.copyOfRange(headerBytes, 396, 400);
    }

    public byte[] getRsa2048PKCS1sig() {
        return this.rsa2048PKCS1sig;
    }

    public boolean isMagicHeadOk() {
        return this.magicHead;
    }

    public byte[] getSecureAreaStartAddr() {
        return this.SecureAreaStartAddr;
    }

    public boolean isBkupAreaStartAddrOk() {
        return this.bkupAreaStartAddr;
    }

    public byte getTitleKEKIndexBoth() {
        return this.titleKEKIndexBoth;
    }

    public byte getTitleKEKIndex() {
        return this.titleKEKIndex;
    }

    public byte getKEKIndex() {
        return this.KEKIndex;
    }

    public byte getGcSize() {
        return this.gcSize;
    }

    public byte getGcVersion() {
        return this.gcVersion;
    }

    public byte getGcFlags() {
        return this.gcFlags;
    }

    public byte[] getPkgID() {
        return this.pkgID;
    }

    public long getValDataEndAddr() {
        return this.valDataEndAddr;
    }

    public byte[] getGcInfoIV() {
        return this.gcInfoIV;
    }

    public long getHfs0partOffset() {
        return this.hfs0partOffset;
    }

    public long getHfs0headerSize() {
        return this.hfs0headerSize;
    }

    public byte[] getHfs0headerSHA256() {
        return this.hfs0headerSHA256;
    }

    public byte[] getHfs0initDataSHA256() {
        return this.hfs0initDataSHA256;
    }

    public int getSecureModeFlag() {
        return this.secureModeFlag;
    }

    public boolean isSecureModeFlagOk() {
        return this.secureModeFlag == 1;
    }

    public int getTitleKeyFlag() {
        return this.titleKeyFlag;
    }

    public boolean istitleKeyFlagOk() {
        return this.titleKeyFlag == 2;
    }

    public int getKeyFlag() {
        return this.keyFlag;
    }

    public boolean iskeyFlagOk() {
        return this.keyFlag == 0;
    }

    public byte[] getNormAreaEndAddr() {
        return this.normAreaEndAddress;
    }
}

