/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.nxdumptool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.nxdumptool.NxdtHostIOException;
import nsusbloader.Utilities.nxdumptool.NxdtMalformedException;
import nsusbloader.Utilities.nxdumptool.NxdtNspFile;
import nsusbloader.Utilities.nxdumptool.NxdtTask;
import nsusbloader.com.usb.common.DeviceInformation;
import nsusbloader.com.usb.common.NsUsbEndpointDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

class NxdtUsbAbi1 {
    private final ILogPrinter logPrinter;
    private final DeviceHandle handlerNS;
    private final String saveToPath;
    private final NxdtTask parent;
    private final boolean isWindows;
    private boolean isWindows10;
    private static final int NXDT_MAX_DIRECTIVE_SIZE = 0x800000;
    private static final int NXDT_FILE_CHUNK_SIZE = 0x800000;
    private static final int NXDT_FILE_PROPERTIES_MAX_NAME_LENGTH = 768;
    private static final byte ABI_VERSION = 1;
    private static final byte[] MAGIC_NXDT = new byte[]{78, 88, 68, 84};
    private static final int CMD_HANDSHAKE = 0;
    private static final int CMD_SEND_FILE_PROPERTIES = 1;
    private static final int CMD_SEND_NSP_HEADER = 2;
    private static final int CMD_ENDSESSION = 3;
    private static final byte[] USBSTATUS_SUCCESS = new byte[]{78, 88, 68, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] USBSTATUS_INVALID_MAGIC = new byte[]{78, 88, 68, 84, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] USBSTATUS_UNSUPPORTED_CMD = new byte[]{78, 88, 68, 84, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] USBSTATUS_UNSUPPORTED_ABI = new byte[]{78, 88, 68, 84, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] USBSTATUS_MALFORMED_REQUEST = new byte[]{78, 88, 68, 84, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] USBSTATUS_HOSTIOERROR = new byte[]{78, 88, 68, 84, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int NXDT_USB_TIMEOUT = 5000;
    private NxdtNspFile nspFile;

    public NxdtUsbAbi1(DeviceHandle handler, ILogPrinter logPrinter, String saveToPath, NxdtTask parent) throws Exception {
        this.handlerNS = handler;
        this.logPrinter = logPrinter;
        this.parent = parent;
        this.isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        if (this.isWindows) {
            this.isWindows10 = System.getProperty("os.name").toLowerCase().contains("windows 10");
        }
        this.saveToPath = !saveToPath.endsWith(File.separator) ? saveToPath + File.separator : saveToPath;
        this.resolveEndpointMaxPacketSize();
        this.readLoop();
    }

    private void resolveEndpointMaxPacketSize() throws Exception {
        DeviceInformation deviceInformation = DeviceInformation.build(this.handlerNS);
        NsUsbEndpointDescriptor endpointInDescriptor = deviceInformation.getSimplifiedDefaultEndpointDescriptorIn();
        short endpointMaxPacketSize = endpointInDescriptor.getwMaxPacketSize();
        NxdtUsbAbi1.USBSTATUS_SUCCESS[8] = (byte)(endpointMaxPacketSize & 0xFF);
        NxdtUsbAbi1.USBSTATUS_SUCCESS[9] = (byte)(endpointMaxPacketSize >> 8 & 0xFF);
    }

    private void readLoop() throws InterruptedException {
        this.logPrinter.print("Awaiting for handshake", EMsgType.INFO);
        try {
            block9: while (true) {
                byte[] directive;
                if (this.isInvalidDirective(directive = this.readUsbDirective())) {
                    continue;
                }
                int command = this.getLEint(directive, 4);
                switch (command) {
                    case 0: {
                        this.performHandshake(directive);
                        continue block9;
                    }
                    case 1: {
                        this.handleSendFileProperties(directive);
                        continue block9;
                    }
                    case 2: {
                        this.handleSendNspHeader(directive);
                        continue block9;
                    }
                    case 3: {
                        this.logPrinter.print("Session successfully ended.", EMsgType.PASS);
                        return;
                    }
                }
                this.writeUsb(USBSTATUS_UNSUPPORTED_CMD);
                this.logPrinter.print(String.format("Unsupported command 0x%08x", command), EMsgType.FAIL);
            }
        }
        catch (InterruptedException ie) {
            this.logPrinter.print("Execution interrupted", EMsgType.INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logPrinter.print(e.getMessage(), EMsgType.INFO);
            this.logPrinter.print("Terminating now", EMsgType.FAIL);
        }
    }

    private boolean isInvalidDirective(byte[] message) throws Exception {
        if (message.length < 16) {
            this.writeUsb(USBSTATUS_MALFORMED_REQUEST);
            this.logPrinter.print("Directive is too small. Only " + message.length + " bytes received.", EMsgType.FAIL);
            return true;
        }
        if (!Arrays.equals(Arrays.copyOfRange(message, 0, 4), MAGIC_NXDT)) {
            this.writeUsb(USBSTATUS_INVALID_MAGIC);
            this.logPrinter.print("Invalid 'MAGIC'", EMsgType.FAIL);
            return true;
        }
        int payloadSize = this.getLEint(message, 8);
        if (payloadSize + 16 != message.length) {
            this.writeUsb(USBSTATUS_MALFORMED_REQUEST);
            this.logPrinter.print("Invalid directive info block size. " + message.length + " bytes received while " + payloadSize + " expected.", EMsgType.FAIL);
            return true;
        }
        return false;
    }

    private void performHandshake(byte[] message) throws Exception {
        byte versionMajor = message[16];
        byte versionMinor = message[17];
        byte versionMicro = message[18];
        byte versionABI = message[19];
        this.logPrinter.print("nxdumptool v" + versionMajor + "." + versionMinor + "." + versionMicro + " ABI v" + versionABI, EMsgType.INFO);
        if (1 != versionABI) {
            this.writeUsb(USBSTATUS_UNSUPPORTED_ABI);
            throw new Exception("ABI v" + versionABI + " is not supported in current version.");
        }
        this.writeUsb(USBSTATUS_SUCCESS);
    }

    private void handleSendFileProperties(byte[] message) throws Exception {
        try {
            long fullSize = this.getLElong(message, 16);
            int fileNameLen = this.getLEint(message, 24);
            int headerSize = this.getLEint(message, 28);
            this.checkFileNameLen(fileNameLen);
            String filename = new String(message, 32, fileNameLen, StandardCharsets.UTF_8);
            String absoluteFilePath = this.getAbsoluteFilePath(filename);
            File fileToDump = new File(absoluteFilePath);
            this.checkSizes(fullSize, headerSize);
            this.createPath(absoluteFilePath);
            this.checkFileSystem(fileToDump, fullSize);
            if (headerSize > 0) {
                this.logPrinter.print("Receiving NSP file: '" + filename + "' (" + this.formatByteSize(fullSize) + ")", EMsgType.PASS);
                this.createNewNsp(filename, headerSize, fullSize, fileToDump);
                return;
            }
            this.logPrinter.print("Receiving: '" + filename + "' (" + fullSize + " b)", EMsgType.INFO);
            this.writeUsb(USBSTATUS_SUCCESS);
            if (fullSize == 0L) {
                return;
            }
            if (this.isNspTransfer()) {
                this.dumpNspFile(fullSize);
            } else {
                this.dumpFile(fileToDump, fullSize);
            }
            this.writeUsb(USBSTATUS_SUCCESS);
        }
        catch (NxdtMalformedException malformed) {
            this.logPrinter.print(malformed.getMessage(), EMsgType.FAIL);
            this.writeUsb(USBSTATUS_MALFORMED_REQUEST);
        }
        catch (NxdtHostIOException ioException) {
            this.logPrinter.print(ioException.getMessage(), EMsgType.FAIL);
            this.writeUsb(USBSTATUS_HOSTIOERROR);
        }
    }

    private void checkFileNameLen(int fileNameLen) throws NxdtMalformedException {
        if (fileNameLen <= 0 || fileNameLen > 768) {
            throw new NxdtMalformedException("Invalid filename length!");
        }
    }

    private void checkSizes(long fileSize, int headerSize) throws Exception {
        if ((long)headerSize >= fileSize) {
            this.resetNsp();
            throw new NxdtMalformedException(String.format("File size (%d) should not be less or equal to header size (%d)!", fileSize, headerSize));
        }
        if (fileSize < 0L) {
            this.resetNsp();
            throw new NxdtMalformedException("File size should not be less then zero!");
        }
    }

    private void checkFileSystem(File fileToDump, long fileSize) throws Exception {
        if (fileToDump.getParentFile().getFreeSpace() <= fileSize) {
            throw new NxdtHostIOException("Not enough space on selected volume. Need: " + fileSize + " while available: " + fileToDump.getParentFile().getFreeSpace());
        }
        if (!fileToDump.canWrite() && !fileToDump.createNewFile()) {
            throw new NxdtHostIOException("Unable to write into selected volume: " + fileToDump.getAbsolutePath());
        }
    }

    private void createNewNsp(String filename, int headerSize, long fileSize, File fileToDump) throws NxdtHostIOException {
        try {
            this.nspFile = new NxdtNspFile(filename, headerSize, fileSize, fileToDump);
            this.writeUsb(USBSTATUS_SUCCESS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NxdtHostIOException("Unable to create new file for: " + filename + " :" + e.getMessage());
        }
    }

    private int getLEint(byte[] bytes, int fromOffset) {
        return ByteBuffer.wrap(bytes, fromOffset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    private long getLElong(byte[] bytes, int fromOffset) {
        return ByteBuffer.wrap(bytes, fromOffset, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    private boolean isNspTransfer() {
        return this.nspFile != null;
    }

    private String getAbsoluteFilePath(String filename) {
        if (this.isRomFs(filename) && this.isWindows) {
            return this.saveToPath + filename.replaceAll("/", "\\\\");
        }
        return this.saveToPath + filename;
    }

    private boolean isRomFs(String filename) {
        return filename.startsWith("/");
    }

    private void createPath(String path) throws Exception {
        try {
            Path folderForTheFile = Paths.get(path, new String[0]).getParent();
            Files.createDirectories(folderForTheFile, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new NxdtHostIOException("Unable to create dir(s) for file '" + path + "':" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFile(File file, long size) throws Exception {
        FileOutputStream fos = new FileOutputStream(file, true);
        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
            byte[] readBuffer;
            FileDescriptor fd = fos.getFD();
            long received = 0L;
            while (received + 0x800000L < size) {
                readBuffer = this.readUsbFileDebug(0x800000);
                bos.write(readBuffer);
                if (this.isWindows10) {
                    fd.sync();
                }
                int bufferSize = readBuffer.length;
                this.logPrinter.updateProgress((double)(received += (long)bufferSize) / (double)size);
            }
            int lastChunkSize = (int)(size - received) + 1;
            readBuffer = this.readUsbFileDebug(lastChunkSize);
            bos.write(readBuffer);
            if (this.isWindows10) {
                fd.sync();
            }
        }
        finally {
            this.logPrinter.updateProgress(1.0);
        }
    }

    private void dumpNspFile(long size) throws Exception {
        FileOutputStream fos = new FileOutputStream(this.nspFile.getFile(), true);
        long nspSize = this.nspFile.getFullSize();
        try (BufferedOutputStream bos = new BufferedOutputStream(fos);){
            byte[] readBuffer;
            long nspRemainingSize = this.nspFile.getNspRemainingSize();
            FileDescriptor fd = fos.getFD();
            long received = 0L;
            while (received + 0x800000L < size) {
                readBuffer = this.readUsbFileDebug(0x800000);
                bos.write(readBuffer);
                if (this.isWindows10) {
                    fd.sync();
                }
                int bufferSize = readBuffer.length;
                received += (long)bufferSize;
                this.logPrinter.updateProgress((double)(nspSize - (nspRemainingSize -= (long)bufferSize)) / (double)nspSize);
            }
            int lastChunkSize = (int)(size - received) + 1;
            readBuffer = this.readUsbFileDebug(lastChunkSize);
            bos.write(readBuffer);
            if (this.isWindows10) {
                fd.sync();
            }
            this.nspFile.setNspRemainingSize(nspRemainingSize -= (long)(lastChunkSize - 1));
        }
    }

    private void handleSendNspHeader(byte[] message) throws Exception {
        int headerSize = this.getLEint(message, 8);
        NxdtNspFile nsp = this.nspFile;
        this.resetNsp();
        this.logPrinter.updateProgress(1.0);
        if (nsp == null) {
            this.writeUsb(USBSTATUS_MALFORMED_REQUEST);
            this.logPrinter.print("Received NSP send header request outside of known NSPs!", EMsgType.FAIL);
            return;
        }
        if (nsp.getNspRemainingSize() > 0L) {
            this.writeUsb(USBSTATUS_MALFORMED_REQUEST);
            this.logPrinter.print("Received NSP send header request without receiving all NSP file entry data!", EMsgType.FAIL);
            return;
        }
        if (headerSize != nsp.getHeaderSize()) {
            this.writeUsb(USBSTATUS_MALFORMED_REQUEST);
            this.logPrinter.print("Received NSP header size mismatch! " + headerSize + " != " + nsp.getHeaderSize(), EMsgType.FAIL);
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(nsp.getFile(), "rw");){
            byte[] headerData = Arrays.copyOfRange(message, 16, headerSize + 16);
            raf.seek(0L);
            raf.write(headerData);
        }
        this.logPrinter.print("NSP file: '" + nsp.getName() + "' successfully received!", EMsgType.PASS);
        this.writeUsb(USBSTATUS_SUCCESS);
    }

    private void resetNsp() {
        this.nspFile = null;
    }

    private void writeUsb(byte[] message) throws Exception {
        ByteBuffer writeBuffer = ByteBuffer.allocateDirect(message.length);
        writeBuffer.put(message);
        IntBuffer writeBufTransferred = IntBuffer.allocate(1);
        if (this.parent.isCancelled()) {
            throw new InterruptedException("Execution interrupted");
        }
        int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, writeBuffer, writeBufTransferred, 5000L);
        if (result == 0) {
            if (writeBufTransferred.get() == message.length) {
                return;
            }
            throw new Exception("Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + writeBufTransferred.get());
        }
        throw new Exception("Data transfer issue [write]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)");
    }

    private byte[] readUsbDirective() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(0x800000);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.parent.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    int trans = readBufTransferred.get();
                    byte[] receivedBytes = new byte[trans];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            throw new Exception("Data transfer issue [read command]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)");
        }
        throw new InterruptedException();
    }

    private byte[] readUsbFile() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(0x800000);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: for (int countDown = 0; !this.parent.isCancelled() && countDown < 5; ++countDown) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    int trans = readBufTransferred.get();
                    byte[] receivedBytes = new byte[trans];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            throw new Exception("Data transfer issue [read file]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)");
        }
        throw new InterruptedException();
    }

    private byte[] readUsbFileDebug(int chunkSize) throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(chunkSize);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        if (this.parent.isCancelled()) {
            throw new InterruptedException();
        }
        int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 5000L);
        if (result == 0) {
            int trans = readBufTransferred.get();
            byte[] receivedBytes = new byte[trans];
            readBuffer.get(receivedBytes);
            return receivedBytes;
        }
        throw new Exception("Data transfer issue [read file]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)");
    }

    private String formatByteSize(double length) {
        int i;
        String[] unitNames = new String[]{"bytes", "KiB", "MiB", "GiB", "TiB"};
        for (i = 0; length > 1024.0 && i < unitNames.length - 1; length /= 1024.0, ++i) {
        }
        return String.format("%,.2f %s", length, unitNames[i]);
    }
}

