/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;

public final class ContainerIdDescriptor {
    private long containerIdDescriptorPointer;

    public long getPointer() {
        return this.containerIdDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native byte bDevCapabilityType();

    public native byte bReserved();

    public native ByteBuffer containerId();

    public String dump() {
        return String.format("Container ID Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  bDevCapabilityType %7d%n  bReserved %16d%n  ContainerID:%n%s%n", this.bLength() & 0xFF, this.bDescriptorType() & 0xFF, this.bDevCapabilityType() & 0xFF, this.bReserved() & 0xFF, DescriptorUtils.dump(this.containerId()).replaceAll("(?m)^", "    "));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bDevCapabilityType()).append(this.bReserved()).append(this.containerId()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ContainerIdDescriptor other = (ContainerIdDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bDevCapabilityType(), other.bDevCapabilityType()).append(this.bReserved(), other.bReserved()).append(this.containerId(), other.containerId()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

