/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.PixelUtils;
import java.nio.ByteBuffer;

abstract class BaseIndexedToByteConverter
implements ByteToBytePixelConverter {
    protected final IndexedGetter getter;
    protected final BytePixelSetter setter;
    protected final int nSrcElems;
    protected final int nDstElems;

    BaseIndexedToByteConverter(IndexedGetter indexedGetter, BytePixelSetter bytePixelSetter) {
        this.getter = indexedGetter;
        this.setter = bytePixelSetter;
        this.nSrcElems = indexedGetter.getNumElements();
        this.nDstElems = bytePixelSetter.getNumElements();
    }

    public final IndexedGetter getGetter() {
        return this.getter;
    }

    public final BytePixelSetter getSetter() {
        return this.setter;
    }

    abstract void doConvert(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, int var7, int var8);

    abstract void doConvert(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8);

    @Override
    public final void convert(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (n2 == n5 * this.nSrcElems && n4 == n5 * this.nDstElems) {
            n5 *= n6;
            n6 = 1;
        }
        this.doConvert(byArray, n, n2, byArray2, n3, n4, n5, n6);
    }

    @Override
    public final void convert(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4, int n5, int n6) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (n2 == n5 * this.nSrcElems && n4 == n5 * this.nDstElems) {
            n5 *= n6;
            n6 = 1;
        }
        if (byteBuffer.hasArray() && byteBuffer2.hasArray()) {
            this.doConvert(byteBuffer.array(), n += byteBuffer.arrayOffset(), n2, byteBuffer2.array(), n3 += byteBuffer2.arrayOffset(), n4, n5, n6);
        } else {
            this.doConvert(byteBuffer, n, n2, byteBuffer2, n3, n4, n5, n6);
        }
    }

    @Override
    public final void convert(ByteBuffer byteBuffer, int n, int n2, byte[] byArray, int n3, int n4, int n5, int n6) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (n2 == n5 * this.nSrcElems && n4 == n5 * this.nDstElems) {
            n5 *= n6;
            n6 = 1;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray2 = byteBuffer.array();
            this.doConvert(byArray2, n += byteBuffer.arrayOffset(), n2, byArray, n3, n4, n5, n6);
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            this.doConvert(byteBuffer, n, n2, byteBuffer2, n3, n4, n5, n6);
        }
    }

    @Override
    public final void convert(byte[] byArray, int n, int n2, ByteBuffer byteBuffer, int n3, int n4, int n5, int n6) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (n2 == n5 * this.nSrcElems && n4 == n5 * this.nDstElems) {
            n5 *= n6;
            n6 = 1;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray2 = byteBuffer.array();
            this.doConvert(byArray, n, n2, byArray2, n3 += byteBuffer.arrayOffset(), n4, n5, n6);
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            this.doConvert(byteBuffer2, n, n2, byteBuffer, n3, n4, n5, n6);
        }
    }

    static abstract class IndexedGetter
    implements BytePixelGetter {
        final int[] preColors;
        final int[] nonPreColors;
        private final AlphaType alphaType;

        IndexedGetter(int[] nArray, AlphaType alphaType) {
            int[] nArray2 = null;
            int[] nArray3 = null;
            switch (alphaType) {
                case OPAQUE: {
                    nArray3 = nArray;
                    nArray2 = nArray;
                    break;
                }
                case PREMULTIPLIED: {
                    nArray2 = nArray;
                    nArray3 = new int[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray3[i] = PixelUtils.PretoNonPre(nArray[i]);
                    }
                    break;
                }
                case NONPREMULTIPLIED: {
                    nArray3 = nArray;
                    nArray2 = new int[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray2[i] = PixelUtils.NonPretoPre(nArray[i]);
                    }
                    break;
                }
            }
            this.alphaType = alphaType;
            this.preColors = nArray2;
            this.nonPreColors = nArray3;
        }

        @Override
        public AlphaType getAlphaType() {
            return this.alphaType;
        }
    }
}

