/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.fs;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import libKonogonka.Converter;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.MalformedIniFileException;

public class FsIniMaker {
    private static final String FILE_HEADER_TEXT = "# UTF-8\n# A KIP section is [kip1_name:sha256_hex_8bytes]\n# A patchset is .patch_name=kip_section_dec:offset_hex_0x:length_hex_0x:src_data_hex,dst_data_hex\n# _dec: 1 char decimal | _hex_0x: max u32 prefixed with 0x | _hex: hex array.\n# Kip1 section decimals: TEXT: 0, RODATA: 1, DATA: 2.\n";
    private final ILogPrinter logPrinter;
    private final String saveToLocation;
    private final int offset1;
    private final int offset2;
    private String firmwareVersionInformationNotice;
    private String sectionDeclaration;
    private String patchSet1;
    private String patchSet2;

    public FsIniMaker(ILogPrinter logPrinter, String saveToLocation, byte[] _textSection, int wizardOffset1, int wizardOffset2, byte[] sdkVersion, String patchName, boolean filesystemTypeFat32) throws Exception {
        this.logPrinter = logPrinter;
        this.saveToLocation = saveToLocation;
        this.offset1 = wizardOffset1 - 4;
        this.offset2 = wizardOffset2 - 4;
        this.mkDirs();
        this.makeFwVersionInformationNotice(filesystemTypeFat32, sdkVersion);
        this.makeSectionDeclaration(patchName);
        this.makePatchSet1(_textSection);
        this.makePatchSet2(_textSection);
        this.writeFile();
    }

    private void mkDirs() {
        File parentFolder = new File(this.saveToLocation + File.separator + "bootloader");
        parentFolder.mkdirs();
    }

    private void makeFwVersionInformationNotice(boolean isFat32, byte[] fwVersion) {
        String fwVersionFormatted = fwVersion[3] + "." + fwVersion[2] + "." + fwVersion[1] + "." + fwVersion[0];
        this.firmwareVersionInformationNotice = isFat32 ? "\n#FS (FAT)" + fwVersionFormatted + "\n" : "\n#FS (ExFAT) " + fwVersionFormatted + "\n";
    }

    private void makeSectionDeclaration(String patchName) {
        this.sectionDeclaration = "[FS:" + patchName.substring(0, 16) + "]";
    }

    private void makePatchSet1(byte[] _textSection) {
        if (this.offset1 > 0) {
            byte[] originalInstruction = Arrays.copyOfRange(_textSection, this.offset1, this.offset1 + 4);
            this.patchSet1 = String.format(".nosigchk=0:0x%02X:0x4:%s,1F2003D5", this.offset1, Converter.byteArrToHexStringAsLE(originalInstruction, true));
        }
    }

    private void makePatchSet2(byte[] _textSection) {
        if (this.offset2 > 0) {
            byte[] originalInstruction = Arrays.copyOfRange(_textSection, this.offset2, this.offset2 + 4);
            this.patchSet2 = String.format(".nosigchk=0:0x%02X:0x4:%s,E0031F2A", this.offset2, Converter.byteArrToHexStringAsLE(originalInstruction, true));
        }
    }

    private void writeFile() throws Exception {
        String iniLocation = this.saveToLocation + File.separator + "bootloader" + File.separator + "patches.ini";
        Path iniLocationPath = Paths.get(iniLocation, new String[0]);
        boolean iniNotExists = Files.notExists(iniLocationPath, new LinkOption[0]);
        try (RandomAccessFile ini = new RandomAccessFile(iniLocation, "rw");){
            if (iniNotExists) {
                ini.writeBytes(FILE_HEADER_TEXT);
            } else {
                String line;
                while ((line = ini.readLine()) != null) {
                    String expression1;
                    if (!line.startsWith(this.sectionDeclaration)) continue;
                    if (!(this.offset1 <= 0 || (expression1 = ini.readLine()) != null && expression1.startsWith(this.patchSet1))) {
                        throw new MalformedIniFileException("Somewhere near " + ini.getFilePointer());
                    }
                    String expression2 = ini.readLine();
                    if (this.offset2 > 0) {
                        if (expression2 == null || !expression2.startsWith(this.patchSet2)) {
                            throw new MalformedIniFileException("Somewhere near " + ini.getFilePointer());
                        }
                    } else {
                        if (expression2 == null || !expression2.startsWith(".nosigchk")) {
                            return;
                        }
                        throw new MalformedIniFileException("Somewhere near " + ini.getFilePointer());
                    }
                    return;
                }
            }
            ini.writeBytes(this.firmwareVersionInformationNotice);
            ini.writeBytes(this.sectionDeclaration);
            ini.writeBytes("\n");
            if (this.offset1 > 0) {
                ini.writeBytes(this.patchSet1);
                ini.writeBytes("\n");
            }
            if (this.offset2 > 0) {
                ini.writeBytes(this.patchSet2);
                ini.writeBytes("\n");
            }
        }
        catch (MalformedIniFileException e) {
            e.printStackTrace();
            this.logPrinter.print("Existing patches.ini file is malformed or contains incorrect (outdated) information regarding current patch.\nIt's now saved at " + iniLocation + ".OLD\nNew patches.ini file created instead.", EMsgType.WARNING);
            Files.move(iniLocationPath, Paths.get(iniLocation + ".OLD", new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.writeFile();
        }
    }
}

