/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import com.sun.javafx.UnmodifiableArrayList;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public final class InterpolationUtils {
    private InterpolationUtils() {
    }

    public static double interpolate(double d, double d2, double d3) {
        return d + d3 * (d2 - d);
    }

    public static <T> T interpolateDiscrete(T t, T t2, double d) {
        return d < 0.5 ? t : t2;
    }

    public static double interpolateDiscrete(double d, double d2, double d3) {
        return d3 < 0.5 ? d : d2;
    }

    public static <T extends Interpolatable<T>> List<T> interpolateListsPairwise(List<T> unmodifiableArrayList, List<T> list, double d) {
        Objects.requireNonNull(unmodifiableArrayList, "firstList");
        Objects.requireNonNull(list, "secondList");
        if (list.isEmpty()) {
            return unmodifiableArrayList.isEmpty() ? unmodifiableArrayList : list;
        }
        int n = unmodifiableArrayList.size();
        if (n <= 8 && n == list.size()) {
            return InterpolationUtils.interpolateEquisizedListsPairwise(unmodifiableArrayList, list, d);
        }
        Interpolatable[] interpolatableArray = new Interpolatable[list.size()];
        boolean bl = unmodifiableArrayList.size() == list.size();
        int n2 = unmodifiableArrayList.size();
        for (int i = 0; i < interpolatableArray.length; ++i) {
            if (n2 > i) {
                interpolatableArray[i] = ((Interpolatable)unmodifiableArrayList.get(i)).interpolate((Interpolatable)list.get(i), d);
                bl &= interpolatableArray[i] == unmodifiableArrayList.get(i);
                continue;
            }
            interpolatableArray[i] = (Interpolatable)list.get(i);
        }
        return bl ? unmodifiableArrayList : new UnmodifiableArrayList<Interpolatable>(interpolatableArray, interpolatableArray.length);
    }

    private static <T extends Interpolatable<T>> List<T> interpolateEquisizedListsPairwise(List<T> list, List<T> list2, double d) {
        int n = list.size();
        if (n > 8 || n != list2.size()) {
            throw new AssertionError();
        }
        Interpolatable interpolatable = null;
        Interpolatable interpolatable2 = null;
        Interpolatable interpolatable3 = null;
        Interpolatable interpolatable4 = null;
        Interpolatable interpolatable5 = null;
        Interpolatable interpolatable6 = null;
        Interpolatable interpolatable7 = null;
        Interpolatable interpolatable8 = null;
        boolean bl = true;
        switch (n) {
            case 8: {
                interpolatable8 = ((Interpolatable)list.get(7)).interpolate((Interpolatable)list2.get(7), d);
                bl &= interpolatable8 == list.get(7);
            }
            case 7: {
                interpolatable7 = ((Interpolatable)list.get(6)).interpolate((Interpolatable)list2.get(6), d);
                bl &= interpolatable7 == list.get(6);
            }
            case 6: {
                interpolatable6 = ((Interpolatable)list.get(5)).interpolate((Interpolatable)list2.get(5), d);
                bl &= interpolatable6 == list.get(5);
            }
            case 5: {
                interpolatable5 = ((Interpolatable)list.get(4)).interpolate((Interpolatable)list2.get(4), d);
                bl &= interpolatable5 == list.get(4);
            }
            case 4: {
                interpolatable4 = ((Interpolatable)list.get(3)).interpolate((Interpolatable)list2.get(3), d);
                bl &= interpolatable4 == list.get(3);
            }
            case 3: {
                interpolatable3 = ((Interpolatable)list.get(2)).interpolate((Interpolatable)list2.get(2), d);
                bl &= interpolatable3 == list.get(2);
            }
            case 2: {
                interpolatable2 = ((Interpolatable)list.get(1)).interpolate((Interpolatable)list2.get(1), d);
                bl &= interpolatable2 == list.get(1);
            }
            case 1: {
                interpolatable = ((Interpolatable)list.get(0)).interpolate((Interpolatable)list2.get(0), d);
                bl &= interpolatable == list.get(0);
            }
        }
        if (bl) {
            return list;
        }
        Interpolatable[] interpolatableArray = new Interpolatable[n];
        switch (n) {
            case 8: {
                interpolatableArray[7] = interpolatable8;
            }
            case 7: {
                interpolatableArray[6] = interpolatable7;
            }
            case 6: {
                interpolatableArray[5] = interpolatable6;
            }
            case 5: {
                interpolatableArray[4] = interpolatable5;
            }
            case 4: {
                interpolatableArray[3] = interpolatable4;
            }
            case 3: {
                interpolatableArray[2] = interpolatable3;
            }
            case 2: {
                interpolatableArray[1] = interpolatable2;
            }
            case 1: {
                interpolatableArray[0] = interpolatable;
            }
        }
        return new UnmodifiableArrayList<Interpolatable>(interpolatableArray, n);
    }

    public static <T extends Interpolatable<T>> T[][] interpolateArraySeriesPairwise(T[][] TArray, T[][] TArray2, double d) {
        Objects.requireNonNull(TArray, "firstArraySeries");
        Objects.requireNonNull(TArray2, "secondArraySeries");
        if (TArray2.length == 0) {
            return TArray.length == 0 ? TArray : TArray2;
        }
        TypeDescriptor.OfField ofField = TArray.getClass().componentType();
        Interpolatable[][] interpolatableArray = (Interpolatable[][])Array.newInstance(ofField, TArray2.length);
        boolean bl = TArray.length == TArray2.length;
        int n = TArray.length;
        for (int i = 0; i < interpolatableArray.length; ++i) {
            if (n > i) {
                interpolatableArray[i] = InterpolationUtils.interpolateArraysPairwise(TArray[i], TArray2[i], (double)d);
                bl &= interpolatableArray[i] == TArray[i];
                continue;
            }
            interpolatableArray[i] = TArray2[i];
        }
        return bl ? TArray : interpolatableArray;
    }

    public static <T extends Interpolatable<T>> T[] interpolateArraysPairwise(T[] TArray, T[] TArray2, double d) {
        Objects.requireNonNull(TArray, "firstArray");
        Objects.requireNonNull(TArray2, "secondArray");
        if (TArray2.length == 0) {
            return TArray.length == 0 ? TArray : TArray2;
        }
        int n = TArray.length;
        if (n <= 8 && n == TArray2.length) {
            return InterpolationUtils.interpolateEquisizedArraysPairwise(TArray, TArray2, (double)d);
        }
        TypeDescriptor.OfField ofField = TArray.getClass().componentType();
        Interpolatable[] interpolatableArray = (Interpolatable[])Array.newInstance(ofField, TArray2.length);
        boolean bl = TArray.length == TArray2.length;
        for (int i = 0; i < interpolatableArray.length; ++i) {
            if (n > i) {
                interpolatableArray[i] = (Interpolatable)TArray[i].interpolate(TArray2[i], d);
                bl &= interpolatableArray[i] == TArray[i];
                continue;
            }
            interpolatableArray[i] = TArray2[i];
        }
        return bl ? TArray : interpolatableArray;
    }

    private static <T extends Interpolatable<T>> T[] interpolateEquisizedArraysPairwise(T[] TArray, T[] TArray2, double d) {
        int n = TArray.length;
        if (n > 8 || n != TArray2.length) {
            throw new AssertionError();
        }
        Interpolatable interpolatable = null;
        Interpolatable interpolatable2 = null;
        Interpolatable interpolatable3 = null;
        Interpolatable interpolatable4 = null;
        Interpolatable interpolatable5 = null;
        Interpolatable interpolatable6 = null;
        Interpolatable interpolatable7 = null;
        Interpolatable interpolatable8 = null;
        boolean bl = true;
        switch (n) {
            case 8: {
                interpolatable8 = (Interpolatable)TArray[7].interpolate(TArray2[7], d);
                bl &= interpolatable8 == TArray[7];
            }
            case 7: {
                interpolatable7 = (Interpolatable)TArray[6].interpolate(TArray2[6], d);
                bl &= interpolatable7 == TArray[6];
            }
            case 6: {
                interpolatable6 = (Interpolatable)TArray[5].interpolate(TArray2[5], d);
                bl &= interpolatable6 == TArray[5];
            }
            case 5: {
                interpolatable5 = (Interpolatable)TArray[4].interpolate(TArray2[4], d);
                bl &= interpolatable5 == TArray[4];
            }
            case 4: {
                interpolatable4 = (Interpolatable)TArray[3].interpolate(TArray2[3], d);
                bl &= interpolatable4 == TArray[3];
            }
            case 3: {
                interpolatable3 = (Interpolatable)TArray[2].interpolate(TArray2[2], d);
                bl &= interpolatable3 == TArray[2];
            }
            case 2: {
                interpolatable2 = (Interpolatable)TArray[1].interpolate(TArray2[1], d);
                bl &= interpolatable2 == TArray[1];
            }
            case 1: {
                interpolatable = (Interpolatable)TArray[0].interpolate(TArray2[0], d);
                bl &= interpolatable == TArray[0];
            }
        }
        if (bl) {
            return TArray;
        }
        TypeDescriptor.OfField ofField = TArray.getClass().componentType();
        Interpolatable[] interpolatableArray = (Interpolatable[])Array.newInstance(ofField, n);
        switch (n) {
            case 8: {
                interpolatableArray[7] = interpolatable8;
            }
            case 7: {
                interpolatableArray[6] = interpolatable7;
            }
            case 6: {
                interpolatableArray[5] = interpolatable6;
            }
            case 5: {
                interpolatableArray[4] = interpolatable5;
            }
            case 4: {
                interpolatableArray[3] = interpolatable4;
            }
            case 3: {
                interpolatableArray[2] = interpolatable3;
            }
            case 2: {
                interpolatableArray[1] = interpolatable2;
            }
            case 1: {
                interpolatableArray[0] = interpolatable;
            }
        }
        return interpolatableArray;
    }

    public static Paint interpolatePaint(Paint paint, Paint paint2, double d) {
        Paint paint3;
        if (paint instanceof Color) {
            paint3 = (Color)paint;
            if (paint2 instanceof Color) {
                Color color = (Color)paint2;
                return ((Color)paint3).interpolate(color, d);
            }
            if (paint2 instanceof LinearGradient) {
                LinearGradient linearGradient = (LinearGradient)paint2;
                return InterpolationUtils.newSolidGradient(linearGradient, (Color)paint3).interpolate(linearGradient, d);
            }
            if (paint2 instanceof RadialGradient) {
                RadialGradient radialGradient = (RadialGradient)paint2;
                return InterpolationUtils.newSolidGradient(radialGradient, (Color)paint3).interpolate(radialGradient, d);
            }
        }
        if (paint instanceof LinearGradient) {
            paint3 = (LinearGradient)paint;
            if (paint2 instanceof LinearGradient) {
                LinearGradient linearGradient = (LinearGradient)paint2;
                return ((LinearGradient)paint3).interpolate(linearGradient, d);
            }
            if (paint2 instanceof Color) {
                Color color = (Color)paint2;
                return ((LinearGradient)paint3).interpolate(InterpolationUtils.newSolidGradient((LinearGradient)paint3, color), d);
            }
        }
        if (paint instanceof RadialGradient) {
            paint3 = (RadialGradient)paint;
            if (paint2 instanceof RadialGradient) {
                RadialGradient radialGradient = (RadialGradient)paint2;
                return ((RadialGradient)paint3).interpolate(radialGradient, d);
            }
            if (paint2 instanceof Color) {
                Color color = (Color)paint2;
                return ((RadialGradient)paint3).interpolate(InterpolationUtils.newSolidGradient((RadialGradient)paint3, color), d);
            }
        }
        if (paint instanceof ImagePattern) {
            paint3 = (ImagePattern)paint;
            if (paint2 instanceof ImagePattern) {
                ImagePattern imagePattern = (ImagePattern)paint2;
                return ((ImagePattern)paint3).interpolate(imagePattern, d);
            }
        }
        return d < 0.5 ? paint : paint2;
    }

    public static LinearGradient newSolidGradient(LinearGradient linearGradient, Color color) {
        return new LinearGradient(linearGradient.getStartX(), linearGradient.getStartY(), linearGradient.getEndX(), linearGradient.getEndY(), linearGradient.isProportional(), linearGradient.getCycleMethod(), List.of(new Stop(0.0, color), new Stop(1.0, color)));
    }

    public static RadialGradient newSolidGradient(RadialGradient radialGradient, Color color) {
        return new RadialGradient(radialGradient.getFocusAngle(), radialGradient.getFocusDistance(), radialGradient.getCenterX(), radialGradient.getCenterY(), radialGradient.getRadius(), radialGradient.isProportional(), radialGradient.getCycleMethod(), List.of(new Stop(0.0, color), new Stop(1.0, color)));
    }
}

