/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.FloatPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableFloatProperty
extends FloatPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableFloatProperty() {
    }

    public StyleableFloatProperty(float f) {
        super(f);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        float f;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        float f2 = f = number != null ? number.floatValue() : 0.0f;
        if (transitionDefinition == null) {
            this.set(f);
        } else if (this.mediator == null || this.mediator.endValue != f) {
            this.mediator = new TransitionMediatorImpl(this.get(), f);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    @Override
    public void set(float f) {
        super.set(f);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final float startValue;
        private final float endValue;
        private float reversingAdjustedStartValue;

        public TransitionMediatorImpl(float f, float f2) {
            this.startValue = f;
            this.endValue = f2;
            this.reversingAdjustedStartValue = f;
        }

        @Override
        public void onUpdate(double d) {
            StyleableFloatProperty.super.set(d < 1.0 ? this.startValue + (this.endValue - this.startValue) * (float)d : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableFloatProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableFloatProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

