/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassViewEventHandler;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.PresentingPainter;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.UploadingPainter;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewSceneOverlay;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.GraphicsPipeline;
import java.nio.ByteOrder;
import javafx.scene.Parent;
import javafx.scene.Scene;

class ViewScene
extends GlassScene {
    private static final String UNSUPPORTED_FORMAT = "Transparent windows only supported for BYTE_BGRA_PRE format on LITTLE_ENDIAN machines";
    private Scene scene;
    private View platformView;
    private ViewPainter painter;
    private PaintRenderJob paintRenderJob;
    private ViewSceneOverlay viewSceneOverlay;
    private Parent overlayRoot;

    public ViewScene(Scene scene, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.scene = scene;
        this.platformView = Application.GetApplication().createView();
        this.platformView.setEventHandler(new GlassViewEventHandler(this));
    }

    @Override
    protected boolean isSynchronous() {
        return this.painter != null && this.painter instanceof PresentingPainter;
    }

    @Override
    protected View getPlatformView() {
        return this.platformView;
    }

    ViewPainter getPainter() {
        return this.painter;
    }

    @Override
    public void setStage(GlassStage glassStage) {
        super.setStage(glassStage);
        if (glassStage != null) {
            WindowStage windowStage = (WindowStage)glassStage;
            if (windowStage.needsUpdateWindow() || GraphicsPipeline.getPipeline().isUploading()) {
                if (Pixels.getNativeFormat() != 1 || ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                    throw new UnsupportedOperationException(UNSUPPORTED_FORMAT);
                }
                this.painter = new UploadingPainter(this);
            } else {
                this.painter = new PresentingPainter(this);
            }
            if (this.scene != null) {
                this.viewSceneOverlay = new ViewSceneOverlay(this.scene, this.painter);
                this.viewSceneOverlay.setRoot(this.overlayRoot);
            } else {
                this.viewSceneOverlay = null;
            }
            this.painter.setRoot(this.getRoot());
            this.paintRenderJob = new PaintRenderJob(this, PaintCollector.getInstance().getRendered(), this.painter);
        }
    }

    WindowStage getWindowStage() {
        return (WindowStage)this.getStage();
    }

    @Override
    public void dispose() {
        if (this.platformView != null) {
            QuantumToolkit.runWithRenderLock(() -> {
                this.platformView.close();
                this.platformView = null;
                this.updateSceneState();
                this.painter = null;
                this.paintRenderJob = null;
                this.scene = null;
                if (this.viewSceneOverlay != null) {
                    this.viewSceneOverlay.dispose();
                    this.viewSceneOverlay = null;
                }
                return null;
            });
        }
        super.dispose();
    }

    @Override
    public void setRoot(NGNode nGNode) {
        super.setRoot(nGNode);
        if (this.painter != null) {
            this.painter.setRoot(nGNode);
        }
    }

    @Override
    public void setCursor(Object object) {
        super.setCursor(object);
        Application.invokeLater(() -> {
            Window window;
            CursorFrame cursorFrame = (CursorFrame)object;
            Cursor cursor = CursorUtils.getPlatformCursor(cursorFrame);
            if (this.platformView != null && (window = this.platformView.getWindow()) != null) {
                window.setCursor(cursor);
            }
        });
    }

    @Override
    void repaint() {
        if (this.platformView == null) {
            return;
        }
        if (!this.setPainting(true)) {
            Toolkit toolkit = Toolkit.getToolkit();
            toolkit.addRenderJob(this.paintRenderJob);
        }
    }

    @Override
    public void enableInputMethodEvents(boolean bl) {
        this.platformView.enableInputMethodEvents(bl);
    }

    @Override
    public void finishInputMethodComposition() {
        this.platformView.finishInputMethodComposition();
    }

    @Override
    public void reapplyOverlayCSS() {
        if (this.viewSceneOverlay != null) {
            this.viewSceneOverlay.reapplyCSS();
        }
    }

    @Override
    public void processOverlayCSS() {
        if (this.viewSceneOverlay != null) {
            this.viewSceneOverlay.processCSS();
        }
    }

    @Override
    public void layoutOverlay() {
        if (this.viewSceneOverlay != null) {
            this.viewSceneOverlay.layout();
        }
    }

    @Override
    public void synchronizeOverlay() {
        if (this.viewSceneOverlay != null) {
            this.viewSceneOverlay.synchronize();
        }
    }

    public void setViewSize(float f, float f2) {
        this.sceneListener.changedSize(f, f2);
        if (this.viewSceneOverlay != null) {
            this.viewSceneOverlay.resize(f, f2);
        }
    }

    public void setOverlay(Parent parent) {
        this.overlayRoot = parent;
        if (this.viewSceneOverlay != null) {
            this.viewSceneOverlay.setRoot(parent);
        }
    }

    @Override
    public String toString() {
        View view = this.getPlatformView();
        return " scene: " + this.hashCode() + " @ (" + view.getWidth() + "," + view.getHeight() + ")";
    }
}

