/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import libKonogonka.fs.NCA.NCASectionTableBlock.BucketTreeHeader;
import libKonogonka.fs.NCA.NCASectionTableBlock.CompressionInfo;
import libKonogonka.fs.NCA.NCASectionTableBlock.MetaDataHashDataInfo;
import libKonogonka.fs.NCA.NCASectionTableBlock.SparseInfo;
import libKonogonka.fs.NCA.NCASectionTableBlock.SuperBlockIVFC;
import libKonogonka.fs.NCA.NCASectionTableBlock.SuperBlockPFS0;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NcaFsHeader {
    private static final Logger log = LogManager.getLogger(NcaFsHeader.class);
    private final byte[] version;
    private final byte fsType;
    private final byte hashType;
    private final byte cryptoType;
    private final byte metaDataHashType;
    private final byte[] padding;
    private SuperBlockIVFC superBlockIVFC;
    private SuperBlockPFS0 superBlockPFS0;
    private final long PatchInfoOffsetSection1;
    private final long PatchInfoSizeSection1;
    private final BucketTreeHeader BktrSection1;
    private final long PatchInfoOffsetSection2;
    private final long PatchInfoSizeSection2;
    private final BucketTreeHeader BktrSection2;
    private final byte[] generation;
    private final byte[] secureValue;
    private final byte[] sectionCTR;
    private final SparseInfo sparseInfo;
    private final CompressionInfo compressionInfo;
    private final MetaDataHashDataInfo metaDataHashDataInfo;
    private final byte[] unknownEndPadding;

    public NcaFsHeader(byte[] tableBlockBytes) throws Exception {
        if (tableBlockBytes.length != 512) {
            throw new Exception("Table Block Section size is incorrect.");
        }
        this.version = Arrays.copyOfRange(tableBlockBytes, 0, 2);
        this.fsType = tableBlockBytes[2];
        this.hashType = tableBlockBytes[3];
        this.cryptoType = tableBlockBytes[4];
        this.metaDataHashType = tableBlockBytes[6];
        this.padding = Arrays.copyOfRange(tableBlockBytes, 6, 8);
        byte[] superBlockBytes = Arrays.copyOfRange(tableBlockBytes, 8, 248);
        if (this.fsType == 0 && this.hashType == 3) {
            this.superBlockIVFC = new SuperBlockIVFC(superBlockBytes);
        } else if (this.fsType == 1 && this.hashType == 2) {
            this.superBlockPFS0 = new SuperBlockPFS0(superBlockBytes);
        }
        this.PatchInfoOffsetSection1 = Converter.getLElong(tableBlockBytes, 256);
        this.PatchInfoSizeSection1 = Converter.getLElong(tableBlockBytes, 264);
        this.BktrSection1 = new BucketTreeHeader(Arrays.copyOfRange(tableBlockBytes, 272, 288));
        this.PatchInfoOffsetSection2 = Converter.getLElong(tableBlockBytes, 288);
        this.PatchInfoSizeSection2 = Converter.getLElong(tableBlockBytes, 296);
        this.BktrSection2 = new BucketTreeHeader(Arrays.copyOfRange(tableBlockBytes, 304, 320));
        this.generation = Arrays.copyOfRange(tableBlockBytes, 320, 324);
        this.secureValue = Arrays.copyOfRange(tableBlockBytes, 324, 328);
        this.sectionCTR = Converter.flip(Arrays.copyOfRange(tableBlockBytes, 320, 328));
        this.sparseInfo = new SparseInfo(Arrays.copyOfRange(tableBlockBytes, 328, 376));
        this.compressionInfo = new CompressionInfo(Arrays.copyOfRange(tableBlockBytes, 376, 416));
        this.metaDataHashDataInfo = new MetaDataHashDataInfo(Arrays.copyOfRange(tableBlockBytes, 416, 464));
        this.unknownEndPadding = Arrays.copyOfRange(tableBlockBytes, 464, 512);
    }

    public byte[] getVersion() {
        return this.version;
    }

    public byte getFsType() {
        return this.fsType;
    }

    public byte getHashType() {
        return this.hashType;
    }

    public byte getCryptoType() {
        return this.cryptoType;
    }

    public byte getMetaDataHashType() {
        return this.metaDataHashType;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public SuperBlockIVFC getSuperBlockIVFC() {
        return this.superBlockIVFC;
    }

    public SuperBlockPFS0 getSuperBlockPFS0() {
        return this.superBlockPFS0;
    }

    public long getPatchInfoOffsetSection1() {
        return this.PatchInfoOffsetSection1;
    }

    public long getPatchInfoSizeSection1() {
        return this.PatchInfoSizeSection1;
    }

    public String getPatchInfoMagicSection1() {
        return this.BktrSection1.getMagic();
    }

    public int getPatchInfoVersionSection1() {
        return this.BktrSection1.getVersion();
    }

    public int getEntryCountSection1() {
        return this.BktrSection1.getEntryCount();
    }

    public byte[] getPatchInfoUnknownSection1() {
        return this.BktrSection1.getUnknown();
    }

    public long getPatchInfoOffsetSection2() {
        return this.PatchInfoOffsetSection2;
    }

    public long getPatchInfoSizeSection2() {
        return this.PatchInfoSizeSection2;
    }

    public String getPatchInfoMagicSection2() {
        return this.BktrSection2.getMagic();
    }

    public int getPatchInfoVersionSection2() {
        return this.BktrSection2.getVersion();
    }

    public int getEntryCountSection2() {
        return this.BktrSection2.getEntryCount();
    }

    public byte[] getPatchInfoUnknownSection2() {
        return this.BktrSection2.getUnknown();
    }

    public byte[] getGeneration() {
        return this.generation;
    }

    public byte[] getSecureValue() {
        return this.secureValue;
    }

    public byte[] getSectionCTR() {
        return this.sectionCTR;
    }

    public SparseInfo getSparseInfo() {
        return this.sparseInfo;
    }

    public CompressionInfo getCompressionInfo() {
        return this.compressionInfo;
    }

    public MetaDataHashDataInfo getMetaDataHashDataInfo() {
        return this.metaDataHashDataInfo;
    }

    public byte[] getUnknownEndPadding() {
        return this.unknownEndPadding;
    }

    public void printDebug() {
        String cryptoTypeDescription;
        String hashTypeDescription;
        switch (this.hashType) {
            case 0: {
                hashTypeDescription = "Auto";
                break;
            }
            case 1: {
                hashTypeDescription = "None";
                break;
            }
            case 2: {
                hashTypeDescription = "HierarchicalSha256Hash";
                break;
            }
            case 3: {
                hashTypeDescription = "HierarchicalIntegrityHash";
                break;
            }
            case 4: {
                hashTypeDescription = "AutoSha3";
                break;
            }
            case 5: {
                hashTypeDescription = "HierarchicalSha3256Hash";
                break;
            }
            case 6: {
                hashTypeDescription = "HierarchicalIntegritySha3Hash";
                break;
            }
            default: {
                hashTypeDescription = "???";
            }
        }
        switch (this.cryptoType) {
            case 0: {
                cryptoTypeDescription = "Auto";
                break;
            }
            case 1: {
                cryptoTypeDescription = "None";
                break;
            }
            case 2: {
                cryptoTypeDescription = "AesXts";
                break;
            }
            case 3: {
                cryptoTypeDescription = "AesCtr";
                break;
            }
            case 4: {
                cryptoTypeDescription = "AesCtrEx";
                break;
            }
            case 5: {
                cryptoTypeDescription = "AesCtrSkipLayerHash";
                break;
            }
            case 6: {
                cryptoTypeDescription = "AesCtrExSkipLayerHash";
                break;
            }
            default: {
                cryptoTypeDescription = "???";
            }
        }
        log.debug("NCASectionBlock:\nVersion                          : " + Converter.byteArrToHexStringAsLE(this.version) + "\nFS Type                          : " + this.fsType + (this.fsType == 0 ? " (RomFS)" : (this.fsType == 1 ? " (PartitionFS)" : " (Unknown)")) + "\nHash Type                        : " + this.hashType + " (" + hashTypeDescription + ")\nCrypto Type                      : " + this.cryptoType + " (" + cryptoTypeDescription + ")\nMeta Data Hash Type              : " + this.metaDataHashType + "\nPadding                          : " + Converter.byteArrToHexStringAsLE(this.padding) + "\nSuper Block IVFC                 : " + (this.superBlockIVFC == null ? "-\n" : "YES\n") + "Super Block PFS0                 : " + (this.superBlockPFS0 == null ? "-\n" : "YES\n") + "================================================================================================\n" + (this.fsType == 0 && this.hashType == 3 ? "|                   Hash Data - RomFS\n| Magic                          : " + this.superBlockIVFC.getMagic() + "\n| Version                        : " + this.superBlockIVFC.getVersion() + "\n| Master Hash Size               : " + this.superBlockIVFC.getMasterHashSize() + "\n|   Total Number of Levels       : " + this.superBlockIVFC.getTotalNumberOfLevels() + "\n\n|     Level 1 Offset             : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl1Offset()) + "\n|     Level 1 Size               : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl1Size()) + "\n|     Level 1 Block Size (log2)  : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl1SBlockSize()) + "\n|     Level 1 reserved           : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReserved1()) + "\n\n|     Level 2 Offset             : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl2Offset()) + "\n|     Level 2 Size               : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl2Size()) + "\n|     Level 2 Block Size (log2)  : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl2SBlockSize()) + "\n|     Level 2 reserved           : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReserved2()) + "\n\n|     Level 3 Offset             : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl3Offset()) + "\n|     Level 3 Size               : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl3Size()) + "\n|     Level 3 Block Size (log2)  : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl3SBlockSize()) + "\n|     Level 3 reserved           : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReserved3()) + "\n\n|     Level 4 Offset             : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl4Offset()) + "\n|     Level 4 Size               : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl4Size()) + "\n|     Level 4 Block Size (log2)  : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl4SBlockSize()) + "\n|     Level 4 reserved           : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReserved4()) + "\n\n|     Level 5 Offset             : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl5Offset()) + "\n|     Level 5 Size               : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl5Size()) + "\n|     Level 5 Block Size (log2)  : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl5SBlockSize()) + "\n|     Level 5 reserved           : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReserved5()) + "\n\n|     Level 6 Offset             : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl6Offset()) + "\n|     Level 6 Size               : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl6Size()) + "\n|     Level 6 Block Size (log2)  : " + RainbowDump.formatDecHexString(this.superBlockIVFC.getLvl6SBlockSize()) + "\n|     Level 6 reserved           : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReserved6()) + "\n\n|   SignatureSalt                : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getSignatureSalt()) + "\n| Master Hash                    : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getMasterHash()) + "\n| Reserved (tail)                : " + Converter.byteArrToHexStringAsLE(this.superBlockIVFC.getReservedTail()) + "\n" : (this.fsType == 1 && this.hashType == 2 ? "|                   Hash Data - PFS0\n| SHA256 hash                    : " + Converter.byteArrToHexStringAsLE(this.superBlockPFS0.getSHA256hash()) + "\n| Block Size (bytes)             : " + this.superBlockPFS0.getBlockSize() + "\n| Layer Count (2)                : " + this.superBlockPFS0.getLayerCount() + "\n| Hash table offset              : " + RainbowDump.formatDecHexString(this.superBlockPFS0.getHashTableOffset()) + "\n| Hash table size                : " + RainbowDump.formatDecHexString(this.superBlockPFS0.getHashTableSize()) + "\n| PFS0 header offset             : " + RainbowDump.formatDecHexString(this.superBlockPFS0.getPfs0offset()) + "\n| PFS0 header size               : " + RainbowDump.formatDecHexString(this.superBlockPFS0.getPfs0size()) + "\n| Unknown (reserved)             : " + Converter.byteArrToHexStringAsLE(this.superBlockPFS0.getZeroes()) + "\n" : "               //    Hash Data - EMPTY     \\\\ \n")) + "================================================================================================\n                    PatchInfo\n================================================================================================\nIndirect Offset                  : " + this.PatchInfoOffsetSection1 + "\nIndirect Size                    : " + this.PatchInfoSizeSection1 + "\nMagic ('BKTR')                   : " + this.BktrSection1.getMagic() + "\nVersion                          : " + this.BktrSection1.getVersion() + "\nEntryCount                       : " + this.BktrSection1.getEntryCount() + "\nUnknown (reserved)               : " + Converter.byteArrToHexStringAsLE(this.BktrSection1.getUnknown()) + "\n------------------------------------------------------------------------------------------------\nAesCtrEx Offset                  : " + this.PatchInfoOffsetSection2 + "\nAesCtrEx Size                    : " + this.PatchInfoSizeSection2 + "\nMagic ('BKTR')                   : " + this.BktrSection2.getMagic() + "\nVersion                          : " + this.BktrSection2.getVersion() + "\nEntryCount                       : " + this.BktrSection2.getEntryCount() + "\nUnknown (reserved)               : " + Converter.byteArrToHexStringAsLE(this.BktrSection2.getUnknown()) + "\n================================================================================================\nGeneration                       : " + Converter.byteArrToHexStringAsLE(this.generation) + "\nSection CTR                      : " + Converter.byteArrToHexStringAsLE(this.sectionCTR) + "\n================================================================================================\n                    Sparse Info\nTable Offset                     : " + this.sparseInfo.getOffset() + "\nTable Size                       : " + this.sparseInfo.getSize() + "\nMagic ('BKTR')                   : " + this.sparseInfo.getBktrMagic() + "\nVersion                          : " + this.sparseInfo.getBktrVersion() + "\nEntryCount                       : " + this.sparseInfo.getBktrEntryCount() + "\nUnknown (BKTR)                   : " + Converter.byteArrToHexStringAsLE(this.sparseInfo.getBktrUnknown()) + "\nPhysicalOffset                   : " + this.sparseInfo.getPhysicalOffset() + "\nGeneration                       : " + Converter.byteArrToHexStringAsLE(this.sparseInfo.getGeneration()) + "\nUnknown (reserved)               : " + Converter.byteArrToHexStringAsLE(this.sparseInfo.getUnknown()) + "\n================================================================================================\n                    Compression Info\nTable Offset                     : " + this.compressionInfo.getOffset() + "\nTable Size                       : " + this.compressionInfo.getSize() + "\nMagic ('BKTR')                   : " + this.compressionInfo.getBktrMagic() + "\nVersion                          : " + this.compressionInfo.getBktrVersion() + "\nEntryCount                       : " + this.compressionInfo.getBktrEntryCount() + "\nUnknown (reserved)               : " + Converter.byteArrToHexStringAsLE(this.compressionInfo.getBktrUnknown()) + "\nReserved                         : " + Converter.byteArrToHexStringAsLE(this.compressionInfo.getUnknown()) + "\n================================================================================================\n                    Meta Data Hash Data Info\nTable Offset                     : " + this.metaDataHashDataInfo.getOffset() + "\nTable Size                       : " + this.metaDataHashDataInfo.getSize() + "\nUnknown (reserved)               : " + Converter.byteArrToHexStringAsLE(this.metaDataHashDataInfo.getTableHash()) + "\n================================================================================================\nUnknown End Padding              : " + Converter.byteArrToHexStringAsLE(this.unknownEndPadding) + "\n################################################################################################\n");
        this.sparseInfo.printDebug();
        this.compressionInfo.printDebug();
        this.metaDataHashDataInfo.printDebug();
    }
}

