/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NPDM.ACI0;

import java.util.Arrays;
import libKonogonka.Converter;

public class FSAccessHeaderProvider {
    private final byte version;
    private final byte[] padding;
    private final long permissionsBitmask;
    private final int dataSize;
    private final int contentOwnIdSectionSize;
    private final int dataOwnerSizes;
    private final int saveDataOwnSectionSize;
    private final byte[] unknownData;

    public FSAccessHeaderProvider(byte[] bytes) {
        this.version = bytes[0];
        this.padding = Arrays.copyOfRange(bytes, 1, 4);
        this.permissionsBitmask = Converter.getLElong(bytes, 4);
        this.dataSize = Converter.getLEint(bytes, 12);
        this.contentOwnIdSectionSize = Converter.getLEint(bytes, 16);
        this.dataOwnerSizes = Converter.getLEint(bytes, 20);
        this.saveDataOwnSectionSize = Converter.getLEint(bytes, 24);
        this.unknownData = Arrays.copyOfRange(bytes, 28, bytes.length);
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public long getPermissionsBitmask() {
        return this.permissionsBitmask;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getContentOwnIdSectionSize() {
        return this.contentOwnIdSectionSize;
    }

    public int getDataNownerSizes() {
        return this.dataOwnerSizes;
    }

    public int getSaveDataOwnSectionSize() {
        return this.saveDataOwnSectionSize;
    }

    public byte[] getUnknownData() {
        return this.unknownData;
    }
}

