/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import libKonogonka.Converter;
import libKonogonka.fs.RomFs.view.FileSystemTreeViewMaker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileSystemEntry {
    private static final Logger log = LogManager.getLogger(FileSystemEntry.class);
    private boolean directoryFlag;
    private String name;
    private final List<FileSystemEntry> content;
    private static byte[] dirsMetadataTable;
    private static byte[] filesMetadataTable;
    private long offset;
    private long size;

    public FileSystemEntry(byte[] dirsMetadataTable, byte[] filesMetadataTable) throws Exception {
        FileSystemEntry.dirsMetadataTable = dirsMetadataTable;
        FileSystemEntry.filesMetadataTable = filesMetadataTable;
        this.content = new ArrayList<FileSystemEntry>();
        this.directoryFlag = true;
        DirectoryMetaData rootDirectoryMetaData = new DirectoryMetaData();
        this.name = rootDirectoryMetaData.dirName.isEmpty() ? "ROOT" : rootDirectoryMetaData.dirName;
        if (rootDirectoryMetaData.parentDirectoryOffset != 0) {
            throw new Exception("Offset of Parent Directory is incorrect. Expected 0 for root, received value is " + rootDirectoryMetaData.parentDirectoryOffset);
        }
        if (rootDirectoryMetaData.nextSiblingDirectoryOffset != -1) {
            throw new Exception("Offset of next Sibling Directory is incorrect. Expected -1 for root, received value is " + rootDirectoryMetaData.nextSiblingDirectoryOffset);
        }
        if (rootDirectoryMetaData.firstSubdirectoryOffset != -1) {
            this.content.add(this.getDirectory(rootDirectoryMetaData.firstSubdirectoryOffset));
        }
        if (rootDirectoryMetaData.firstFileOffset != -1) {
            this.content.add(this.getFile(this, rootDirectoryMetaData.firstFileOffset));
        }
        this.content.sort(Comparator.comparingLong(FileSystemEntry::getOffset));
    }

    private FileSystemEntry() {
        this.content = new ArrayList<FileSystemEntry>();
    }

    private FileSystemEntry getDirectory(int childDirMetaPosition) {
        FileSystemEntry fileSystemEntry = new FileSystemEntry();
        fileSystemEntry.directoryFlag = true;
        DirectoryMetaData directoryMetaData = new DirectoryMetaData(childDirMetaPosition);
        fileSystemEntry.name = directoryMetaData.dirName;
        if (directoryMetaData.nextSiblingDirectoryOffset != -1) {
            this.content.add(this.getDirectory(directoryMetaData.nextSiblingDirectoryOffset));
        }
        if (directoryMetaData.firstSubdirectoryOffset != -1) {
            fileSystemEntry.content.add(this.getDirectory(directoryMetaData.firstSubdirectoryOffset));
        }
        if (directoryMetaData.firstFileOffset != -1) {
            fileSystemEntry.content.add(this.getFile(fileSystemEntry, directoryMetaData.firstFileOffset));
        }
        fileSystemEntry.content.sort(Comparator.comparingLong(FileSystemEntry::getOffset));
        return fileSystemEntry;
    }

    private FileSystemEntry getFile(FileSystemEntry directoryContainer, int childFileMetaPosition) {
        FileSystemEntry fileSystemEntry = new FileSystemEntry();
        fileSystemEntry.directoryFlag = false;
        FileMetaData fileMetaData = new FileMetaData(childFileMetaPosition);
        fileSystemEntry.name = fileMetaData.fileName;
        fileSystemEntry.offset = fileMetaData.fileDataRealOffset;
        fileSystemEntry.size = fileMetaData.fileDataRealLength;
        if (fileMetaData.nextSiblingFileOffset != -1) {
            directoryContainer.content.add(this.getFile(directoryContainer, fileMetaData.nextSiblingFileOffset));
        }
        return fileSystemEntry;
    }

    public boolean isDirectory() {
        return this.directoryFlag;
    }

    public boolean isFile() {
        return !this.directoryFlag;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public List<FileSystemEntry> getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public void printTreeForDebug(int spacerForSizes) {
        log.debug(FileSystemTreeViewMaker.make(this.content, spacerForSizes));
    }

    public void printTreeForDebug() {
        log.debug(FileSystemTreeViewMaker.make(this.content, 100));
    }

    private static class FileMetaData {
        private final int nextSiblingFileOffset;
        private final long fileDataRealOffset;
        private final long fileDataRealLength;
        private final int nextHashTableBucketFileOffset;
        private String fileName;

        private FileMetaData() {
            this(0);
        }

        private FileMetaData(int childFileMetaPosition) {
            int i = childFileMetaPosition;
            this.nextSiblingFileOffset = Converter.getLEint(filesMetadataTable, i += 4);
            this.fileDataRealOffset = Converter.getLElong(filesMetadataTable, i += 4);
            this.fileDataRealLength = Converter.getLElong(filesMetadataTable, i += 8);
            this.nextHashTableBucketFileOffset = Converter.getLEint(filesMetadataTable, i += 8);
            int fileNameLength = Converter.getLEint(filesMetadataTable, i += 4);
            if (fileNameLength > 0) {
                i += 4;
                this.fileName = "";
                try {
                    this.fileName = new String(Arrays.copyOfRange(filesMetadataTable, i, i + fileNameLength), StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    log.debug("fileName sizes are: " + filesMetadataTable.length + "\t" + i + "\t" + i + fileNameLength + "\t\t" + this.nextHashTableBucketFileOffset, (Throwable)e);
                }
            } else {
                this.fileName = "";
            }
        }
    }

    private static class DirectoryMetaData {
        private final int parentDirectoryOffset;
        private final int nextSiblingDirectoryOffset;
        private final int firstSubdirectoryOffset;
        private final int firstFileOffset;
        private final int nextHashTableBucketDirectoryOffset;
        private final String dirName;

        private DirectoryMetaData() {
            this(0);
        }

        private DirectoryMetaData(int childDirMetaPosition) {
            int i = childDirMetaPosition;
            this.parentDirectoryOffset = Converter.getLEint(dirsMetadataTable, i);
            this.nextSiblingDirectoryOffset = Converter.getLEint(dirsMetadataTable, i += 4);
            this.firstSubdirectoryOffset = Converter.getLEint(dirsMetadataTable, i += 4);
            this.firstFileOffset = Converter.getLEint(dirsMetadataTable, i += 4);
            this.nextHashTableBucketDirectoryOffset = Converter.getLEint(dirsMetadataTable, i += 4);
            int dirNameLength = Converter.getLEint(dirsMetadataTable, i += 4);
            this.dirName = dirNameLength > 0 ? new String(Arrays.copyOfRange(dirsMetadataTable, i += 4, i + dirNameLength), StandardCharsets.UTF_8) : "";
        }

        private int getRealNameSize(int value) {
            if (value % 4 == 0) {
                return value;
            }
            return value + 4 - value % 4;
        }
    }
}

