/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs;

import java.io.BufferedInputStream;
import libKonogonka.Converter;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.RomFs.FileSystemEntry;
import libKonogonka.fs.RomFs.Level6Header;

public class RomFsConstruct {
    private Level6Header header;
    private FileSystemEntry rootEntry;
    private final BufferedInputStream stream;
    private int headerSize;
    private byte[] directoryMetadataTable;
    private byte[] fileMetadataTable;
    private final long offsetPositionInFile;
    private final long level6Offset;

    RomFsConstruct(InFileStreamProducer producer, long level6Offset) throws Exception {
        this(producer, level6Offset, 0L);
    }

    RomFsConstruct(InFileStreamProducer producer, long level6Offset, long offsetPositionInFile) throws Exception {
        if (level6Offset < 0L) {
            throw new Exception("Incorrect Level 6 Offset");
        }
        this.level6Offset = level6Offset;
        this.stream = producer.produce();
        this.offsetPositionInFile = offsetPositionInFile;
        this.goToStartingPosition();
        this.constructHeader();
        this.directoryMetadataTableLengthCheck();
        this.directoryMetadataTableConstruct();
        this.fileMetadataTableLengthCheck();
        this.fileMetadataTableConstruct();
        this.constructRootFilesystemEntry();
        this.stream.close();
    }

    private void goToStartingPosition() throws Exception {
        this.skipBytes(this.offsetPositionInFile + this.level6Offset);
    }

    private void constructHeader() throws Exception {
        byte[] headerSizeBytes = this.detectHeaderSize();
        byte[] rawDataChunk = new byte[this.headerSize - 8];
        if (this.stream.read(rawDataChunk) != this.headerSize - 8) {
            throw new Exception(String.format("Failed to read header (0x%x)", this.headerSize - 8));
        }
        byte[] lv6headerBytes = new byte[this.headerSize];
        System.arraycopy(headerSizeBytes, 0, lv6headerBytes, 0, 8);
        System.arraycopy(rawDataChunk, 0, lv6headerBytes, 8, this.headerSize - 8);
        this.header = new Level6Header(lv6headerBytes);
    }

    private byte[] detectHeaderSize() throws Exception {
        byte[] lv6HeaderSizeRaw = new byte[8];
        if (this.stream.read(lv6HeaderSizeRaw) != 8) {
            throw new Exception("Failed to read header size");
        }
        this.headerSize = Converter.getLEint(lv6HeaderSizeRaw, 0);
        return lv6HeaderSizeRaw;
    }

    private void directoryMetadataTableLengthCheck() throws Exception {
        if (this.header.getDirectoryMetadataTableLength() < 0L) {
            throw new Exception("Not supported: DirectoryMetadataTableLength < 0");
        }
    }

    private void directoryMetadataTableConstruct() throws Exception {
        this.skipBytes(this.header.getDirectoryMetadataTableOffset() - (long)this.headerSize);
        this.directoryMetadataTable = new byte[(int)this.header.getDirectoryMetadataTableLength()];
        if (this.stream.read(this.directoryMetadataTable) != (int)this.header.getDirectoryMetadataTableLength()) {
            throw new Exception("Failed to read " + this.header.getDirectoryMetadataTableLength());
        }
    }

    private void fileMetadataTableLengthCheck() throws Exception {
        if (this.header.getFileMetadataTableLength() < 0L) {
            throw new Exception("Not supported: FileMetadataTableLength < 0");
        }
    }

    private void fileMetadataTableConstruct() throws Exception {
        this.skipBytes(this.header.getFileMetadataTableOffset() - this.header.getFileHashTableOffset());
        this.fileMetadataTable = new byte[(int)this.header.getFileMetadataTableLength()];
        if (this.stream.read(this.fileMetadataTable) != (int)this.header.getFileMetadataTableLength()) {
            throw new Exception("Failed to read " + this.header.getFileMetadataTableLength());
        }
    }

    private void constructRootFilesystemEntry() throws Exception {
        this.rootEntry = new FileSystemEntry(this.directoryMetadataTable, this.fileMetadataTable);
    }

    private void skipBytes(long size) throws Exception {
        long mustSkip = size;
        long skipped = 0L;
        while (mustSkip > 0L) {
            mustSkip = size - (skipped += this.stream.skip(mustSkip));
        }
    }

    Level6Header getHeader() {
        return this.header;
    }

    FileSystemEntry getRootEntry() {
        return this.rootEntry;
    }

    byte[] getDirectoryMetadataTable() {
        return this.directoryMetadataTable;
    }

    byte[] getFileMetadataTable() {
        return this.fileMetadataTable;
    }
}

