/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.xtsaes;

import java.util.Arrays;
import java.util.Objects;
import libKonogonka.xtsaes.XTSTweak;
import net.jcip.annotations.NotThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;

@NotThreadSafe
class XTSCore {
    private static final int BLOCK_SIZE = 16;
    private final BlockCipher cipher;
    private final XTSTweak tweak;
    private boolean forEncryption;

    XTSCore(BlockCipher cipher, XTSTweak tweak) {
        this.cipher = Objects.requireNonNull(cipher, "cipher");
        this.tweak = Objects.requireNonNull(tweak, "tweak");
    }

    XTSCore(XTSTweak tweak) {
        this(new AESEngine(), tweak);
    }

    XTSCore(boolean isDefault) {
        this(new XTSTweak(isDefault));
    }

    XTSCore init(boolean forEncryption, KeyParameter key) throws IllegalArgumentException {
        byte[] k = key.getKey();
        if (k.length != 32 && k.length != 64) {
            throw new IllegalArgumentException("bad key length: " + k.length);
        }
        byte[] key1 = Arrays.copyOfRange(k, 0, k.length / 2);
        byte[] key2 = Arrays.copyOfRange(k, k.length / 2, k.length);
        return this.init(forEncryption, new KeyParameter(key1), new KeyParameter(key2));
    }

    XTSCore init(boolean forEncryption, KeyParameter key1, KeyParameter key2) throws IllegalArgumentException {
        this.cipher.init(forEncryption, key1);
        this.tweak.init(key2);
        this.forEncryption = forEncryption;
        return this;
    }

    XTSCore reset(long tweakValue) throws DataLengthException, IllegalStateException {
        this.tweak.reset(tweakValue);
        return this;
    }

    String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    int getBlockSize() {
        return 16;
    }

    int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        byte[] tweakValue = this.tweak.value();
        this.doProcessBlock(in, inOff, out, outOff, tweakValue);
        this.tweak.next();
        return 16;
    }

    int doProcessBlock(byte[] in, int inOff, byte[] out, int outOff, byte[] tweakValue) throws DataLengthException, IllegalStateException {
        this.merge(in, inOff, out, outOff, tweakValue);
        this.cipher.processBlock(out, outOff, out, outOff);
        this.merge(out, outOff, out, outOff, tweakValue);
        return 16;
    }

    void merge(byte[] in, int inOff, byte[] out, int outOff, byte[] tweak) {
        for (int i = 0; i < 16; ++i) {
            out[i + outOff] = (byte)(in[i + inOff] ^ tweak[i]);
        }
    }

    int processPartial(byte[] in, int inOff, byte[] out, int outOff, int length) {
        if (length <= 16) {
            throw new DataLengthException("input buffer too small/ missing last two blocks: " + length);
        }
        if (length >= 32) {
            throw new DataLengthException("input buffer too large/ non-partial final block: " + length);
        }
        byte[] tweakA = this.tweak.value();
        byte[] tweakB = this.tweak.next().value();
        return this.forEncryption ? this.doProcessPartial(in, inOff, out, outOff, length, tweakA, tweakB) : this.doProcessPartial(in, inOff, out, outOff, length, tweakB, tweakA);
    }

    int doProcessPartial(byte[] in, int inOff, byte[] out, int outOff, int length, byte[] tweakA, byte[] tweakB) throws DataLengthException, IllegalStateException {
        this.doProcessBlock(in, inOff, out, outOff, tweakA);
        byte[] buffer = Arrays.copyOfRange(out, outOff, outOff + 16);
        System.arraycopy(in, inOff + 16, buffer, 0, length - 16);
        this.doProcessBlock(buffer, 0, buffer, 0, tweakB);
        System.arraycopy(out, outOff, out, outOff + 16, length - 16);
        System.arraycopy(buffer, 0, out, outOff, 16);
        return length;
    }
}

